/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import com.google.common.collect.SetMultimap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class CostLessRuleDispatcher
implements Dispatcher {
    private final SetMultimap<Integer, NodeProcessor> procRules;
    private final NodeProcessorCtx procCtx;
    private final NodeProcessor defaultProc;

    public CostLessRuleDispatcher(NodeProcessor defaultProc, SetMultimap<Integer, NodeProcessor> rules, NodeProcessorCtx procCtx) {
        this.defaultProc = defaultProc;
        this.procRules = rules;
        this.procCtx = procCtx;
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> ndStack, Object ... nodeOutputs) throws SemanticException {
        int nodeType = ((ASTNode)nd).getType();
        NodeProcessor processor = this.defaultProc;
        if (this.procRules.containsKey(nodeType)) {
            processor = (NodeProcessor)this.procRules.get((Object)((ASTNode)nd).getType()).iterator().next();
        }
        return processor.process(nd, ndStack, this.procCtx, nodeOutputs);
    }
}

