/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.write;

import java.util.HashMap;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriter;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

public class DataWritableWriteSupport
extends WriteSupport<ParquetHiveRecord> {
    public static final String PARQUET_HIVE_SCHEMA = "parquet.hive.schema";
    public static final String WRITER_TIMEZONE = "writer.time.zone";
    public static final String WRITER_DATE_PROLEPTIC = "writer.date.proleptic";
    private DataWritableWriter writer;
    private MessageType schema;
    private Configuration conf;
    private boolean defaultDateProleptic;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_HIVE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType(configuration.get(PARQUET_HIVE_SCHEMA));
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        this.conf = configuration;
        this.schema = DataWritableWriteSupport.getSchema(configuration);
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(WRITER_TIMEZONE, TimeZone.getDefault().toZoneId().toString());
        this.defaultDateProleptic = HiveConf.getBoolVar(configuration, HiveConf.ConfVars.HIVE_PARQUET_DATE_PROLEPTIC_GREGORIAN);
        metaData.put(WRITER_DATE_PROLEPTIC, String.valueOf(this.defaultDateProleptic));
        return new WriteSupport.WriteContext(this.schema, metaData);
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer = new DataWritableWriter(recordConsumer, this.schema, this.defaultDateProleptic, this.conf);
    }

    @Override
    public void write(ParquetHiveRecord record) {
        this.writer.write(record);
    }

    @Override
    public String getName() {
        return HiveVersionInfo.getVersion();
    }
}

