/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.io.parquet.convert.ETypeConverter;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.ParquetTimestampUtils;
import org.apache.hadoop.hive.ql.io.parquet.vector.ParquetDataColumnReader;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetDataColumnReaderFactory {
    private ParquetDataColumnReaderFactory() {
    }

    private static ParquetDataColumnReader getDataColumnReaderByTypeHelper(boolean isDictionary, PrimitiveType parquetType, TypeInfo hiveType, Dictionary dictionary, ValuesReader valuesReader, boolean skipTimestampConversion, ZoneId writerTimezone) throws IOException {
        int length = ParquetDataColumnReaderFactory.getVarcharLength(hiveType);
        TypeInfo realHiveType = hiveType instanceof ListTypeInfo ? ((ListTypeInfo)hiveType).getListElementTypeInfo() : hiveType;
        String typeName = TypeInfoUtils.getBaseName(realHiveType.getTypeName());
        int hivePrecision = typeName.equalsIgnoreCase("decimal") ? ((DecimalTypeInfo)realHiveType).getPrecision() : 0;
        int hiveScale = typeName.equalsIgnoreCase("decimal") ? ((DecimalTypeInfo)realHiveType).getScale() : 0;
        switch (parquetType.getPrimitiveTypeName()) {
            case INT32: {
                if (ETypeConverter.isUnsignedInteger(parquetType)) {
                    return isDictionary ? new TypesFromUInt32PageReader(dictionary, length, hivePrecision, hiveScale) : new TypesFromUInt32PageReader(valuesReader, length, hivePrecision, hiveScale);
                }
                if (parquetType.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)parquetType.getLogicalTypeAnnotation();
                    short scale = (short)logicalType.getScale();
                    return isDictionary ? new TypesFromInt32DecimalPageReader(dictionary, length, scale, hivePrecision, hiveScale) : new TypesFromInt32DecimalPageReader(valuesReader, length, scale, hivePrecision, hiveScale);
                }
                return isDictionary ? new TypesFromInt32PageReader(dictionary, length, hivePrecision, hiveScale) : new TypesFromInt32PageReader(valuesReader, length, hivePrecision, hiveScale);
            }
            case INT64: {
                LogicalTypeAnnotation logicalType = parquetType.getLogicalTypeAnnotation();
                if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
                    boolean isAdjustedToUTC = timestampLogicalType.isAdjustedToUTC();
                    LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalType.getUnit();
                    return isDictionary ? new TypesFromInt64PageReader(dictionary, length, isAdjustedToUTC, timeUnit) : new TypesFromInt64PageReader(valuesReader, length, isAdjustedToUTC, timeUnit);
                }
                if (ETypeConverter.isUnsignedInteger(parquetType)) {
                    return isDictionary ? new TypesFromUInt64PageReader(dictionary, length, hivePrecision, hiveScale) : new TypesFromUInt64PageReader(valuesReader, length, hivePrecision, hiveScale);
                }
                if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType;
                    short scale = (short)decimalLogicalType.getScale();
                    return isDictionary ? new TypesFromInt64DecimalPageReader(dictionary, length, scale, hivePrecision, hiveScale) : new TypesFromInt64DecimalPageReader(valuesReader, length, scale, hivePrecision, hiveScale);
                }
                return isDictionary ? new TypesFromInt64PageReader(dictionary, length, hivePrecision, hiveScale) : new TypesFromInt64PageReader(valuesReader, length, hivePrecision, hiveScale);
            }
            case FLOAT: {
                return isDictionary ? new TypesFromFloatPageReader(dictionary, length, hivePrecision, hiveScale) : new TypesFromFloatPageReader(valuesReader, length, hivePrecision, hiveScale);
            }
            case INT96: {
                return isDictionary ? new TypesFromInt96PageReader(dictionary, length, skipTimestampConversion, writerTimezone) : new TypesFromInt96PageReader(valuesReader, length, skipTimestampConversion, writerTimezone);
            }
            case BOOLEAN: {
                return isDictionary ? new TypesFromBooleanPageReader(dictionary, length) : new TypesFromBooleanPageReader(valuesReader, length);
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                return ParquetDataColumnReaderFactory.getConvertorFromBinary(isDictionary, parquetType, hiveType, valuesReader, dictionary);
            }
            case DOUBLE: {
                return isDictionary ? new TypesFromDoublePageReader(dictionary, length, hivePrecision, hiveScale) : new TypesFromDoublePageReader(valuesReader, length, hivePrecision, hiveScale);
            }
        }
        return isDictionary ? new DefaultParquetDataColumnReader(dictionary, length, hivePrecision, hiveScale) : new DefaultParquetDataColumnReader(valuesReader, length, hivePrecision, hiveScale);
    }

    private static ParquetDataColumnReader getConvertorFromBinary(final boolean isDict, PrimitiveType parquetType, TypeInfo hiveType, final ValuesReader valuesReader, final Dictionary dictionary) {
        int hiveScale;
        LogicalTypeAnnotation logicalType = parquetType.getLogicalTypeAnnotation();
        final int length = ParquetDataColumnReaderFactory.getVarcharLength(hiveType);
        TypeInfo realHiveType = hiveType instanceof ListTypeInfo ? ((ListTypeInfo)hiveType).getListElementTypeInfo() : (hiveType instanceof MapTypeInfo ? ((MapTypeInfo)hiveType).getMapValueTypeInfo() : hiveType);
        String typeName = TypeInfoUtils.getBaseName(realHiveType.getTypeName());
        final int hivePrecision = typeName.equalsIgnoreCase("decimal") ? ((DecimalTypeInfo)realHiveType).getPrecision() : 0;
        int n = hiveScale = typeName.equalsIgnoreCase("decimal") ? ((DecimalTypeInfo)realHiveType).getScale() : 0;
        if (logicalType == null) {
            return isDict ? new DefaultParquetDataColumnReader(dictionary, length) : new DefaultParquetDataColumnReader(valuesReader, length);
        }
        Optional<ParquetDataColumnReader> reader = parquetType.getLogicalTypeAnnotation().accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ParquetDataColumnReader>(){

            @Override
            public Optional<ParquetDataColumnReader> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalTypeAnnotation) {
                short scale = (short)logicalTypeAnnotation.getScale();
                return isDict ? Optional.of(new TypesFromDecimalPageReader(dictionary, length, scale, hivePrecision, hiveScale)) : Optional.of(new TypesFromDecimalPageReader(valuesReader, length, scale, hivePrecision, hiveScale));
            }

            @Override
            public Optional<ParquetDataColumnReader> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation logicalTypeAnnotation) {
                return isDict ? Optional.of(new TypesFromStringPageReader(dictionary, length)) : Optional.of(new TypesFromStringPageReader(valuesReader, length));
            }
        });
        if (reader.isPresent()) {
            return reader.get();
        }
        return isDict ? new DefaultParquetDataColumnReader(dictionary, length) : new DefaultParquetDataColumnReader(valuesReader, length);
    }

    public static ParquetDataColumnReader getDataColumnReaderByTypeOnDictionary(PrimitiveType parquetType, TypeInfo hiveType, Dictionary realReader, boolean skipTimestampConversion, ZoneId writerTimezone) throws IOException {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(true, parquetType, hiveType, realReader, null, skipTimestampConversion, writerTimezone);
    }

    public static ParquetDataColumnReader getDataColumnReaderByType(PrimitiveType parquetType, TypeInfo hiveType, ValuesReader realReader, boolean skipTimestampConversion, ZoneId writerTimezone) throws IOException {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(false, parquetType, hiveType, null, realReader, skipTimestampConversion, writerTimezone);
    }

    private static int getVarcharLength(TypeInfo hiveType) {
        int length = -1;
        if (hiveType instanceof PrimitiveTypeInfo) {
            PrimitiveTypeInfo hivePrimitiveType = (PrimitiveTypeInfo)hiveType;
            switch (hivePrimitiveType.getPrimitiveCategory()) {
                case CHAR: {
                    length = ((CharTypeInfo)hivePrimitiveType).getLength();
                    break;
                }
                case VARCHAR: {
                    length = ((VarcharTypeInfo)hivePrimitiveType).getLength();
                    break;
                }
            }
        }
        return length;
    }

    public static class TypesFromStringPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromStringPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromStringPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public byte[] readVarchar() {
            byte[] value = this.valuesReader.readBytes().getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            byte[] value = this.dict.decodeToBinary(id).getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readChar() {
            byte[] value = this.valuesReader.readBytes().getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readChar(int id) {
            byte[] value = this.dict.decodeToBinary(id).getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        private byte[] truncateIfNecesssary(byte[] bytes) {
            if (this.length <= 0 || bytes == null) {
                return bytes;
            }
            int len = bytes.length;
            int truncatedLength = StringExpr.truncate(bytes, 0, len, this.length);
            if (truncatedLength >= len) {
                return bytes;
            }
            return Arrays.copyOf(bytes, truncatedLength);
        }
    }

    public static class TypesFromInt64DecimalPageReader
    extends DefaultParquetDataColumnReader {
        private short scale;

        public TypesFromInt64DecimalPageReader(ValuesReader realReader, int length, short scale, int hivePrecision, int hiveScale) {
            super(realReader, length, hivePrecision, hiveScale);
            this.scale = scale;
        }

        public TypesFromInt64DecimalPageReader(Dictionary dict, int length, short scale, int hivePrecision, int hiveScale) {
            super(dict, length, hivePrecision, hiveScale);
            this.scale = scale;
        }

        @Override
        public byte[] readString() {
            return this.convertToBytes(this.valuesReader.readLong());
        }

        @Override
        public byte[] readString(int id) {
            return this.convertToBytes(this.dict.decodeToLong(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readLong()));
            return TypesFromInt64DecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToLong(id)));
            return TypesFromInt64DecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readLong()));
            return TypesFromInt64DecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToLong(id)));
            return TypesFromInt64DecimalPageReader.convertToBytes(value);
        }

        @Override
        public float readFloat() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readLong(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (float)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "float");
        }

        @Override
        public float readFloat(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToLong(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (float)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "float");
        }

        @Override
        public double readDouble() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readLong(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "double");
        }

        @Override
        public double readDouble(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToLong(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "double");
        }

        @Override
        public long readLong() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readLong(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "bigint");
        }

        @Override
        public long readLong(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToLong(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "bigint");
        }

        @Override
        public long readInteger() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readLong(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "int");
        }

        @Override
        public long readInteger(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToLong(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "int");
        }

        @Override
        public long readSmallInt() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readLong(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "smallint");
        }

        @Override
        public long readSmallInt(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToLong(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "smallint");
        }

        @Override
        public long readTinyInt() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readLong(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "tinyint");
        }

        @Override
        public long readTinyInt(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToLong(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "tinyint");
        }

        private String convertToString(long value) {
            HiveDecimal hiveDecimal = HiveDecimal.create(value, (int)this.scale);
            return hiveDecimal.toString();
        }

        private byte[] convertToBytes(long value) {
            return TypesFromInt64DecimalPageReader.convertToBytes(this.convertToString(value));
        }

        @Override
        public byte[] readDecimal() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readLong(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return super.validatedScaledDecimal(this.scale);
        }

        @Override
        public byte[] readDecimal(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToLong(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return super.validatedScaledDecimal(this.scale);
        }
    }

    public static class TypesFromInt32DecimalPageReader
    extends DefaultParquetDataColumnReader {
        private short scale;

        public TypesFromInt32DecimalPageReader(ValuesReader realReader, int length, short scale, int hivePrecision, int hiveScale) {
            super(realReader, length, hivePrecision, hiveScale);
            this.scale = scale;
        }

        public TypesFromInt32DecimalPageReader(Dictionary dict, int length, short scale, int hivePrecision, int hiveScale) {
            super(dict, length, hivePrecision, hiveScale);
            this.scale = scale;
        }

        @Override
        public byte[] readString() {
            return this.convertToBytes(this.valuesReader.readInteger());
        }

        @Override
        public byte[] readString(int id) {
            return this.convertToBytes(this.dict.decodeToInt(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readInteger()));
            return TypesFromInt32DecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToInt(id)));
            return TypesFromInt32DecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readInteger()));
            return TypesFromInt32DecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToInt(id)));
            return TypesFromInt32DecimalPageReader.convertToBytes(value);
        }

        @Override
        public float readFloat() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readInteger(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (float)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "float");
        }

        @Override
        public float readFloat(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToInt(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (float)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "float");
        }

        @Override
        public double readDouble() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readInteger(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "double");
        }

        @Override
        public double readDouble(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToInt(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "double");
        }

        @Override
        public long readLong() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readInteger(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "bigint");
        }

        @Override
        public long readLong(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToInt(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "bigint");
        }

        @Override
        public long readInteger() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readInteger(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "int");
        }

        @Override
        public long readInteger(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToInt(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "int");
        }

        @Override
        public long readSmallInt() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readInteger(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "smallint");
        }

        @Override
        public long readSmallInt(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToInt(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "smallint");
        }

        @Override
        public long readTinyInt() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readInteger(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "tinyint");
        }

        @Override
        public long readTinyInt(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToInt(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "tinyint");
        }

        private String convertToString(int value) {
            HiveDecimal hiveDecimal = HiveDecimal.create(value, (int)this.scale);
            return hiveDecimal.toString();
        }

        private byte[] convertToBytes(int value) {
            return TypesFromInt32DecimalPageReader.convertToBytes(this.convertToString(value));
        }

        @Override
        public byte[] readDecimal() {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.valuesReader.readInteger(), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return super.validatedScaledDecimal(this.scale);
        }

        @Override
        public byte[] readDecimal(int id) {
            HiveDecimal hiveDecimal = HiveDecimal.create(this.dict.decodeToInt(id), (int)this.scale);
            this.hiveDecimalWritable.set(hiveDecimal);
            return super.validatedScaledDecimal(this.scale);
        }
    }

    public static class TypesFromDecimalPageReader
    extends DefaultParquetDataColumnReader {
        private short scale;

        public TypesFromDecimalPageReader(ValuesReader realReader, int length, short scale, int hivePrecision, int hiveScale) {
            super(realReader, length, hivePrecision, hiveScale);
            this.scale = scale;
        }

        public TypesFromDecimalPageReader(Dictionary dict, int length, short scale, int hivePrecision, int hiveScale) {
            super(dict, length, hivePrecision, hiveScale);
            this.scale = scale;
        }

        @Override
        public byte[] readString() {
            return this.convertToBytes(this.valuesReader.readBytes());
        }

        @Override
        public byte[] readString(int id) {
            return this.convertToBytes(this.dict.decodeToBinary(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readBytes()));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToBinary(id)));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readBytes()));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToBinary(id)));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public float readFloat() {
            this.hiveDecimalWritable.set(this.valuesReader.readBytes().getBytesUnsafe(), this.scale);
            return (float)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "float");
        }

        @Override
        public float readFloat(int id) {
            this.hiveDecimalWritable.set(this.dict.decodeToBinary(id).getBytesUnsafe(), this.scale);
            return (float)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "float");
        }

        @Override
        public double readDouble() {
            this.hiveDecimalWritable.set(this.valuesReader.readBytes().getBytesUnsafe(), this.scale);
            return super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "double");
        }

        @Override
        public double readDouble(int id) {
            this.hiveDecimalWritable.set(this.dict.decodeToBinary(id).getBytesUnsafe(), this.scale);
            return super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "double");
        }

        @Override
        public long readLong() {
            this.hiveDecimalWritable.set(this.valuesReader.readBytes().getBytesUnsafe(), this.scale);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "bigint");
        }

        @Override
        public long readLong(int id) {
            this.hiveDecimalWritable.set(this.dict.decodeToBinary(id).getBytesUnsafe(), this.scale);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "bigint");
        }

        @Override
        public long readInteger() {
            this.hiveDecimalWritable.set(this.valuesReader.readBytes().getBytesUnsafe(), this.scale);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "int");
        }

        @Override
        public long readInteger(int id) {
            this.hiveDecimalWritable.set(this.dict.decodeToBinary(id).getBytesUnsafe(), this.scale);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "int");
        }

        @Override
        public long readSmallInt() {
            this.hiveDecimalWritable.set(this.valuesReader.readBytes().getBytesUnsafe(), this.scale);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "smallint");
        }

        @Override
        public long readSmallInt(int id) {
            this.hiveDecimalWritable.set(this.dict.decodeToBinary(id).getBytesUnsafe(), this.scale);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "smallint");
        }

        @Override
        public long readTinyInt() {
            this.hiveDecimalWritable.set(this.valuesReader.readBytes().getBytesUnsafe(), this.scale);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "tinyint");
        }

        @Override
        public long readTinyInt(int id) {
            this.hiveDecimalWritable.set(this.dict.decodeToBinary(id).getBytesUnsafe(), this.scale);
            return (long)super.validatedDouble(this.hiveDecimalWritable.doubleValue(), "tinyint");
        }

        private String convertToString(Binary value) {
            this.hiveDecimalWritable.set(value.getBytesUnsafe(), this.scale);
            return this.hiveDecimalWritable.toString();
        }

        private byte[] convertToBytes(Binary value) {
            return TypesFromDecimalPageReader.convertToBytes(this.convertToString(value));
        }

        @Override
        public byte[] readDecimal() {
            this.hiveDecimalWritable.set(this.valuesReader.readBytes().getBytesUnsafe(), this.scale);
            return super.validatedScaledDecimal(this.scale);
        }

        @Override
        public byte[] readDecimal(int id) {
            this.hiveDecimalWritable.set(this.dict.decodeToBinary(id).getBytesUnsafe(), this.scale);
            return super.validatedScaledDecimal(this.scale);
        }
    }

    public static class TypesFromInt96PageReader
    extends DefaultParquetDataColumnReader {
        private boolean skipTimestampConversion = false;
        private ZoneId writerTimezone;

        public TypesFromInt96PageReader(ValuesReader realReader, int length, boolean skipTimestampConversion, ZoneId writerTimezone) {
            super(realReader, length);
            this.skipTimestampConversion = skipTimestampConversion;
            this.writerTimezone = writerTimezone;
        }

        public TypesFromInt96PageReader(Dictionary dict, int length, boolean skipTimestampConversion, ZoneId writerTimezone) {
            super(dict, length);
            this.skipTimestampConversion = skipTimestampConversion;
            this.writerTimezone = writerTimezone;
        }

        private Timestamp convert(Binary binary) {
            ByteBuffer buf = binary.toByteBuffer();
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = buf.getLong();
            int julianDay = buf.getInt();
            NanoTime nt = new NanoTime(julianDay, timeOfDayNanos);
            return NanoTimeUtils.getTimestamp(nt, this.skipTimestampConversion, this.writerTimezone);
        }

        @Override
        public Timestamp readTimestamp(int id) {
            return this.convert(this.dict.decodeToBinary(id));
        }

        @Override
        public Timestamp readTimestamp() {
            return this.convert(this.valuesReader.readBytes());
        }

        @Override
        public byte[] readString() {
            return TypesFromInt96PageReader.convertToBytes(this.readTimestamp());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt96PageReader.convertToBytes(this.readTimestamp(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp()));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp(id)));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp()));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp(id)));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        private static String convertToString(Timestamp value) {
            return value.toString();
        }

        private static byte[] convertToBytes(Timestamp value) {
            return TypesFromInt96PageReader.convertToBytes(TypesFromInt96PageReader.convertToString(value));
        }
    }

    public static class TypesFromBooleanPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromBooleanPageReader(ValuesReader valuesReader, int length) {
            super(valuesReader, length);
        }

        public TypesFromBooleanPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public byte[] readString() {
            return TypesFromBooleanPageReader.convertToBytes(this.valuesReader.readBoolean());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromBooleanPageReader.convertToBytes(this.dict.decodeToBoolean(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.valuesReader.readBoolean()));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.dict.decodeToBoolean(id)));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.valuesReader.readBoolean()));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.dict.decodeToBoolean(id)));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        private static String convertToString(boolean value) {
            return Boolean.toString(value);
        }

        private static byte[] convertToBytes(boolean value) {
            return TypesFromBooleanPageReader.convertToBytes(TypesFromBooleanPageReader.convertToString(value));
        }
    }

    public static class TypesFromDoublePageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromDoublePageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length, precision, scale);
        }

        public TypesFromDoublePageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length, precision, scale);
        }

        @Override
        public byte[] readString() {
            return TypesFromDoublePageReader.convertToBytes(this.valuesReader.readDouble());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromDoublePageReader.convertToBytes(this.dict.decodeToDouble(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.valuesReader.readDouble()));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.dict.decodeToDouble(id)));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.valuesReader.readDouble()));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.dict.decodeToDouble(id)));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public long readLong() {
            return (long)super.validatedDouble(this.valuesReader.readDouble(), "bigint");
        }

        @Override
        public long readLong(int id) {
            return (long)super.validatedDouble(this.dict.decodeToDouble(id), "bigint");
        }

        @Override
        public long readInteger() {
            return (long)super.validatedDouble(this.valuesReader.readDouble(), "int");
        }

        @Override
        public long readInteger(int id) {
            return (long)super.validatedDouble(this.dict.decodeToDouble(id), "int");
        }

        @Override
        public long readSmallInt() {
            return (long)super.validatedDouble(this.valuesReader.readDouble(), "smallint");
        }

        @Override
        public long readSmallInt(int id) {
            return (long)super.validatedDouble(this.dict.decodeToDouble(id), "smallint");
        }

        @Override
        public long readTinyInt() {
            return (long)super.validatedDouble(this.valuesReader.readDouble(), "tinyint");
        }

        @Override
        public long readTinyInt(int id) {
            return (long)super.validatedDouble(this.dict.decodeToDouble(id), "tinyint");
        }

        @Override
        public float readFloat() {
            return (float)super.validatedDouble(this.valuesReader.readDouble(), "float");
        }

        @Override
        public float readFloat(int id) {
            return (float)super.validatedDouble(this.dict.decodeToDouble(id), "float");
        }

        private static String convertToString(double value) {
            return Double.toString(value);
        }

        private static byte[] convertToBytes(double value) {
            return TypesFromDoublePageReader.convertToBytes(TypesFromDoublePageReader.convertToString(value));
        }

        @Override
        public byte[] readDecimal() {
            return super.validatedDecimal(this.valuesReader.readDouble());
        }

        @Override
        public byte[] readDecimal(int id) {
            return super.validatedDecimal(this.dict.decodeToDouble(id));
        }
    }

    public static class TypesFromFloatPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromFloatPageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length, precision, scale);
        }

        public TypesFromFloatPageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length, precision, scale);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readFloat();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public byte[] readString() {
            return TypesFromFloatPageReader.convertToBytes(this.valuesReader.readFloat());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromFloatPageReader.convertToBytes(this.dict.decodeToFloat(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.valuesReader.readFloat()));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.dict.decodeToFloat(id)));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.valuesReader.readFloat()));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.dict.decodeToFloat(id)));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public long readLong() {
            return (long)super.validatedDouble(this.valuesReader.readFloat(), "bigint");
        }

        @Override
        public long readLong(int id) {
            return (long)super.validatedDouble(this.dict.decodeToFloat(id), "bigint");
        }

        @Override
        public long readInteger() {
            return (long)super.validatedDouble(this.valuesReader.readFloat(), "int");
        }

        @Override
        public long readInteger(int id) {
            return (long)super.validatedDouble(this.dict.decodeToFloat(id), "int");
        }

        @Override
        public long readSmallInt() {
            return (long)super.validatedDouble(this.valuesReader.readFloat(), "smallint");
        }

        @Override
        public long readSmallInt(int id) {
            return (long)super.validatedDouble(this.dict.decodeToFloat(id), "smallint");
        }

        @Override
        public long readTinyInt() {
            return (long)super.validatedDouble(this.valuesReader.readFloat(), "tinyint");
        }

        @Override
        public long readTinyInt(int id) {
            return (long)super.validatedDouble(this.dict.decodeToFloat(id), "tinyint");
        }

        private static String convertToString(float value) {
            return Float.toString(value);
        }

        private static byte[] convertToBytes(float value) {
            return TypesFromFloatPageReader.convertToBytes(TypesFromFloatPageReader.convertToString(value));
        }

        @Override
        public byte[] readDecimal() {
            return super.validatedDecimal(this.valuesReader.readFloat());
        }

        @Override
        public byte[] readDecimal(int id) {
            return super.validatedDecimal(this.dict.decodeToFloat(id));
        }
    }

    public static class TypesFromUInt32PageReader
    extends TypesFromInt32PageReader {
        public TypesFromUInt32PageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length, precision, scale);
        }

        public TypesFromUInt32PageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length, precision, scale);
        }

        @Override
        public long readLong() {
            return super.validatedLong(this.valuesReader.readInteger(), "bigint", true);
        }

        @Override
        public long readLong(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "bigint", true);
        }

        @Override
        public long readInteger() {
            return super.validatedLong(this.valuesReader.readInteger(), "int", true);
        }

        @Override
        public long readInteger(int id) {
            return super.validatedLong(this.dict.decodeToInt(id), "int", true);
        }

        @Override
        public long readSmallInt() {
            return this.validatedLong(this.valuesReader.readInteger(), "smallint", true);
        }

        @Override
        public long readSmallInt(int id) {
            return this.validatedLong(this.dict.decodeToInt(id), "smallint", true);
        }

        @Override
        public long readTinyInt() {
            return this.validatedLong(this.valuesReader.readInteger(), "tinyint", true);
        }

        @Override
        public long readTinyInt(int id) {
            return this.validatedLong(this.dict.decodeToInt(id), "tinyint", true);
        }

        @Override
        public float readFloat() {
            return super.validatedLong(this.valuesReader.readInteger(), "bigint", true);
        }

        @Override
        public float readFloat(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "bigint", true);
        }

        @Override
        public double readDouble() {
            return super.validatedLong(this.valuesReader.readInteger(), "bigint", true);
        }

        @Override
        public double readDouble(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "bigint", true);
        }

        @Override
        public byte[] readDecimal() {
            long validatedIntValue = super.validatedLong(this.valuesReader.readInteger(), "int", true);
            if (this.isValid) {
                return super.validatedDecimal(validatedIntValue);
            }
            return null;
        }

        @Override
        public byte[] readDecimal(int id) {
            long validatedIntValue = super.validatedLong(this.dict.decodeToInt(id), "int", true);
            if (this.isValid) {
                return super.validatedDecimal(validatedIntValue);
            }
            return null;
        }
    }

    public static class TypesFromInt32PageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromInt32PageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length, precision, scale);
        }

        public TypesFromInt32PageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length, precision, scale);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readInteger();
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readInteger();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readInteger();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public byte[] readString() {
            return TypesFromInt32PageReader.convertToBytes(this.valuesReader.readInteger());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt32PageReader.convertToBytes(this.dict.decodeToInt(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.valuesReader.readInteger()));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.dict.decodeToInt(id)));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.valuesReader.readInteger()));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.dict.decodeToInt(id)));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        private static String convertToString(int value) {
            return Integer.toString(value);
        }

        private static byte[] convertToBytes(int value) {
            return TypesFromInt32PageReader.convertToBytes(TypesFromInt32PageReader.convertToString(value));
        }

        @Override
        public byte[] readDecimal() {
            return super.validatedDecimal(this.valuesReader.readInteger());
        }

        @Override
        public byte[] readDecimal(int id) {
            return super.validatedDecimal(this.dict.decodeToInt(id));
        }
    }

    public static class TypesFromUInt64PageReader
    extends TypesFromInt64PageReader {
        public TypesFromUInt64PageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length, precision, scale);
        }

        public TypesFromUInt64PageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length, precision, scale);
        }

        @Override
        public long readLong() {
            return super.validatedLong(this.valuesReader.readLong(), "bigint", true);
        }

        @Override
        public long readLong(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "bigint", true);
        }

        @Override
        public long readInteger() {
            return super.validatedLong(this.valuesReader.readLong(), "int", true);
        }

        @Override
        public long readInteger(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "int", true);
        }

        @Override
        public long readSmallInt() {
            return super.validatedLong(this.valuesReader.readLong(), "smallint", true);
        }

        @Override
        public long readSmallInt(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "smallint", true);
        }

        @Override
        public long readTinyInt() {
            return super.validatedLong(this.valuesReader.readLong(), "tinyint", true);
        }

        @Override
        public long readTinyInt(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "tinyint", true);
        }

        @Override
        public float readFloat() {
            return super.validatedLong(this.valuesReader.readLong(), "bigint", true);
        }

        @Override
        public float readFloat(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "bigint", true);
        }

        @Override
        public double readDouble() {
            return super.validatedLong(this.valuesReader.readLong(), "bigint", true);
        }

        @Override
        public double readDouble(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "bigint", true);
        }

        @Override
        public byte[] readDecimal() {
            long validatedLongValue = super.validatedLong(this.valuesReader.readLong(), "bigint", true);
            if (this.isValid) {
                return super.validatedDecimal(validatedLongValue);
            }
            return null;
        }

        @Override
        public byte[] readDecimal(int id) {
            long validatedLongValue = super.validatedLong(this.dict.decodeToLong(id), "bigint", true);
            if (this.isValid) {
                return super.validatedDecimal(validatedLongValue);
            }
            return null;
        }
    }

    public static class TypesFromInt64PageReader
    extends DefaultParquetDataColumnReader {
        private boolean isAdjustedToUTC;
        private LogicalTypeAnnotation.TimeUnit timeUnit;

        public TypesFromInt64PageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length, precision, scale);
        }

        public TypesFromInt64PageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length, precision, scale);
        }

        public TypesFromInt64PageReader(ValuesReader realReader, int length, boolean isAdjustedToUTC, LogicalTypeAnnotation.TimeUnit timeUnit) {
            super(realReader, length);
            this.isAdjustedToUTC = isAdjustedToUTC;
            this.timeUnit = timeUnit;
        }

        public TypesFromInt64PageReader(Dictionary dict, int length, boolean isAdjustedToUTC, LogicalTypeAnnotation.TimeUnit timeUnit) {
            super(dict, length);
            this.isAdjustedToUTC = isAdjustedToUTC;
            this.timeUnit = timeUnit;
        }

        @Override
        public long readInteger() {
            return super.validatedLong(this.valuesReader.readLong(), "int");
        }

        @Override
        public long readInteger(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "int");
        }

        @Override
        public long readSmallInt() {
            return super.validatedLong(this.valuesReader.readLong(), "smallint");
        }

        @Override
        public long readSmallInt(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "smallint");
        }

        @Override
        public long readTinyInt() {
            return super.validatedLong(this.valuesReader.readLong(), "tinyint");
        }

        @Override
        public long readTinyInt(int id) {
            return super.validatedLong(this.dict.decodeToLong(id), "tinyint");
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readLong();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readLong();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public byte[] readDecimal() {
            return super.validatedDecimal(this.valuesReader.readLong());
        }

        @Override
        public byte[] readDecimal(int id) {
            return super.validatedDecimal(this.dict.decodeToLong(id));
        }

        @Override
        public byte[] readString() {
            return TypesFromInt64PageReader.convertToBytes(this.valuesReader.readLong());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt64PageReader.convertToBytes(this.dict.decodeToLong(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.valuesReader.readLong()));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.dict.decodeToLong(id)));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.valuesReader.readLong()));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.dict.decodeToLong(id)));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        private Timestamp convert(Long value) {
            Timestamp timestamp = ParquetTimestampUtils.getTimestamp(value, this.timeUnit, this.isAdjustedToUTC);
            return timestamp;
        }

        @Override
        public Timestamp readTimestamp(int id) {
            return this.convert(this.dict.decodeToLong(id));
        }

        @Override
        public Timestamp readTimestamp() {
            return this.convert(this.valuesReader.readLong());
        }

        private static String convertToString(long value) {
            return Long.toString(value);
        }

        private static byte[] convertToBytes(long value) {
            return TypesFromInt64PageReader.convertToBytes(TypesFromInt64PageReader.convertToString(value));
        }
    }

    public static class DefaultParquetDataColumnReader
    implements ParquetDataColumnReader {
        protected ValuesReader valuesReader;
        protected Dictionary dict;
        boolean isValid = true;
        protected int hivePrecision = 0;
        protected int hiveScale = 0;
        protected final HiveDecimalWritable hiveDecimalWritable = new HiveDecimalWritable(0L);
        protected int length = -1;

        public DefaultParquetDataColumnReader(ValuesReader valuesReader, int length) {
            this.valuesReader = valuesReader;
            this.length = length;
        }

        public DefaultParquetDataColumnReader(Dictionary dict, int length) {
            this.dict = dict;
            this.length = length;
        }

        public DefaultParquetDataColumnReader(ValuesReader realReader, int length, int precision, int scale) {
            this(realReader, length);
            this.hivePrecision = precision;
            this.hiveScale = scale;
        }

        public DefaultParquetDataColumnReader(Dictionary dict, int length, int precision, int scale) {
            this(dict, length);
            this.hivePrecision = precision;
            this.hiveScale = scale;
        }

        @Override
        public void initFromPage(int i, ByteBufferInputStream in) throws IOException {
            this.valuesReader.initFromPage(i, in);
        }

        @Override
        public boolean readBoolean() {
            return this.valuesReader.readBoolean();
        }

        @Override
        public boolean readBoolean(int id) {
            return this.dict.decodeToBoolean(id);
        }

        @Override
        public byte[] readString(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readString() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readVarchar() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readVarchar(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readChar() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readChar(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readBytes() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readBytes(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readDecimal() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readDecimal(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readFloat();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readDouble();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToDouble(id);
        }

        @Override
        public Timestamp readTimestamp() {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public Timestamp readTimestamp(int id) {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public long readInteger() {
            return this.valuesReader.readInteger();
        }

        @Override
        public long readInteger(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readLong();
        }

        @Override
        public long readSmallInt() {
            return this.validatedLong(this.valuesReader.readInteger(), "smallint");
        }

        @Override
        public long readSmallInt(int id) {
            return this.validatedLong(this.dict.decodeToInt(id), "smallint");
        }

        @Override
        public long readTinyInt() {
            return this.validatedLong(this.valuesReader.readInteger(), "tinyint");
        }

        @Override
        public long readTinyInt(int id) {
            return this.validatedLong(this.dict.decodeToInt(id), "tinyint");
        }

        @Override
        public int readValueDictionaryId() {
            return this.valuesReader.readValueDictionaryId();
        }

        public void skip() {
            this.valuesReader.skip();
        }

        @Override
        public Dictionary getDictionary() {
            return this.dict;
        }

        protected String enforceMaxLength(String value) {
            return HiveBaseChar.enforceMaxLength(value, this.length);
        }

        protected String getPaddedString(String value) {
            return HiveBaseChar.getPaddedValue(value, this.length);
        }

        protected static byte[] convertToBytes(String value) {
            try {
                return value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to encode string in UTF-8", e);
            }
        }

        long validatedLong(long longValue, String typeName, boolean isUnSigned) {
            switch (typeName) {
                case "bigint": {
                    this.isValid = !isUnSigned || longValue >= 0L;
                    break;
                }
                case "int": {
                    this.isValid = longValue <= Integer.MAX_VALUE && longValue >= (long)(isUnSigned ? 0 : Integer.MIN_VALUE);
                    break;
                }
                case "smallint": {
                    this.isValid = longValue <= 32767L && longValue >= (long)(isUnSigned ? 0 : Short.MIN_VALUE);
                    break;
                }
                case "tinyint": {
                    this.isValid = longValue <= 127L && longValue >= (long)(isUnSigned ? 0 : -128);
                    break;
                }
                default: {
                    this.isValid = true;
                }
            }
            if (this.isValid) {
                return longValue;
            }
            return 0L;
        }

        long validatedLong(long longValue, String typeName) {
            return this.validatedLong(longValue, typeName, false);
        }

        byte[] validatedDecimal(long longValue) {
            this.hiveDecimalWritable.setFromLong(longValue);
            return this.validatedDecimal();
        }

        byte[] validatedDecimal(double doubleValue) {
            this.hiveDecimalWritable.setFromDouble(doubleValue);
            return this.validatedDecimal();
        }

        byte[] validatedDecimal() {
            return this.validatedScaledDecimal(this.hiveScale);
        }

        byte[] validatedScaledDecimal(int inpScale) {
            this.hiveDecimalWritable.mutateEnforcePrecisionScale(this.hivePrecision, this.hiveScale);
            if (this.hiveDecimalWritable.isSet()) {
                this.isValid = true;
                return this.hiveDecimalWritable.getHiveDecimal().bigIntegerBytesScaled(inpScale);
            }
            this.isValid = false;
            return null;
        }

        double validatedDouble(double doubleValue, String typeName) {
            switch (typeName) {
                case "float": {
                    double absDoubleValue = doubleValue < 0.0 ? doubleValue * -1.0 : doubleValue;
                    int exponent = Math.getExponent(doubleValue);
                    this.isValid = absDoubleValue <= 3.4028234663852886E38 && absDoubleValue >= (double)1.4E-45f && exponent <= 127 && exponent >= -126;
                    break;
                }
                case "bigint": {
                    this.isValid = doubleValue <= 9.223372036854776E18 && doubleValue >= -9.223372036854776E18 && doubleValue % 1.0 == 0.0;
                    break;
                }
                case "int": {
                    this.isValid = doubleValue <= 2.147483647E9 && doubleValue >= -2.147483648E9 && doubleValue % 1.0 == 0.0;
                    break;
                }
                case "smallint": {
                    this.isValid = doubleValue <= 32767.0 && doubleValue >= -32768.0 && doubleValue % 1.0 == 0.0;
                    break;
                }
                case "tinyint": {
                    this.isValid = doubleValue <= 127.0 && doubleValue >= -128.0 && doubleValue % 1.0 == 0.0;
                    break;
                }
                default: {
                    this.isValid = true;
                }
            }
            if (this.isValid) {
                return doubleValue;
            }
            return 0.0;
        }
    }
}

