/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.hive.ql.io.orc.encoded.ReaderImpl;

public class EncodedOrcFile {
    public static Reader createReader(Path path, OrcFile.ReaderOptions options) throws IOException {
        return new ReaderImpl(path, options);
    }

    public static EncodedReaderOptions readerOptions(Configuration conf) {
        return new EncodedReaderOptions(conf);
    }

    public static class EncodedReaderOptions
    extends OrcFile.ReaderOptions {
        private Supplier<FileSystem> fileSystemSupplier;

        public EncodedReaderOptions(Configuration configuration) {
            super(configuration);
        }

        public EncodedReaderOptions filesystem(Supplier<FileSystem> fsSupplier) {
            this.fileSystemSupplier = fsSupplier;
            return this;
        }

        @Override
        public EncodedReaderOptions filesystem(FileSystem fs) {
            this.fileSystemSupplier = () -> fs;
            return this;
        }

        @Override
        public FileSystem getFilesystem() {
            return this.fileSystemSupplier != null ? this.fileSystemSupplier.get() : null;
        }
    }
}

