/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapDaemonInfo;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.orc.FileMetadata;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.PhysicalWriter;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.MemoryManagerImpl;
import org.apache.orc.impl.OrcTail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrcFile
extends org.apache.orc.OrcFile {
    private static final Logger LOG = LoggerFactory.getLogger(OrcFile.class);
    private static ThreadLocal<MemoryManager> threadLocalOrcLlapMemoryManager = null;

    protected OrcFile() {
    }

    public static Reader createReader(FileSystem fs, Path path) throws IOException {
        ReaderOptions opts = new ReaderOptions(new Configuration());
        opts.filesystem(fs);
        return new ReaderImpl(path, opts);
    }

    public static ReaderOptions readerOptions(Configuration conf) {
        return new ReaderOptions(conf);
    }

    public static Reader createReader(Path path, ReaderOptions options) throws IOException {
        return new ReaderImpl(path, options);
    }

    private static synchronized MemoryManager getThreadLocalOrcLlapMemoryManager(Configuration conf) {
        if (threadLocalOrcLlapMemoryManager == null) {
            threadLocalOrcLlapMemoryManager = ThreadLocal.withInitial(() -> new LlapAwareMemoryManager(conf));
        }
        return threadLocalOrcLlapMemoryManager.get();
    }

    public static WriterOptions writerOptions(Configuration conf) {
        return new WriterOptions(null, conf);
    }

    public static WriterOptions writerOptions(Properties tableProperties, Configuration conf) {
        return new WriterOptions(tableProperties, conf);
    }

    public static Writer createWriter(Path path, WriterOptions opts) throws IOException {
        FileSystem fs = opts.getFileSystem() == null ? path.getFileSystem(opts.getConfiguration()) : opts.getFileSystem();
        return new WriterImpl(fs, path, opts);
    }

    public static Writer createWriter(FileSystem fs, Path path, Configuration conf, ObjectInspector inspector, long stripeSize, CompressionKind compress, int bufferSize, int rowIndexStride) throws IOException {
        return OrcFile.createWriter(path, OrcFile.writerOptions(conf).inspector(inspector).fileSystem(fs).stripeSize(stripeSize).compress(compress).bufferSize(bufferSize).rowIndexStride(rowIndexStride));
    }

    public static class WriterOptions
    extends OrcFile.WriterOptions {
        private boolean explicitSchema = false;
        private ObjectInspector inspector = null;
        private int batchSize = 1000;

        WriterOptions(Properties tableProperties, Configuration conf) {
            super(tableProperties, conf);
            this.useUTCTimestamp(true);
            if (conf.getBoolean(HiveConf.ConfVars.HIVE_ORC_WRITER_LLAP_MEMORY_MANAGER_ENABLED.varname, true) && LlapProxy.isDaemon()) {
                this.memory(OrcFile.getThreadLocalOrcLlapMemoryManager(conf));
            }
        }

        public WriterOptions inspector(ObjectInspector value) {
            this.inspector = value;
            if (!this.explicitSchema) {
                super.setSchema(OrcInputFormat.convertTypeInfo(TypeInfoUtils.getTypeInfoFromObjectInspector(value)));
            }
            return this;
        }

        @Override
        public WriterOptions setSchema(TypeDescription schema) {
            if (schema != null) {
                this.explicitSchema = true;
                super.setSchema(schema);
            }
            return this;
        }

        @Override
        public WriterOptions fileSystem(FileSystem value) {
            super.fileSystem(value);
            return this;
        }

        @Override
        public WriterOptions stripeSize(long value) {
            super.stripeSize(value);
            return this;
        }

        @Override
        public WriterOptions blockSize(long value) {
            super.blockSize(value);
            return this;
        }

        @Override
        public WriterOptions rowIndexStride(int value) {
            super.rowIndexStride(value);
            return this;
        }

        @Override
        public WriterOptions bufferSize(int value) {
            super.bufferSize(value);
            return this;
        }

        @Override
        public WriterOptions blockPadding(boolean value) {
            super.blockPadding(value);
            return this;
        }

        @Override
        public WriterOptions encodingStrategy(OrcFile.EncodingStrategy strategy) {
            super.encodingStrategy(strategy);
            return this;
        }

        @Override
        public WriterOptions paddingTolerance(double value) {
            super.paddingTolerance(value);
            return this;
        }

        @Override
        public WriterOptions bloomFilterColumns(String columns) {
            super.bloomFilterColumns(columns);
            return this;
        }

        @Override
        public WriterOptions bloomFilterFpp(double fpp) {
            super.bloomFilterFpp(fpp);
            return this;
        }

        public WriterOptions compress(CompressionKind value) {
            super.compress(value.getUnderlying());
            return this;
        }

        @Override
        public WriterOptions compress(org.apache.orc.CompressionKind value) {
            super.compress(value);
            return this;
        }

        @Override
        public WriterOptions version(OrcFile.Version value) {
            super.version(value);
            return this;
        }

        @Override
        public WriterOptions callback(OrcFile.WriterCallback callback) {
            super.callback(callback);
            return this;
        }

        @Override
        public WriterOptions memory(MemoryManager value) {
            super.memory(value);
            return this;
        }

        protected WriterOptions batchSize(int maxSize) {
            this.batchSize = maxSize;
            return this;
        }

        @Override
        public WriterOptions physicalWriter(PhysicalWriter writer) {
            super.physicalWriter(writer);
            return this;
        }

        @Override
        public WriterOptions useUTCTimestamp(boolean value) {
            super.useUTCTimestamp(value);
            return this;
        }

        @Override
        public WriterOptions setProlepticGregorian(boolean value) {
            super.setProlepticGregorian(value);
            return this;
        }

        ObjectInspector getInspector() {
            return this.inspector;
        }

        int getBatchSize() {
            return this.batchSize;
        }
    }

    @VisibleForTesting
    static class LlapAwareMemoryManager
    extends MemoryManagerImpl {
        private final double maxLoad;
        private final long totalMemoryPool;

        public LlapAwareMemoryManager(Configuration conf) {
            super(conf);
            this.maxLoad = OrcConf.MEMORY_POOL.getDouble(conf);
            long memPerExecutor = LlapDaemonInfo.INSTANCE.getMemoryPerExecutor();
            this.totalMemoryPool = (long)((double)memPerExecutor * this.maxLoad);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using LLAP memory manager for orc writer. memPerExecutor: {} maxLoad: {} totalMemPool: {}", new Object[]{LlapUtil.humanReadableByteCount(memPerExecutor), this.maxLoad, LlapUtil.humanReadableByteCount(this.totalMemoryPool)});
            }
        }

        @Override
        public long getTotalMemoryPool() {
            return this.totalMemoryPool;
        }
    }

    public static class ReaderOptions
    extends OrcFile.ReaderOptions {
        public ReaderOptions(Configuration conf) {
            super(conf);
            this.useUTCTimestamp(true);
            this.convertToProlepticGregorian(true);
        }

        @Override
        public ReaderOptions filesystem(FileSystem fs) {
            super.filesystem(fs);
            return this;
        }

        @Override
        public ReaderOptions maxLength(long val) {
            super.maxLength(val);
            return this;
        }

        @Override
        public ReaderOptions fileMetadata(FileMetadata metadata) {
            super.fileMetadata(metadata);
            return this;
        }

        @Override
        public ReaderOptions orcTail(OrcTail orcTail) {
            super.orcTail(orcTail);
            return this;
        }

        @Override
        public ReaderOptions useUTCTimestamp(boolean value) {
            super.useUTCTimestamp(value);
            return this;
        }

        @Override
        public ReaderOptions convertToProlepticGregorian(boolean value) {
            super.convertToProlepticGregorian(value);
            return this;
        }
    }
}

