/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.avro;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.rmi.server.UID;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroGenericRecordReader
implements RecordReader<NullWritable, AvroGenericRecordWritable>,
JobConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(AvroGenericRecordReader.class);
    private final FileReader<GenericRecord> reader;
    private final long start;
    private final long stop;
    private ZoneId writerTimezone;
    private Boolean writerProleptic;
    protected JobConf jobConf;
    private final boolean isEmptyInput;
    private final UID recordReaderID;

    public AvroGenericRecordReader(JobConf job, FileSplit split, Reporter reporter) throws IOException {
        Schema latest;
        this.jobConf = job;
        try {
            latest = this.getSchema(job, split);
        }
        catch (AvroSerdeException e) {
            throw new IOException(e);
        }
        GenericDatumReader<GenericRecord> gdr = new GenericDatumReader<GenericRecord>();
        if (latest != null) {
            gdr.setExpected(latest);
        }
        if (split.getLength() == 0L) {
            this.isEmptyInput = true;
            this.start = 0L;
            this.reader = null;
        } else {
            this.isEmptyInput = false;
            this.reader = new DataFileReader<GenericRecord>(new FsInput(split.getPath(), (Configuration)job), gdr);
            this.reader.sync(split.getStart());
            this.start = this.reader.tell();
        }
        this.stop = split.getStart() + split.getLength();
        this.recordReaderID = new UID();
        this.writerTimezone = this.extractWriterTimezoneFromMetadata(job, split, gdr);
        this.writerProleptic = this.extractWriterProlepticFromMetadata(job, split, gdr);
    }

    private Schema getSchema(JobConf job, FileSplit split) throws AvroSerdeException, IOException {
        String s;
        if (AvroSerdeUtils.insideMRJob(job)) {
            MapWork mapWork = Utilities.getMapWork((Configuration)job);
            for (Map.Entry<Path, PartitionDesc> pathsAndParts : mapWork.getPathToPartitionInfo().entrySet()) {
                Properties props;
                Path partitionPath = pathsAndParts.getKey();
                if (!this.pathIsInPartition(split.getPath(), partitionPath)) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Matching partition " + partitionPath + " with input split " + split);
                }
                if ((props = pathsAndParts.getValue().getProperties()).containsKey(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName()) || props.containsKey(AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName())) {
                    return AvroSerdeUtils.determineSchemaOrThrowException((Configuration)job, props);
                }
                return null;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Unable to match filesplit " + split + " with a partition.");
            }
        }
        if ((s = job.get(AvroSerdeUtils.AvroTableProperties.AVRO_SERDE_SCHEMA.getPropName())) != null) {
            LOG.info("Found the avro schema in the job: " + s);
            return AvroSerdeUtils.getSchemaFor(s);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ZoneId extractWriterTimezoneFromMetadata(JobConf job, FileSplit split, GenericDatumReader<GenericRecord> gdr) {
        block20: {
            if (job == null || gdr == null || split == null || split.getPath() == null) {
                return null;
            }
            try {
                Throwable throwable = null;
                try (DataFileReader<GenericRecord> dataFileReader = new DataFileReader<GenericRecord>(new FsInput(split.getPath(), (Configuration)job), gdr);){
                    if (dataFileReader.getMeta("writer.time.zone") == null) break block20;
                    try {
                        ZoneId zoneId = ZoneId.of(new String(dataFileReader.getMeta("writer.time.zone"), StandardCharsets.UTF_8));
                        return zoneId;
                    }
                    catch (DateTimeException e) {
                        try {
                            throw new RuntimeException("Can't parse writer time zone stored in file metadata", e);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private Boolean extractWriterProlepticFromMetadata(JobConf job, FileSplit split, GenericDatumReader<GenericRecord> gdr) throws IOException {
        if (job == null || gdr == null || split == null || split.getPath() == null) {
            return null;
        }
        try {
            DataFileReader<GenericRecord> dataFileReader = new DataFileReader<GenericRecord>(new FsInput(split.getPath(), (Configuration)job), gdr);
            if (dataFileReader.getMeta("writer.proleptic") != null) {
                try {
                    return Boolean.valueOf(new String(dataFileReader.getMeta("writer.proleptic"), StandardCharsets.UTF_8));
                }
                catch (DateTimeException e) {
                    throw new RuntimeException("Can't parse writer proleptic property stored in file metadata", e);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean pathIsInPartition(Path split, Path partitionPath) {
        boolean schemeless;
        boolean bl = schemeless = split.toUri().getScheme() == null;
        if (schemeless) {
            Path pathNoSchema = Path.getPathWithoutSchemeAndAuthority((Path)partitionPath);
            return FileUtils.isPathWithinSubtree(split, pathNoSchema);
        }
        return FileUtils.isPathWithinSubtree(split, partitionPath);
    }

    public boolean next(NullWritable nullWritable, AvroGenericRecordWritable record) throws IOException {
        if (this.isEmptyInput || !this.reader.hasNext() || this.reader.pastSync(this.stop)) {
            return false;
        }
        GenericData.Record r = (GenericData.Record)this.reader.next();
        record.setRecord(r);
        record.setRecordReaderID(this.recordReaderID);
        record.setFileSchema(this.reader.getSchema());
        return true;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public AvroGenericRecordWritable createValue() {
        return new AvroGenericRecordWritable(this.writerTimezone, this.writerProleptic);
    }

    public long getPos() throws IOException {
        return this.isEmptyInput ? 0L : this.reader.tell();
    }

    public void close() throws IOException {
        if (!this.isEmptyInput) {
            this.reader.close();
        }
    }

    public float getProgress() throws IOException {
        return this.stop == this.start ? 0.0f : Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.stop - this.start));
    }

    public void configure(JobConf jobConf) {
        this.jobConf = jobConf;
    }
}

