/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.Ref;
import org.apache.orc.FileFormatException;
import org.apache.orc.impl.OrcAcidUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidUtils {
    public static final String CONF_ACID_KEY = "hive.doing.acid";
    public static final String BASE_PREFIX = "base_";
    public static final String COMPACTOR_TABLE_PROPERTY = "compactiontable";
    public static final PathFilter baseFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BASE_PREFIX);
        }
    };
    public static final String DELTA_PREFIX = "delta_";
    public static final String DELETE_DELTA_PREFIX = "delete_delta_";
    public static final String DELTA_SIDE_FILE_SUFFIX = "_flush_length";
    public static final PathFilter deltaFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELTA_PREFIX);
        }
    };
    public static final PathFilter deleteEventDeltaDirFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELETE_DELTA_PREFIX);
        }
    };
    public static final String BUCKET_PREFIX = "bucket_";
    public static final PathFilter bucketFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BUCKET_PREFIX) && !path.getName().endsWith(AcidUtils.DELTA_SIDE_FILE_SUFFIX);
        }
    };
    public static final String BUCKET_DIGITS = "%05d";
    public static final String LEGACY_FILE_BUCKET_DIGITS = "%06d";
    public static final String DELTA_DIGITS = "%07d";
    public static final String STATEMENT_DIGITS = "%04d";
    public static final int MAX_STATEMENTS_PER_TXN = 10000;
    public static final Pattern LEGACY_BUCKET_DIGIT_PATTERN = Pattern.compile("^[0-9]{6}");
    public static final Pattern BUCKET_PATTERN = Pattern.compile("bucket_([0-9]+)(_[0-9]+)?$");
    private static Cache<String, DirInfoValue> dirCache;
    private static AtomicBoolean dirCacheInited;
    public static final PathFilter originalBucketFilter;
    private static final Logger LOG;
    public static final Pattern ORIGINAL_PATTERN;
    public static final Pattern ORIGINAL_PATTERN_COPY;
    public static final PathFilter hiddenFileFilter;
    public static final PathFilter acidHiddenFileFilter;
    public static final PathFilter acidTempDirFilter;
    public static final String VISIBILITY_PREFIX = "_v";
    public static final Pattern VISIBILITY_PATTERN;
    private static final HadoopShims SHIMS;

    private AcidUtils() {
    }

    public static Path createBucketFile(Path subdir, int bucket) {
        return AcidUtils.createBucketFile(subdir, bucket, null, true);
    }

    public static Path createBucketFile(Path subdir, int bucket, String attemptId) {
        return AcidUtils.createBucketFile(subdir, bucket, attemptId, true);
    }

    private static Path createBucketFile(Path subdir, int bucket, String attemptId, boolean isAcidSchema) {
        if (isAcidSchema) {
            String fileName = BUCKET_PREFIX + String.format(BUCKET_DIGITS, bucket);
            if (attemptId != null) {
                fileName = fileName + "_" + attemptId;
            }
            return new Path(subdir, fileName);
        }
        return new Path(subdir, String.format(BUCKET_DIGITS, bucket));
    }

    public static String deltaSubdir(long min, long max) {
        return DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    public static String deltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    @VisibleForTesting
    public static String deleteDeltaSubdir(long min, long max) {
        return DELETE_DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    @VisibleForTesting
    public static String deleteDeltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deleteDeltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    public static String baseDir(long writeId) {
        return BASE_PREFIX + String.format(DELTA_DIGITS, writeId);
    }

    public static String baseOrDeltaSubdir(boolean baseDirRequired, long min, long max, int statementId) {
        if (!baseDirRequired) {
            return AcidUtils.deltaSubdir(min, max, statementId);
        }
        return AcidUtils.baseDir(min);
    }

    public static Path baseOrDeltaSubdirPath(Path directory, AcidOutputFormat.Options options) {
        String subdir = options.isWritingBase() ? BASE_PREFIX + String.format(DELTA_DIGITS, options.getMaximumWriteId()) : (options.getStatementId() == -1 ? (options.isWritingDeleteDelta() ? AcidUtils.deleteDeltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId()) : AcidUtils.deltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId())) : (options.isWritingDeleteDelta() ? AcidUtils.deleteDeltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId(), options.getStatementId()) : AcidUtils.deltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId(), options.getStatementId())));
        subdir = AcidUtils.addVisibilitySuffix(subdir, options.getVisibilityTxnId());
        return new Path(directory, subdir);
    }

    public static Path createFilename(Path directory, AcidOutputFormat.Options options) {
        if (options.getOldStyle()) {
            return new Path(directory, String.format(LEGACY_FILE_BUCKET_DIGITS, options.getBucketId()) + "_0");
        }
        return AcidUtils.createBucketFile(AcidUtils.baseOrDeltaSubdirPath(directory, options), options.getBucketId(), options.getAttemptId());
    }

    static String addVisibilitySuffix(String baseOrDeltaDir, long visibilityTxnId) {
        if (visibilityTxnId == 0L) {
            return baseOrDeltaDir;
        }
        return baseOrDeltaDir + VISIBILITY_PREFIX + String.format(DELTA_DIGITS, visibilityTxnId);
    }

    public static boolean isCompactionTable(Properties tblProperties) {
        return tblProperties != null && tblProperties.containsKey(COMPACTOR_TABLE_PROPERTY) && tblProperties.getProperty(COMPACTOR_TABLE_PROPERTY).equalsIgnoreCase("true");
    }

    public static boolean isCompactionTable(Map<String, String> parameters) {
        return Boolean.valueOf(parameters.getOrDefault(COMPACTOR_TABLE_PROPERTY, "false"));
    }

    public static int parseBucketId(Path bucketFile) {
        return BucketMetaData.parse((Path)bucketFile).bucketId;
    }

    public static String parseAttemptId(Path bucketFile) {
        String filename = bucketFile.getName();
        Matcher matcher = BUCKET_PATTERN.matcher(filename);
        String attemptId = null;
        if (matcher.matches()) {
            String string = attemptId = matcher.group(2) != null ? matcher.group(2).substring(1) : null;
        }
        if (Utilities.FILE_OP_LOGGER.isDebugEnabled()) {
            Utilities.FILE_OP_LOGGER.debug("Parsing attempt ID = " + attemptId + " from file name '" + bucketFile + "'");
        }
        return attemptId;
    }

    public static AcidOutputFormat.Options parseBaseOrDeltaBucketFilename(Path bucketFile, Configuration conf) throws IOException {
        AcidOutputFormat.Options result = new AcidOutputFormat.Options(conf);
        String filename = bucketFile.getName();
        int bucket = AcidUtils.parseBucketId(bucketFile);
        String attemptId = AcidUtils.parseAttemptId(bucketFile);
        if (ORIGINAL_PATTERN.matcher(filename).matches()) {
            result.setOldStyle(true).minimumWriteId(0L).maximumWriteId(0L).bucket(bucket).writingBase(!bucketFile.getParent().getName().startsWith(DELTA_PREFIX));
        } else if (ORIGINAL_PATTERN_COPY.matcher(filename).matches()) {
            int copyNumber = Integer.parseInt(filename.substring(filename.lastIndexOf(95) + 1));
            result.setOldStyle(true).minimumWriteId(0L).maximumWriteId(0L).bucket(bucket).copyNumber(copyNumber).writingBase(!bucketFile.getParent().getName().startsWith(DELTA_PREFIX));
        } else if (filename.startsWith(BUCKET_PREFIX)) {
            if (bucketFile.getParent().getName().startsWith(BASE_PREFIX)) {
                result.setOldStyle(false).minimumWriteId(0L).maximumWriteId(ParsedBase.parseBase(bucketFile.getParent()).getWriteId()).bucket(bucket).writingBase(true);
            } else if (bucketFile.getParent().getName().startsWith(DELTA_PREFIX)) {
                ParsedDelta parsedDelta = AcidUtils.parsedDelta(bucketFile.getParent(), DELTA_PREFIX, bucketFile.getFileSystem(conf), null);
                result.setOldStyle(false).minimumWriteId(parsedDelta.minWriteId).maximumWriteId(parsedDelta.maxWriteId).bucket(bucket).attemptId(attemptId);
            } else if (bucketFile.getParent().getName().startsWith(DELETE_DELTA_PREFIX)) {
                ParsedDelta parsedDelta = AcidUtils.parsedDelta(bucketFile.getParent(), DELETE_DELTA_PREFIX, bucketFile.getFileSystem(conf), null);
                result.setOldStyle(false).minimumWriteId(parsedDelta.minWriteId).maximumWriteId(parsedDelta.maxWriteId).bucket(bucket);
            }
        } else {
            result.setOldStyle(true).bucket(bucket).minimumWriteId(0L).maximumWriteId(0L);
        }
        return result;
    }

    public static DataOperationType toDataOperationType(Operation op) {
        switch (op) {
            case NOT_ACID: {
                return DataOperationType.UNSET;
            }
            case INSERT: {
                return DataOperationType.INSERT;
            }
            case UPDATE: {
                return DataOperationType.UPDATE;
            }
            case DELETE: {
                return DataOperationType.DELETE;
            }
        }
        throw new IllegalArgumentException("Unexpected Operation: " + op);
    }

    public static Path[] getPaths(List<ParsedDelta> deltas) {
        Path[] result = new Path[deltas.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = deltas.get(i).getPath();
        }
        return result;
    }

    public static List<AcidInputFormat.DeltaMetaData> serializeDeltas(List<ParsedDelta> deltas) {
        ArrayList<AcidInputFormat.DeltaMetaData> result = new ArrayList<AcidInputFormat.DeltaMetaData>(deltas.size());
        AcidInputFormat.DeltaMetaData last = null;
        for (ParsedDelta parsedDelta : deltas) {
            assert (parsedDelta.isDeleteDelta()) : "expected delete_delta, got " + parsedDelta.getPath();
            if (last != null && last.getMinWriteId() == parsedDelta.getMinWriteId() && last.getMaxWriteId() == parsedDelta.getMaxWriteId()) {
                last.getStmtIds().add(parsedDelta.getStatementId());
                continue;
            }
            last = new AcidInputFormat.DeltaMetaData(parsedDelta.getMinWriteId(), parsedDelta.getMaxWriteId(), new ArrayList<Integer>(), parsedDelta.getVisibilityTxnId());
            result.add(last);
            if (parsedDelta.statementId < 0) continue;
            last.getStmtIds().add(parsedDelta.getStatementId());
        }
        return result;
    }

    public static Path[] deserializeDeleteDeltas(Path root, List<AcidInputFormat.DeltaMetaData> deleteDeltas) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>(deleteDeltas.size());
        for (AcidInputFormat.DeltaMetaData dmd : deleteDeltas) {
            if (dmd.getStmtIds().isEmpty()) {
                results.add(new Path(root, dmd.getName()));
                continue;
            }
            for (Integer stmtId : dmd.getStmtIds()) {
                results.add(new Path(root, dmd.getName(stmtId)));
            }
        }
        return results.toArray(new Path[results.size()]);
    }

    public static ParsedDelta parsedDelta(Path deltaDir, FileSystem fs) throws IOException {
        String deltaDirName = deltaDir.getName();
        if (deltaDirName.startsWith(DELETE_DELTA_PREFIX)) {
            return AcidUtils.parsedDelta(deltaDir, DELETE_DELTA_PREFIX, fs, null);
        }
        return AcidUtils.parsedDelta(deltaDir, DELTA_PREFIX, fs, null);
    }

    private static ParsedDelta parseDelta(Path path, String deltaPrefix, FileSystem fs, HdfsDirSnapshot dirSnapshot) throws IOException {
        ParsedDelta p = AcidUtils.parsedDelta(path, deltaPrefix, fs, dirSnapshot);
        boolean isDeleteDelta = deltaPrefix.equals(DELETE_DELTA_PREFIX);
        return new ParsedDelta(p.getMinWriteId(), p.getMaxWriteId(), path, p.statementId, isDeleteDelta, p.isRawFormat(), p.visibilityTxnId);
    }

    public static ParsedDelta parsedDelta(Path deltaDir, String deltaPrefix, FileSystem fs, HdfsDirSnapshot dirSnapshot) throws IOException {
        String filename = deltaDir.getName();
        boolean isDeleteDelta = deltaPrefix.equals(DELETE_DELTA_PREFIX);
        if (filename.startsWith(deltaPrefix)) {
            boolean isRawFormat = !isDeleteDelta && MetaDataFile.isRawFormat(deltaDir, fs, dirSnapshot);
            return AcidUtils.parsedDelta(deltaDir, isRawFormat);
        }
        throw new IllegalArgumentException(deltaDir + " does not start with " + deltaPrefix);
    }

    public static ParsedDelta parsedDelta(Path deltaDir, boolean isRawFormat) {
        long max;
        boolean isDeleteDelta;
        String filename = deltaDir.getName();
        int idxOfVis = filename.indexOf(VISIBILITY_PREFIX);
        long visibilityTxnId = 0L;
        if (idxOfVis >= 0) {
            visibilityTxnId = Long.parseLong(filename.substring(idxOfVis + VISIBILITY_PREFIX.length()));
            filename = filename.substring(0, idxOfVis);
        }
        isRawFormat = (isDeleteDelta = filename.startsWith(DELETE_DELTA_PREFIX)) ? false : isRawFormat;
        String rest = filename.substring((isDeleteDelta ? DELETE_DELTA_PREFIX : DELTA_PREFIX).length());
        int split = rest.indexOf(95);
        int split2 = rest.indexOf(95, split + 1);
        long min = Long.parseLong(rest.substring(0, split));
        long l = max = split2 == -1 ? Long.parseLong(rest.substring(split + 1)) : Long.parseLong(rest.substring(split + 1, split2));
        if (split2 == -1) {
            return new ParsedDelta(min, max, null, isDeleteDelta, isRawFormat, visibilityTxnId);
        }
        int statementId = Integer.parseInt(rest.substring(split2 + 1));
        return new ParsedDelta(min, max, null, statementId, isDeleteDelta, isRawFormat, visibilityTxnId);
    }

    public static boolean isAcid(FileSystem fileSystem, Path directory, Configuration conf) throws IOException {
        FileSystem fs = fileSystem == null ? directory.getFileSystem(conf) : fileSystem;
        for (FileStatus file : fs.listStatus(directory)) {
            String filename = file.getPath().getName();
            if (!filename.startsWith(BASE_PREFIX) && !filename.startsWith(DELTA_PREFIX) && !filename.startsWith(DELETE_DELTA_PREFIX) || !file.isDir()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public static Directory getAcidState(FileSystem fileSystem, Path candidateDirectory, Configuration conf, ValidWriteIdList writeIdList, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles, Map<String, String> tblproperties, boolean generateDirSnapshots) throws IOException {
        ValidReadTxnList validTxnList = null;
        String s = conf.get("hive.txn.valid.txns");
        if (!Strings.isNullOrEmpty(s)) {
            validTxnList = new ValidReadTxnList();
            validTxnList.readFromString(s);
        }
        FileSystem fs = fileSystem == null ? candidateDirectory.getFileSystem(conf) : fileSystem;
        ArrayList<ParsedDelta> deltas = new ArrayList<ParsedDelta>();
        ArrayList<ParsedDelta> working = new ArrayList<ParsedDelta>();
        ArrayList<Path> originalDirectories = new ArrayList<Path>();
        ArrayList<Path> obsolete = new ArrayList<Path>();
        ArrayList<Path> abortedDirectories = new ArrayList<Path>();
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId = AcidUtils.tryListLocatedHdfsStatus(useFileIds, fs, candidateDirectory);
        TxnBase bestBase = new TxnBase();
        ArrayList<HadoopShims.HdfsFileStatusWithId> original = new ArrayList<HadoopShims.HdfsFileStatusWithId>();
        Map<Path, HdfsDirSnapshot> dirSnapshots = null;
        if (childrenWithId != null) {
            for (HadoopShims.HdfsFileStatusWithId hdfsFileStatusWithId : childrenWithId) {
                AcidUtils.getChildState(hdfsFileStatusWithId.getFileStatus(), hdfsFileStatusWithId, writeIdList, working, originalDirectories, original, obsolete, bestBase, ignoreEmptyFiles, abortedDirectories, tblproperties, fs, (ValidTxnList)validTxnList);
            }
        } else if (generateDirSnapshots) {
            dirSnapshots = AcidUtils.getHdfsDirSnapshots(fs, candidateDirectory);
            AcidUtils.getChildState(candidateDirectory, dirSnapshots, writeIdList, working, originalDirectories, original, obsolete, bestBase, ignoreEmptyFiles, abortedDirectories, tblproperties, fs, (ValidTxnList)validTxnList);
        } else {
            Iterator children = HdfsUtils.listLocatedStatus(fs, candidateDirectory, hiddenFileFilter);
            Iterator<FileStatus> iterator = children.iterator();
            while (iterator.hasNext()) {
                FileStatus child2 = iterator.next();
                AcidUtils.getChildState(child2, null, writeIdList, working, originalDirectories, original, obsolete, bestBase, ignoreEmptyFiles, abortedDirectories, tblproperties, fs, (ValidTxnList)validTxnList);
            }
        }
        if (bestBase.status != null) {
            for (HadoopShims.HdfsFileStatusWithId hdfsFileStatusWithId : original) {
                obsolete.add(hdfsFileStatusWithId.getFileStatus().getPath());
            }
            obsolete.addAll(originalDirectories);
            original.clear();
            originalDirectories.clear();
        } else if (dirSnapshots == null) {
            for (Path path : originalDirectories) {
                AcidUtils.findOriginals(fs, path, original, useFileIds, ignoreEmptyFiles, true);
            }
        }
        Collections.sort(working);
        long current = bestBase.writeId;
        int lastStmtId = -1;
        ParsedDelta prev = null;
        for (ParsedDelta next : working) {
            if (next.maxWriteId > current) {
                if (writeIdList.isWriteIdRangeValid(current + 1L, next.maxWriteId) == ValidWriteIdList.RangeResponse.NONE) continue;
                deltas.add(next);
                current = next.maxWriteId;
                lastStmtId = next.statementId;
                prev = next;
                continue;
            }
            if (next.maxWriteId == current && lastStmtId >= 0) {
                deltas.add(next);
                prev = next;
                continue;
            }
            if (prev != null && next.maxWriteId == prev.maxWriteId && next.minWriteId == prev.minWriteId && next.statementId == prev.statementId) {
                deltas.add(next);
                prev = next;
                continue;
            }
            obsolete.add(next.path);
        }
        if (bestBase.oldestBase != null && bestBase.status == null && AcidUtils.isCompactedBase(ParsedBase.parseBase(bestBase.oldestBase), fs, dirSnapshots)) {
            long[] exceptions = writeIdList.getInvalidWriteIds();
            String minOpenWriteId = exceptions != null && exceptions.length > 0 ? Long.toString(exceptions[0]) : "x";
            throw new IOException(ErrorMsg.ACID_NOT_ENOUGH_HISTORY.format(Long.toString(writeIdList.getHighWatermark()), minOpenWriteId, bestBase.oldestBase.toString()));
        }
        Path base = null;
        boolean isBaseInRawFormat = false;
        if (bestBase.status != null && (isBaseInRawFormat = MetaDataFile.isRawFormat(base = bestBase.status.getPath(), fs, dirSnapshots != null ? dirSnapshots.get(base) : null)) && bestBase.dirSnapShot != null) {
            for (FileStatus stat : bestBase.dirSnapShot.getFiles()) {
                if (ignoreEmptyFiles && stat.getLen() == 0L) continue;
                original.add(AcidUtils.createOriginalObj(null, stat));
            }
        }
        LOG.debug("in directory " + candidateDirectory.toUri().toString() + " base = " + base + " deltas = " + deltas.size());
        Collections.sort(original, (o1, o2) -> o1.getFileStatus().compareTo(o2.getFileStatus()));
        return new DirectoryImpl(abortedDirectories, isBaseInRawFormat, original, obsolete, deltas, base);
    }

    public static Map<Path, HdfsDirSnapshot> getHdfsDirSnapshots(FileSystem fs, Path path) throws IOException {
        try {
            HashMap<Path, HdfsDirSnapshot> dirToSnapshots = new HashMap<Path, HdfsDirSnapshot>();
            RemoteIterator itr = fs.listFiles(path, true);
            while (itr.hasNext()) {
                FileStatus fStatus = (FileStatus)itr.next();
                Path fPath = fStatus.getPath();
                if (!acidHiddenFileFilter.accept(fPath)) continue;
                if (fStatus.isDirectory() && acidTempDirFilter.accept(fPath)) {
                    HdfsDirSnapshot dirSnapshot = (HdfsDirSnapshot)dirToSnapshots.get(fPath);
                    if (dirSnapshot != null) continue;
                    dirSnapshot = new HdfsDirSnapshotImpl(fPath, fStatus);
                    dirToSnapshots.put(fPath, dirSnapshot);
                    continue;
                }
                Path parentDirPath = fPath.getParent();
                if (!acidTempDirFilter.accept(parentDirPath)) continue;
                HdfsDirSnapshot dirSnapshot = (HdfsDirSnapshot)dirToSnapshots.get(parentDirPath);
                if (dirSnapshot == null) {
                    FileStatus parentDirFStatus = null;
                    if (!parentDirPath.equals((Object)path)) {
                        parentDirFStatus = fs.getFileStatus(parentDirPath);
                    }
                    dirSnapshot = new HdfsDirSnapshotImpl(parentDirPath, parentDirFStatus);
                    dirToSnapshots.put(parentDirPath, dirSnapshot);
                }
                if (fStatus.getPath().toString().contains("_metadata_acid")) {
                    dirSnapshot.addMetadataFile(fStatus);
                    continue;
                }
                if (fStatus.getPath().toString().contains("_orc_acid_version")) {
                    dirSnapshot.addOrcAcidFormatFile(fStatus);
                    continue;
                }
                dirSnapshot.addFile(fStatus);
            }
            return dirToSnapshots;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private static boolean isValidBase(ParsedBase parsedBase, ValidWriteIdList writeIdList, FileSystem fs) throws IOException {
        if (parsedBase.getWriteId() == Long.MIN_VALUE) {
            return true;
        }
        if (writeIdList.getMinOpenWriteId() != null && parsedBase.getWriteId() <= writeIdList.getMinOpenWriteId()) {
            return true;
        }
        if (AcidUtils.isCompactedBase(parsedBase, fs, (HdfsDirSnapshot)null)) {
            return writeIdList.isValidBase(parsedBase.getWriteId());
        }
        return writeIdList.isWriteIdValid(parsedBase.getWriteId());
    }

    private static boolean isValidBase(HdfsDirSnapshot dirSnapshot, ParsedBase parsedBase, ValidWriteIdList writeIdList, FileSystem fs) throws IOException {
        boolean isValidBase;
        if (dirSnapshot.isValidBase() != null) {
            isValidBase = dirSnapshot.isValidBase();
        } else {
            isValidBase = AcidUtils.isCompactedBase(parsedBase, fs, dirSnapshot) ? writeIdList.isValidBase(parsedBase.getWriteId()) : writeIdList.isWriteIdValid(parsedBase.getWriteId());
            dirSnapshot.setIsValidBase(isValidBase);
        }
        return isValidBase;
    }

    private static boolean isCompactedBase(ParsedBase parsedBase, FileSystem fs, Map<Path, HdfsDirSnapshot> snapshotMap) throws IOException {
        return AcidUtils.isCompactedBase(parsedBase, fs, snapshotMap != null ? snapshotMap.get(parsedBase.getBaseDirPath()) : null);
    }

    private static boolean isCompactedBase(ParsedBase parsedBase, FileSystem fs, HdfsDirSnapshot snapshot) throws IOException {
        return parsedBase.getVisibilityTxnId() > 0L || MetaDataFile.isCompacted(parsedBase.getBaseDirPath(), fs, snapshot);
    }

    private static void getChildState(FileStatus child, HadoopShims.HdfsFileStatusWithId childWithId, ValidWriteIdList writeIdList, List<ParsedDelta> working, List<Path> originalDirectories, List<HadoopShims.HdfsFileStatusWithId> original, List<Path> obsolete, TxnBase bestBase, boolean ignoreEmptyFiles, List<Path> aborted, Map<String, String> tblproperties, FileSystem fs, ValidTxnList validTxnList) throws IOException {
        Path p = child.getPath();
        String fn = p.getName();
        if (!child.isDirectory()) {
            if (!ignoreEmptyFiles || child.getLen() != 0L) {
                original.add(AcidUtils.createOriginalObj(childWithId, child));
            }
            return;
        }
        if (fn.startsWith(BASE_PREFIX)) {
            ParsedBase parsedBase = ParsedBase.parseBase(p);
            if (!AcidUtils.isDirUsable(child.getPath(), parsedBase.getVisibilityTxnId(), aborted, validTxnList)) {
                return;
            }
            long writeId = parsedBase.getWriteId();
            if (bestBase.oldestBaseWriteId > writeId) {
                bestBase.oldestBase = p;
                bestBase.oldestBaseWriteId = writeId;
            }
            if (bestBase.status == null) {
                if (AcidUtils.isValidBase(parsedBase, writeIdList, fs)) {
                    bestBase.status = child;
                    bestBase.writeId = writeId;
                }
            } else if (bestBase.writeId < writeId) {
                if (AcidUtils.isValidBase(parsedBase, writeIdList, fs)) {
                    obsolete.add(bestBase.status.getPath());
                    bestBase.status = child;
                    bestBase.writeId = writeId;
                }
            } else {
                obsolete.add(child.getPath());
            }
        } else if (fn.startsWith(DELTA_PREFIX) || fn.startsWith(DELETE_DELTA_PREFIX)) {
            String deltaPrefix = fn.startsWith(DELTA_PREFIX) ? DELTA_PREFIX : DELETE_DELTA_PREFIX;
            ParsedDelta delta = AcidUtils.parseDelta(child.getPath(), deltaPrefix, fs, null);
            if (!AcidUtils.isDirUsable(child.getPath(), delta.getVisibilityTxnId(), aborted, validTxnList)) {
                return;
            }
            if (ValidWriteIdList.RangeResponse.ALL == writeIdList.isWriteIdRangeAborted(delta.minWriteId, delta.maxWriteId)) {
                aborted.add(child.getPath());
            } else if (writeIdList.isWriteIdRangeValid(delta.minWriteId, delta.maxWriteId) != ValidWriteIdList.RangeResponse.NONE) {
                working.add(delta);
            }
        } else {
            originalDirectories.add(child.getPath());
        }
    }

    private static void getChildState(Path candidateDirectory, Map<Path, HdfsDirSnapshot> dirSnapshots, ValidWriteIdList writeIdList, List<ParsedDelta> working, List<Path> originalDirectories, List<HadoopShims.HdfsFileStatusWithId> original, List<Path> obsolete, TxnBase bestBase, boolean ignoreEmptyFiles, List<Path> aborted, Map<String, String> tblproperties, FileSystem fs, ValidTxnList validTxnList) throws IOException {
        for (HdfsDirSnapshot dirSnapshot : dirSnapshots.values()) {
            FileStatus fStat = dirSnapshot.getFileStatus();
            Path dirPath = dirSnapshot.getPath();
            String dirName = dirPath.getName();
            if (dirPath.equals((Object)candidateDirectory)) {
                for (FileStatus fileStatus : dirSnapshot.getFiles()) {
                    if (ignoreEmptyFiles && fileStatus.getLen() == 0L) continue;
                    original.add(AcidUtils.createOriginalObj(null, fileStatus));
                }
                continue;
            }
            if (dirName.startsWith(BASE_PREFIX)) {
                bestBase.dirSnapShot = dirSnapshot;
                ParsedBase parsedBase = ParsedBase.parseBase(dirPath);
                if (!AcidUtils.isDirUsable(dirPath, parsedBase.getVisibilityTxnId(), aborted, validTxnList)) continue;
                long writeId = parsedBase.getWriteId();
                if (bestBase.oldestBaseWriteId > writeId) {
                    bestBase.oldestBase = dirPath;
                    bestBase.oldestBaseWriteId = writeId;
                }
                if (bestBase.status == null) {
                    if (!AcidUtils.isValidBase(dirSnapshot, parsedBase, writeIdList, fs)) continue;
                    bestBase.status = fStat;
                    bestBase.writeId = writeId;
                    continue;
                }
                if (bestBase.writeId < writeId) {
                    if (!AcidUtils.isValidBase(dirSnapshot, parsedBase, writeIdList, fs)) continue;
                    obsolete.add(bestBase.status.getPath());
                    bestBase.status = fStat;
                    bestBase.writeId = writeId;
                    continue;
                }
                obsolete.add(dirPath);
                continue;
            }
            if (dirName.startsWith(DELTA_PREFIX) || dirName.startsWith(DELETE_DELTA_PREFIX)) {
                String deltaPrefix = dirName.startsWith(DELTA_PREFIX) ? DELTA_PREFIX : DELETE_DELTA_PREFIX;
                ParsedDelta delta = AcidUtils.parseDelta(dirPath, deltaPrefix, fs, dirSnapshot);
                if (!AcidUtils.isDirUsable(dirPath, delta.getVisibilityTxnId(), aborted, validTxnList)) continue;
                if (ValidWriteIdList.RangeResponse.ALL == writeIdList.isWriteIdRangeAborted(delta.minWriteId, delta.maxWriteId)) {
                    aborted.add(dirPath);
                    continue;
                }
                if (writeIdList.isWriteIdRangeValid(delta.minWriteId, delta.maxWriteId) == ValidWriteIdList.RangeResponse.NONE) continue;
                working.add(delta);
                continue;
            }
            originalDirectories.add(dirPath);
            for (FileStatus stat : dirSnapshot.getFiles()) {
                if (ignoreEmptyFiles && stat.getLen() == 0L) continue;
                original.add(AcidUtils.createOriginalObj(null, stat));
            }
        }
    }

    private static boolean isDirUsable(Path child, long visibilityTxnId, List<Path> aborted, ValidTxnList validTxnList) {
        if (validTxnList == null) {
            throw new IllegalArgumentException("No ValidTxnList for " + child);
        }
        if (!validTxnList.isTxnValid(visibilityTxnId)) {
            boolean isAborted = validTxnList.isTxnAborted(visibilityTxnId);
            if (isAborted) {
                aborted.add(child);
            }
            LOG.debug("getChildState() ignoring(" + aborted + ") " + child);
            return false;
        }
        return true;
    }

    public static HadoopShims.HdfsFileStatusWithId createOriginalObj(HadoopShims.HdfsFileStatusWithId childWithId, FileStatus child) {
        return childWithId != null ? childWithId : new HdfsFileStatusWithoutId(child);
    }

    public static void findOriginals(FileSystem fs, Path dir, List<HadoopShims.HdfsFileStatusWithId> original, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles, boolean recursive) throws IOException {
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId = AcidUtils.tryListLocatedHdfsStatus(useFileIds, fs, dir);
        if (childrenWithId != null) {
            for (HadoopShims.HdfsFileStatusWithId child : childrenWithId) {
                if (child.getFileStatus().isDirectory()) {
                    if (!recursive) continue;
                    AcidUtils.findOriginals(fs, child.getFileStatus().getPath(), original, useFileIds, ignoreEmptyFiles, true);
                    continue;
                }
                if (ignoreEmptyFiles && child.getFileStatus().getLen() <= 0L) continue;
                original.add(child);
            }
        } else {
            List<FileStatus> children = HdfsUtils.listLocatedStatus(fs, dir, hiddenFileFilter);
            for (FileStatus child : children) {
                if (child.isDirectory()) {
                    if (!recursive) continue;
                    AcidUtils.findOriginals(fs, child.getPath(), original, useFileIds, ignoreEmptyFiles, true);
                    continue;
                }
                if (ignoreEmptyFiles && child.getLen() <= 0L) continue;
                original.add(AcidUtils.createOriginalObj(null, child));
            }
        }
    }

    private static List<HadoopShims.HdfsFileStatusWithId> tryListLocatedHdfsStatus(Ref<Boolean> useFileIds, FileSystem fs, Path directory) {
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId;
        block5: {
            childrenWithId = null;
            if (useFileIds == null) {
                return childrenWithId;
            }
            Boolean val = (Boolean)useFileIds.value;
            if (val == null || val.booleanValue()) {
                try {
                    childrenWithId = SHIMS.listLocatedHdfsStatus(fs, directory, hiddenFileFilter);
                    if (val == null) {
                        useFileIds.value = true;
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed to get files with ID; using regular API: " + t.getMessage());
                    if (val != null || !(t instanceof UnsupportedOperationException)) break block5;
                    useFileIds.value = false;
                }
            }
        }
        return childrenWithId;
    }

    public static boolean isTablePropertyTransactional(Properties props) {
        String resultStr = props.getProperty("transactional");
        if (resultStr == null) {
            resultStr = props.getProperty("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isTablePropertyTransactional(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional");
        if (resultStr == null) {
            resultStr = parameters.get("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isTablePropertyTransactional(Configuration conf) {
        String resultStr = conf.get("transactional");
        if (resultStr == null) {
            resultStr = conf.get("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isDeleteDelta(Path p) {
        return p.getName().startsWith(DELETE_DELTA_PREFIX);
    }

    public static boolean isInsertDelta(Path p) {
        return p.getName().startsWith(DELTA_PREFIX);
    }

    public static boolean isTransactionalTable(CreateTableDesc table) {
        if (table == null || table.getTblProps() == null) {
            return false;
        }
        return AcidUtils.isTransactionalTable(table.getTblProps());
    }

    public static boolean isTransactionalTable(Map<String, String> props) {
        String tableIsTransactional = props.get("transactional");
        if (tableIsTransactional == null) {
            tableIsTransactional = props.get("transactional".toUpperCase());
        }
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static boolean isFullAcidTable(org.apache.hadoop.hive.ql.metadata.Table table) {
        return AcidUtils.isFullAcidTable(table == null ? null : table.getTTable());
    }

    public static boolean isTransactionalTable(org.apache.hadoop.hive.ql.metadata.Table table) {
        return AcidUtils.isTransactionalTable(table == null ? null : table.getTTable());
    }

    public static boolean isFullAcidTable(Table table) {
        return AcidUtils.isTransactionalTable(table) && !AcidUtils.isInsertOnlyTable(table.getParameters());
    }

    public static boolean isFullAcidTable(Map<String, String> params) {
        return AcidUtils.isTransactionalTable(params) && !AcidUtils.isInsertOnlyTable(params);
    }

    public static boolean isTransactionalTable(Table table) {
        return table != null && table.getParameters() != null && AcidUtils.isTablePropertyTransactional(table.getParameters());
    }

    public static boolean isFullAcidTable(CreateTableDesc td) {
        if (td == null || td.getTblProps() == null) {
            return false;
        }
        String tableIsTransactional = td.getTblProps().get("transactional");
        if (tableIsTransactional == null) {
            tableIsTransactional = td.getTblProps().get("transactional".toUpperCase());
        }
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true") && !AcidUtils.isInsertOnlyTable(td.getTblProps());
    }

    public static boolean isFullAcidScan(Configuration conf) {
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN)) {
            return false;
        }
        int propInt = conf.getInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, -1);
        if (propInt == -1) {
            return true;
        }
        AcidOperationalProperties props = AcidOperationalProperties.parseInt(propInt);
        return !props.isInsertOnly();
    }

    public static void setAcidOperationalProperties(Configuration conf, boolean isTxnTable, AcidOperationalProperties properties) {
        if (isTxnTable) {
            HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, isTxnTable);
            if (properties != null) {
                HiveConf.setIntVar(conf, HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES, properties.toInt());
            }
        } else {
            conf.unset(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname);
            conf.unset(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname);
        }
    }

    public static void setAcidOperationalProperties(Map<String, String> parameters, boolean isTxnTable, AcidOperationalProperties properties) {
        parameters.put(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname, Boolean.toString(isTxnTable));
        if (properties != null) {
            parameters.put(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, properties.toString());
        }
    }

    public static AcidOperationalProperties getAcidOperationalProperties(org.apache.hadoop.hive.ql.metadata.Table table) {
        String transactionalProperties = table.getProperty("transactional_properties");
        if (transactionalProperties == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(transactionalProperties);
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Configuration conf) {
        return AcidOperationalProperties.parseInt(HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES));
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Properties props) {
        String resultStr = props.getProperty("transactional_properties");
        if (resultStr == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(resultStr);
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional_properties");
        if (resultStr == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(resultStr);
    }

    public static long getLogicalLength(FileSystem fs, FileStatus file) throws IOException {
        Path acidDir = file.getPath().getParent();
        if (AcidUtils.isInsertDelta(acidDir)) {
            ParsedDeltaLight pd = ParsedDeltaLight.parse(acidDir);
            if (!pd.mayContainSideFile()) {
                return file.getLen();
            }
        } else {
            return file.getLen();
        }
        Path lengths = OrcAcidUtils.getSideFile(file.getPath());
        if (!fs.exists(lengths)) {
            return file.getLen();
        }
        long len = OrcAcidUtils.getLastFlushLength(fs, file.getPath());
        if (len >= 0L) {
            return len;
        }
        throw new IOException(lengths + " found but is not readable.  Consider waiting or orcfiledump --recover");
    }

    public static boolean isInsertOnlyTable(Map<String, String> params) {
        return AcidUtils.isInsertOnlyTable(params, false);
    }

    public static boolean isInsertOnlyTable(org.apache.hadoop.hive.ql.metadata.Table table) {
        return AcidUtils.isTransactionalTable(table) && AcidUtils.getAcidOperationalProperties(table).isInsertOnly();
    }

    public static boolean isInsertOnlyTable(Map<String, String> params, boolean isCtas) {
        String transactionalProp = params.get("transactional_properties");
        return transactionalProp != null && "insert_only".equalsIgnoreCase(transactionalProp);
    }

    public static boolean isInsertOnlyTable(Properties params) {
        String transactionalProp = params.getProperty("transactional_properties");
        return transactionalProp != null && "insert_only".equalsIgnoreCase(transactionalProp);
    }

    public static Boolean isToInsertOnlyTable(org.apache.hadoop.hive.ql.metadata.Table tbl, Map<String, String> props) {
        String transactional = props.get("transactional");
        String transactionalProp = props.get("transactional_properties");
        if (transactional == null && transactionalProp == null) {
            return null;
        }
        if (transactional == null && tbl != null) {
            transactional = tbl.getParameters().get("transactional");
        }
        boolean isSetToTxn = "true".equalsIgnoreCase(transactional);
        if (transactionalProp == null) {
            if (isSetToTxn || tbl == null) {
                return false;
            }
            throw new RuntimeException("Cannot change 'transactional' without 'transactional_properties'");
        }
        if (!"insert_only".equalsIgnoreCase(transactionalProp)) {
            return false;
        }
        if (!isSetToTxn) {
            if (tbl == null) {
                return true;
            }
            throw new RuntimeException("Cannot set 'transactional_properties' to 'insert_only' without setting 'transactional' to 'true'");
        }
        return true;
    }

    public static boolean isRemovedInsertOnlyTable(Set<String> removedSet) {
        boolean hasTxn = removedSet.contains("transactional");
        boolean hasProps = removedSet.contains("transactional_properties");
        return hasTxn || hasProps;
    }

    public static ValidTxnWriteIdList getValidTxnWriteIdList(Configuration conf) {
        String txnString = conf.get("hive.txn.tables.valid.writeids");
        ValidTxnWriteIdList validTxnList = new ValidTxnWriteIdList(txnString);
        return validTxnList;
    }

    public static ValidWriteIdList getTableValidWriteIdList(Configuration conf, String fullTableName) {
        ValidTxnWriteIdList validTxnList = AcidUtils.getValidTxnWriteIdList(conf);
        return validTxnList.getTableValidWriteIdList(fullTableName);
    }

    public static void setValidWriteIdList(Configuration conf, ValidWriteIdList validWriteIds) {
        conf.set("hive.txn.valid.writeids", validWriteIds.toString());
        LOG.debug("Setting ValidWriteIdList: " + validWriteIds.toString() + " isAcidTable: " + HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, false) + " acidProperty: " + AcidUtils.getAcidOperationalProperties(conf));
    }

    public static void setValidWriteIdList(Configuration conf, TableScanDesc tsDesc) {
        if (tsDesc.isTranscationalTable()) {
            String tableName;
            String dbName = tsDesc.getDatabaseName();
            ValidWriteIdList validWriteIdList = AcidUtils.getTableValidWriteIdList(conf, AcidUtils.getFullTableName(dbName, tableName = tsDesc.getTableName()));
            if (validWriteIdList != null) {
                AcidUtils.setValidWriteIdList(conf, validWriteIdList);
            } else {
                LOG.error("setValidWriteIdList on table: " + AcidUtils.getFullTableName(dbName, tableName) + " isAcidTable: " + true + " acidProperty: " + AcidUtils.getAcidOperationalProperties(conf) + " couldn't find the ValidWriteId list from ValidTxnWriteIdList: " + conf.get("hive.txn.tables.valid.writeids"));
                throw new IllegalStateException("ACID table: " + AcidUtils.getFullTableName(dbName, tableName) + " is missing from the ValidWriteIdList config: " + conf.get("hive.txn.tables.valid.writeids"));
            }
        }
    }

    public static TableSnapshot getTableSnapshot(Configuration conf, org.apache.hadoop.hive.ql.metadata.Table tbl) throws LockException {
        return AcidUtils.getTableSnapshot(conf, tbl, false);
    }

    public static TableSnapshot getTableSnapshot(Configuration conf, org.apache.hadoop.hive.ql.metadata.Table tbl, boolean isStatsUpdater) throws LockException {
        return AcidUtils.getTableSnapshot(conf, tbl, tbl.getDbName(), tbl.getTableName(), isStatsUpdater);
    }

    public static TableSnapshot getTableSnapshot(Configuration conf, org.apache.hadoop.hive.ql.metadata.Table tbl, String dbName, String tblName, boolean isStatsUpdater) throws LockException, AssertionError {
        if (!AcidUtils.isTransactionalTable(tbl)) {
            return null;
        }
        if (dbName == null) {
            dbName = tbl.getDbName();
        }
        if (tblName == null) {
            tblName = tbl.getTableName();
        }
        long writeId = -1L;
        Object validWriteIdList = null;
        HiveTxnManager sessionTxnMgr = SessionState.get().getTxnMgr();
        String fullTableName = AcidUtils.getFullTableName(dbName, tblName);
        if (sessionTxnMgr != null && sessionTxnMgr.getCurrentTxnId() > 0L) {
            validWriteIdList = AcidUtils.getTableValidWriteIdList(conf, fullTableName);
            if (isStatsUpdater) {
                long l = writeId = SessionState.get().getTxnMgr() != null ? SessionState.get().getTxnMgr().getAllocatedTableWriteId(dbName, tblName) : -1L;
                if (writeId < 1L) {
                    LOG.debug("Stats updater for {}.{} doesn't have a write ID ({})", new Object[]{dbName, tblName, writeId});
                }
            }
            if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_IN_TEST) && conf.get("hive.txn.valid.txns") == null) {
                return null;
            }
            if (validWriteIdList == null) {
                validWriteIdList = AcidUtils.getTableValidWriteIdListWithTxnList(conf, dbName, tblName);
            }
            if (validWriteIdList == null) {
                throw new AssertionError((Object)("Cannot find valid write ID list for " + tblName));
            }
        }
        return new TableSnapshot(writeId, validWriteIdList != null ? validWriteIdList.toString() : null);
    }

    public static ValidWriteIdList getTableValidWriteIdListWithTxnList(Configuration conf, String dbName, String tableName) throws LockException {
        HiveTxnManager sessionTxnMgr = SessionState.get().getTxnMgr();
        if (sessionTxnMgr == null) {
            return null;
        }
        Object validWriteIdList = null;
        ValidTxnWriteIdList validTxnWriteIdList = null;
        String validTxnList = conf.get("hive.txn.valid.txns");
        ArrayList<String> tablesInput = new ArrayList<String>();
        String fullTableName = AcidUtils.getFullTableName(dbName, tableName);
        tablesInput.add(fullTableName);
        validTxnWriteIdList = sessionTxnMgr.getValidWriteIds(tablesInput, validTxnList);
        return validTxnWriteIdList != null ? validTxnWriteIdList.getTableValidWriteIdList(fullTableName) : null;
    }

    public static String getFullTableName(String dbName, String tableName) {
        return TableName.fromString(tableName, null, dbName).getNotEmptyDbTable().toLowerCase();
    }

    public static List<FileStatus> getAcidFilesForStats(org.apache.hadoop.hive.ql.metadata.Table table, Path dir, Configuration jc, FileSystem fs) throws IOException {
        ArrayList<FileStatus> fileList = new ArrayList<FileStatus>();
        ValidWriteIdList idList = AcidUtils.getTableValidWriteIdList(jc, AcidUtils.getFullTableName(table.getDbName(), table.getTableName()));
        if (idList == null) {
            LOG.warn("Cannot get ACID state for " + table.getDbName() + "." + table.getTableName() + " from " + jc.get("hive.txn.tables.valid.writeids"));
            return null;
        }
        Directory acidInfo = AcidUtils.getAcidState(fs, dir, jc, idList, null, false, null, true);
        if (!acidInfo.getCurrentDirectories().isEmpty() && AcidUtils.isFullAcidTable(table)) {
            Utilities.FILE_OP_LOGGER.warn("Computing stats for an ACID table; stats may be inaccurate");
        }
        if (fs == null) {
            fs = dir.getFileSystem(jc);
        }
        for (HadoopShims.HdfsFileStatusWithId hfs : acidInfo.getOriginalFiles()) {
            fileList.add(hfs.getFileStatus());
        }
        for (ParsedDelta delta : acidInfo.getCurrentDirectories()) {
            for (FileStatus f : HiveStatsUtils.getFileStatusRecurse(delta.getPath(), -1, fs)) {
                fileList.add(f);
            }
        }
        if (acidInfo.getBaseDirectory() != null) {
            for (FileStatus f : HiveStatsUtils.getFileStatusRecurse(acidInfo.getBaseDirectory(), -1, fs)) {
                fileList.add(f);
            }
        }
        return fileList;
    }

    public static List<Path> getValidDataPaths(Path dataPath, Configuration conf, String validWriteIdStr) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        if (validWriteIdStr == null || validWriteIdStr.isEmpty()) {
            pathList.add(dataPath);
            return pathList;
        }
        ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(validWriteIdStr);
        Directory acidInfo = AcidUtils.getAcidState(dataPath.getFileSystem(conf), dataPath, conf, validWriteIdList, null, false, null, false);
        for (HadoopShims.HdfsFileStatusWithId hfs : acidInfo.getOriginalFiles()) {
            pathList.add(hfs.getFileStatus().getPath());
        }
        for (ParsedDelta delta : acidInfo.getCurrentDirectories()) {
            pathList.add(delta.getPath());
        }
        if (acidInfo.getBaseDirectory() != null) {
            pathList.add(acidInfo.getBaseDirectory());
        }
        return pathList;
    }

    public static String getAcidSubDir(Path dataPath) {
        String dataDir = dataPath.getName();
        if (dataDir.startsWith(BASE_PREFIX) || dataDir.startsWith(DELTA_PREFIX) || dataDir.startsWith(DELETE_DELTA_PREFIX)) {
            return dataDir;
        }
        return null;
    }

    public static String getFirstLevelAcidDirPath(Path dataPath, FileSystem fileSystem) throws IOException {
        if (dataPath == null) {
            return null;
        }
        String firstLevelAcidDir = AcidUtils.getAcidSubDir(dataPath);
        if (firstLevelAcidDir != null) {
            return firstLevelAcidDir;
        }
        String acidDirPath = AcidUtils.getFirstLevelAcidDirPath(dataPath.getParent(), fileSystem);
        if (acidDirPath == null) {
            return null;
        }
        if (fileSystem.isDirectory(dataPath)) {
            return acidDirPath + "/" + dataPath.getName();
        }
        return acidDirPath;
    }

    public static boolean isAcidEnabled(HiveConf hiveConf) {
        String txnMgr = hiveConf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER);
        boolean concurrency = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        String dbTxnMgr = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";
        return txnMgr.equals(dbTxnMgr) && concurrency;
    }

    public static Long extractWriteId(Path file) {
        String fileName = file.getName();
        if (!fileName.startsWith(DELTA_PREFIX) && !fileName.startsWith(BASE_PREFIX)) {
            LOG.trace("Cannot extract write ID for a MM table: {}", (Object)file);
            return null;
        }
        Object[] parts = fileName.split("_", 4);
        if (parts.length < 2) {
            LOG.debug("Cannot extract write ID for a MM table: " + file + " (" + Arrays.toString(parts) + ")");
            return null;
        }
        long writeId = -1L;
        try {
            writeId = Long.parseLong(parts[1]);
        }
        catch (NumberFormatException ex) {
            LOG.debug("Cannot extract write ID for a MM table: " + file + "; parsing " + (String)parts[1] + " got " + ex.getMessage());
            return null;
        }
        return writeId;
    }

    public static void setNonTransactional(Map<String, String> tblProps) {
        tblProps.put("transactional", "false");
        tblProps.remove("transactional_properties");
    }

    private static boolean needsLock(Entity entity) {
        switch (entity.getType()) {
            case TABLE: {
                return AcidUtils.isLockableTable(entity.getTable());
            }
            case PARTITION: {
                return AcidUtils.isLockableTable(entity.getPartition().getTable());
            }
        }
        return true;
    }

    private static org.apache.hadoop.hive.ql.metadata.Table getTable(WriteEntity we) {
        org.apache.hadoop.hive.ql.metadata.Table t = we.getTable();
        if (t == null) {
            throw new IllegalStateException("No table info for " + we);
        }
        return t;
    }

    private static boolean isLockableTable(org.apache.hadoop.hive.ql.metadata.Table t) {
        if (t.isTemporary()) {
            return false;
        }
        switch (t.getTableType()) {
            case MANAGED_TABLE: 
            case MATERIALIZED_VIEW: {
                return true;
            }
        }
        return false;
    }

    public static List<LockComponent> makeLockComponents(Set<WriteEntity> outputs, Set<ReadEntity> inputs, HiveConf conf) {
        LockComponent comp;
        org.apache.hadoop.hive.ql.metadata.Table t;
        LockComponentBuilder compBuilder;
        ArrayList<LockComponent> lockComponents = new ArrayList<LockComponent>();
        boolean skipReadLock = !conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_READ_LOCKS);
        boolean skipNonAcidReadLock = !conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_NONACID_READ_LOCKS);
        block19: for (ReadEntity input : inputs) {
            if (input.isDummy() || !input.needsLock() || input.isUpdateOrDelete() || !AcidUtils.needsLock(input) || skipReadLock) continue;
            compBuilder = new LockComponentBuilder();
            compBuilder.setShared();
            compBuilder.setOperationType(DataOperationType.SELECT);
            t = null;
            switch (input.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(input.getDatabase().getName());
                    break;
                }
                case TABLE: {
                    t = input.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: 
                case DUMMYPARTITION: {
                    compBuilder.setPartitionName(input.getPartition().getName());
                    t = input.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block19;
                }
            }
            if (skipNonAcidReadLock && !AcidUtils.isTransactionalTable(t)) continue;
            if (t != null) {
                compBuilder.setIsTransactional(AcidUtils.isTransactionalTable(t));
            }
            comp = compBuilder.build();
            LOG.debug("Adding lock component to lock request {} ", (Object)comp);
            lockComponents.add(comp);
        }
        block20: for (WriteEntity output : outputs) {
            LOG.debug("output is null " + (output == null));
            if (output.getType() == Entity.Type.DFS_DIR || output.getType() == Entity.Type.LOCAL_DIR || !AcidUtils.needsLock(output)) continue;
            compBuilder = new LockComponentBuilder();
            t = null;
            switch (output.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(output.getDatabase().getName());
                    break;
                }
                case TABLE: 
                case DUMMYPARTITION: {
                    t = output.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: {
                    compBuilder.setPartitionName(output.getPartition().getName());
                    t = output.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block20;
                }
            }
            switch (output.getWriteType()) {
                case DDL_EXCLUSIVE: {
                    compBuilder.setExclusive();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case INSERT_OVERWRITE: {
                    t = AcidUtils.getTable(output);
                    if (AcidUtils.isTransactionalTable(t)) {
                        if (conf.getBoolVar(HiveConf.ConfVars.TXN_OVERWRITE_X_LOCK)) {
                            compBuilder.setExclusive();
                        } else {
                            compBuilder.setSemiShared();
                        }
                        compBuilder.setOperationType(DataOperationType.UPDATE);
                        break;
                    }
                    compBuilder.setExclusive();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case INSERT: {
                    assert (t != null);
                    if (AcidUtils.isTransactionalTable(t)) {
                        compBuilder.setShared();
                    } else if (MetaStoreUtils.isNonNativeTable(t.getTTable())) {
                        HiveStorageHandler storageHandler = Preconditions.checkNotNull(t.getStorageHandler(), "Thought all the non native tables have an instance of storage handler");
                        LockType lockType = storageHandler.getLockType(output);
                        if (null == LockType.findByValue(lockType.getValue())) {
                            throw new IllegalArgumentException(String.format("Lock type [%s] for Database.Table [%s.%s] is unknown", lockType, t.getDbName(), t.getTableName()));
                        }
                        compBuilder.setLock(lockType);
                    } else if (conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE)) {
                        compBuilder.setExclusive();
                    } else {
                        compBuilder.setShared();
                    }
                    compBuilder.setOperationType(DataOperationType.INSERT);
                    break;
                }
                case DDL_SHARED: {
                    compBuilder.setShared();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case UPDATE: {
                    compBuilder.setSemiShared();
                    compBuilder.setOperationType(DataOperationType.UPDATE);
                    break;
                }
                case DELETE: {
                    compBuilder.setSemiShared();
                    compBuilder.setOperationType(DataOperationType.DELETE);
                    break;
                }
                case DDL_NO_LOCK: {
                    continue block20;
                }
                default: {
                    throw new RuntimeException("Unknown write type " + output.getWriteType().toString());
                }
            }
            if (t != null) {
                compBuilder.setIsTransactional(AcidUtils.isTransactionalTable(t));
            }
            compBuilder.setIsDynamicPartitionWrite(output.isDynamicPartitionWrite());
            comp = compBuilder.build();
            LOG.debug("Adding lock component to lock request " + comp.toString());
            lockComponents.add(comp);
        }
        return lockComponents;
    }

    public static void validateAcidFiles(org.apache.hadoop.hive.ql.metadata.Table table, FileStatus[] srcs, FileSystem fs) throws SemanticException {
        if (!AcidUtils.isFullAcidTable(table)) {
            return;
        }
        AcidUtils.validateAcidFiles(srcs, fs);
    }

    private static void validateAcidFiles(FileStatus[] srcs, FileSystem fs) throws SemanticException {
        try {
            for (FileStatus oneSrc : srcs) {
                if (MetaDataFile.isRawFormatFile(oneSrc.getPath(), fs)) continue;
                throw new SemanticException(ErrorMsg.LOAD_DATA_ACID_FILE, oneSrc.getPath().toString());
            }
        }
        catch (IOException ex) {
            throw new SemanticException(ex);
        }
    }

    public static void validateAcidPartitionLocation(String location, Configuration conf) throws SemanticException {
        try {
            URI uri = new URI(location);
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            FileStatus[] fileStatuses = LoadSemanticAnalyzer.matchFilesOrDir(fs, new Path(uri));
            AcidUtils.validateAcidFiles(fileStatuses, fs);
        }
        catch (IOException | URISyntaxException ex) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ex.getMessage()), ex);
        }
    }

    public static TxnType getTxnType(Configuration conf, ASTNode tree) {
        CalcitePlanner.ASTSearcher astSearcher = new CalcitePlanner.ASTSearcher();
        return HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TXN_READONLY_ENABLED) && tree.getToken().getType() == 1003 && Stream.of({909}, {908, 1086}).noneMatch(pattern -> astSearcher.simpleBreadthFirstSearch(tree, (int)pattern) != null) ? TxnType.READ_ONLY : TxnType.DEFAULT;
    }

    public static List<HadoopShims.HdfsFileStatusWithId> findBaseFiles(Path base, Ref<Boolean> useFileIds, Supplier<FileSystem> fs) throws IOException {
        block5: {
            Boolean val = (Boolean)useFileIds.value;
            if (val == null || val.booleanValue()) {
                try {
                    List<HadoopShims.HdfsFileStatusWithId> result = SHIMS.listLocatedHdfsStatus(fs.get(), base, hiddenFileFilter);
                    if (val == null) {
                        useFileIds.value = true;
                    }
                    return result;
                }
                catch (Throwable t) {
                    LOG.error("Failed to get files with ID; using regular API: " + t.getMessage());
                    if (val != null || !(t instanceof UnsupportedOperationException)) break block5;
                    useFileIds.value = false;
                }
            }
        }
        List<FileStatus> children = HdfsUtils.listLocatedStatus(fs.get(), base, hiddenFileFilter);
        ArrayList<HadoopShims.HdfsFileStatusWithId> result = new ArrayList<HadoopShims.HdfsFileStatusWithId>(children.size());
        for (FileStatus child : children) {
            result.add(AcidUtils.createOriginalObj(null, child));
        }
        return result;
    }

    private static void initDirCache(int durationInMts) {
        if (dirCacheInited.get()) {
            LOG.debug("DirCache got initialized already");
            return;
        }
        dirCache = CacheBuilder.newBuilder().expireAfterWrite(durationInMts, TimeUnit.MINUTES).softValues().build();
        dirCacheInited.set(true);
    }

    public static Directory getAcidStateFromCache(Supplier<FileSystem> fileSystem, Path candidateDirectory, Configuration conf, ValidWriteIdList writeIdList, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles, Map<String, String> tblproperties, boolean generateDirSnapshots) throws IOException {
        boolean recompute;
        int dirCacheDuration = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_TXN_ACID_DIR_CACHE_DURATION);
        if (dirCacheDuration <= 0) {
            LOG.debug("dirCache is not enabled");
            return AcidUtils.getAcidState(fileSystem.get(), candidateDirectory, conf, writeIdList, useFileIds, ignoreEmptyFiles, tblproperties, generateDirSnapshots);
        }
        AcidUtils.initDirCache(dirCacheDuration);
        String key = writeIdList.getTableName() + "_" + candidateDirectory.toString();
        DirInfoValue value = dirCache.getIfPresent(key);
        long[] exceptions = writeIdList.getInvalidWriteIds();
        boolean bl = recompute = exceptions != null && exceptions.length > 0;
        if (recompute) {
            LOG.info("invalidating cache entry for key: {}", (Object)key);
            dirCache.invalidate(key);
            value = null;
        }
        if (value != null && !value.getTxnString().equalsIgnoreCase(writeIdList.writeToString())) {
            if (LOG.isDebugEnabled()) {
                LOG.info("writeIdList: {} from cache: {} is not matching for key: {}", new Object[]{writeIdList.writeToString(), value.getTxnString(), key});
            }
            recompute = true;
        }
        if (recompute || value == null) {
            Directory dirInfo = AcidUtils.getAcidState(fileSystem.get(), candidateDirectory, conf, writeIdList, useFileIds, ignoreEmptyFiles, tblproperties, generateDirSnapshots);
            value = new DirInfoValue(writeIdList.writeToString(), dirInfo);
            if (value.dirInfo != null && value.dirInfo.getBaseDirectory() != null && value.dirInfo.getCurrentDirectories().isEmpty()) {
                AcidUtils.populateBaseFiles(dirInfo, useFileIds, fileSystem);
                dirCache.put(key, value);
            }
        } else {
            LOG.info("Got {} from cache, cache size: {}", (Object)key, (Object)dirCache.size());
        }
        return value.getDirInfo();
    }

    private static void populateBaseFiles(Directory dirInfo, Ref<Boolean> useFileIds, Supplier<FileSystem> fileSystem) throws IOException {
        if (dirInfo.getBaseDirectory() != null) {
            List<HadoopShims.HdfsFileStatusWithId> children = AcidUtils.findBaseFiles(dirInfo.getBaseDirectory(), useFileIds, fileSystem);
            ((DirectoryImpl)dirInfo).setBaseFiles(children);
        }
    }

    static {
        dirCacheInited = new AtomicBoolean();
        originalBucketFilter = new PathFilter(){

            public boolean accept(Path path) {
                return ORIGINAL_PATTERN.matcher(path.getName()).matches() || ORIGINAL_PATTERN_COPY.matcher(path.getName()).matches();
            }
        };
        LOG = LoggerFactory.getLogger(AcidUtils.class);
        ORIGINAL_PATTERN = Pattern.compile("[0-9]+_[0-9]+");
        ORIGINAL_PATTERN_COPY = Pattern.compile("[0-9]+_[0-9]+_copy_[0-9]+");
        hiddenFileFilter = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        acidHiddenFileFilter = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                if (name.startsWith("_metadata_acid")) {
                    return true;
                }
                if (name.startsWith("_orc_acid_version")) {
                    return true;
                }
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        acidTempDirFilter = new PathFilter(){

            public boolean accept(Path dirPath) {
                String dirPathStr = dirPath.toString();
                if (dirPathStr.contains("_tmp_space.db")) {
                    return true;
                }
                return !dirPathStr.contains("/.") && !dirPathStr.contains("/_");
            }
        };
        VISIBILITY_PATTERN = Pattern.compile("_v\\d+");
        SHIMS = ShimLoader.getHadoopShims();
    }

    static class DirInfoValue {
        private String txnString;
        private Directory dirInfo;

        DirInfoValue(String txnString, Directory dirInfo) {
            this.txnString = txnString;
            this.dirInfo = dirInfo;
        }

        String getTxnString() {
            return this.txnString;
        }

        Directory getDirInfo() {
            return this.dirInfo;
        }
    }

    public static class IdPathFilter
    implements PathFilter {
        private String baseDirName;
        private String deltaDirName;
        private final boolean isDeltaPrefix;

        public IdPathFilter(long writeId, int stmtId) {
            String deltaDirName = null;
            deltaDirName = AcidUtils.DELTA_PREFIX + String.format(AcidUtils.DELTA_DIGITS, writeId) + "_" + String.format(AcidUtils.DELTA_DIGITS, writeId);
            boolean bl = this.isDeltaPrefix = stmtId < 0;
            if (!this.isDeltaPrefix) {
                deltaDirName = deltaDirName + "_" + String.format(AcidUtils.STATEMENT_DIGITS, stmtId);
            }
            this.baseDirName = AcidUtils.BASE_PREFIX + String.format(AcidUtils.DELTA_DIGITS, writeId);
            this.deltaDirName = deltaDirName;
        }

        public boolean accept(Path path) {
            String name = path.getName();
            return name.equals(this.baseDirName) || this.isDeltaPrefix && name.startsWith(this.deltaDirName) || !this.isDeltaPrefix && name.equals(this.deltaDirName);
        }
    }

    public static class AnyIdDirFilter
    implements PathFilter {
        public boolean accept(Path path) {
            return AcidUtils.extractWriteId(path) != null;
        }
    }

    public static final class OrcAcidVersion {
        private static final String ACID_VERSION_KEY = "hive.acid.version";
        public static final String ACID_FORMAT = "_orc_acid_version";
        private static final Charset UTF8 = Charset.forName("UTF-8");
        public static final int ORC_ACID_VERSION_DEFAULT = 0;
        public static final int ORC_ACID_VERSION = 2;

        public static void setAcidVersionInDataFile(Writer writer) {
            writer.addUserMetadata(ACID_VERSION_KEY, UTF8.encode(String.valueOf(2)));
        }

        @VisibleForTesting
        public static int getAcidVersionFromDataFile(Path dataFile, FileSystem fs) throws IOException {
            FileStatus fileStatus = fs.getFileStatus(dataFile);
            Reader orcReader = OrcFile.createReader(dataFile, OrcFile.readerOptions(fs.getConf()).filesystem(fs).maxLength(AcidUtils.getLogicalLength(fs, fileStatus)));
            if (orcReader.hasMetadataValue(ACID_VERSION_KEY)) {
                char[] versionChar = UTF8.decode(orcReader.getMetadataValue(ACID_VERSION_KEY)).array();
                String version = new String(versionChar);
                return Integer.valueOf(version);
            }
            return 0;
        }

        public static void writeVersionFile(Path deltaOrBaseDir, FileSystem fs) throws IOException {
            Path formatFile = OrcAcidVersion.getVersionFilePath(deltaOrBaseDir);
            if (!fs.exists(formatFile)) {
                try (FSDataOutputStream strm = fs.create(formatFile, false);){
                    strm.write(UTF8.encode(String.valueOf(2)).array());
                }
                catch (IOException ioe) {
                    LOG.error("Failed to create " + formatFile + " due to: " + ioe.getMessage(), (Throwable)ioe);
                    throw ioe;
                }
            }
        }

        public static Path getVersionFilePath(Path deltaOrBase) {
            return new Path(deltaOrBase, ACID_FORMAT);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @VisibleForTesting
        public static int getAcidVersionFromMetaFile(Path deltaOrBaseDir, FileSystem fs) throws IOException {
            Path formatFile = OrcAcidVersion.getVersionFilePath(deltaOrBaseDir);
            if (!fs.exists(formatFile)) {
                LOG.debug(formatFile + " not found, returning default: " + 0);
                return 0;
            }
            try (FSDataInputStream inputStream = fs.open(formatFile);){
                byte[] bytes = new byte[1];
                int read = inputStream.read(bytes);
                if (read != -1) {
                    String version = new String(bytes, UTF8);
                    int n = Integer.valueOf(version);
                    return n;
                }
                int n = 0;
                return n;
            }
            catch (IOException ex) {
                LOG.error(formatFile + " is unreadable due to: " + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    public static class MetaDataFile {
        public static final String METADATA_FILE = "_metadata_acid";
        private static final String CURRENT_VERSION = "0";

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static boolean isCompacted(Path baseOrDeltaDir, FileSystem fs, HdfsDirSnapshot dirSnapshot) throws IOException {
            Path formatFile = new Path(baseOrDeltaDir, METADATA_FILE);
            if (dirSnapshot != null && !dirSnapshot.contains(formatFile)) {
                return false;
            }
            if (dirSnapshot == null && !fs.exists(formatFile)) {
                return false;
            }
            try (FSDataInputStream strm = fs.open(formatFile);){
                String dataFormat;
                Map metaData = new ObjectMapper().readValue((InputStream)strm, Map.class);
                if (!CURRENT_VERSION.equalsIgnoreCase((String)metaData.get("thisFileVersion"))) {
                    throw new IllegalStateException("Unexpected Meta Data version: " + (String)metaData.get("thisFileVersion"));
                }
                switch (dataFormat = metaData.getOrDefault("dataFormat", "null")) {
                    case "compacted": {
                        boolean bl = true;
                        return bl;
                    }
                }
                throw new IllegalArgumentException("Unexpected value for dataFormat: " + dataFormat);
            }
            catch (IOException e) {
                String msg = "Failed to read " + baseOrDeltaDir + "/" + METADATA_FILE + ": " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                throw e;
            }
        }

        private static Path chooseFile(Path baseOrDeltaDir, FileSystem fs) throws IOException {
            FileStatus[] dataFiles;
            if (!baseOrDeltaDir.getName().startsWith(AcidUtils.BASE_PREFIX) && !baseOrDeltaDir.getName().startsWith(AcidUtils.DELTA_PREFIX)) {
                throw new IllegalArgumentException(baseOrDeltaDir + " is not a base/delta");
            }
            try {
                dataFiles = fs.listStatus(new Path[]{baseOrDeltaDir}, originalBucketFilter);
            }
            catch (FileNotFoundException e) {
                dataFiles = null;
            }
            return dataFiles != null && dataFiles.length > 0 ? dataFiles[0].getPath() : null;
        }

        public static boolean isRawFormat(Path baseOrDeltaDir, FileSystem fs, HdfsDirSnapshot dirSnapshot) throws IOException {
            ParsedDeltaLight pd;
            if (AcidUtils.isDeleteDelta(baseOrDeltaDir)) {
                return false;
            }
            if (AcidUtils.isInsertDelta(baseOrDeltaDir) ? (pd = ParsedDeltaLight.parse(baseOrDeltaDir)).getMinWriteId() != pd.getMaxWriteId() : AcidUtils.isCompactedBase(ParsedBase.parseBase(baseOrDeltaDir), fs, dirSnapshot)) {
                return false;
            }
            Path dataFile = null;
            if (dirSnapshot != null && dirSnapshot.getFiles() != null && dirSnapshot.getFiles().size() > 0) {
                for (FileStatus fileStatus : dirSnapshot.getFiles()) {
                    if (!originalBucketFilter.accept(fileStatus.getPath())) continue;
                    dataFile = fileStatus.getPath();
                }
            } else {
                dataFile = MetaDataFile.chooseFile(baseOrDeltaDir, fs);
            }
            if (dataFile == null) {
                return false;
            }
            return MetaDataFile.isRawFormatFile(dataFile, fs);
        }

        public static boolean isRawFormatFile(Path dataFile, FileSystem fs) throws IOException {
            try {
                Reader reader = OrcFile.createReader(dataFile, OrcFile.readerOptions(fs.getConf()));
                return OrcInputFormat.isOriginal(reader);
            }
            catch (FileFormatException ex) {
                LOG.debug("isRawFormat() called on " + dataFile + " which is not an ORC file: " + ex.getMessage());
                return true;
            }
        }

        private static interface Value {
            public static final String COMPACTED = "compacted";
        }

        private static interface Field {
            public static final String VERSION = "thisFileVersion";
            public static final String DATA_FORMAT = "dataFormat";
        }
    }

    public static class TableSnapshot {
        private long writeId;
        private String validWriteIdList;

        public TableSnapshot() {
        }

        public TableSnapshot(long writeId, String validWriteIdList) {
            this.writeId = writeId;
            this.validWriteIdList = validWriteIdList;
        }

        public String getValidWriteIdList() {
            return this.validWriteIdList;
        }

        public long getWriteId() {
            return this.writeId;
        }

        public void setWriteId(long writeId) {
            this.writeId = writeId;
        }

        public void setValidWriteIdList(String validWriteIdList) {
            this.validWriteIdList = validWriteIdList;
        }

        public String toString() {
            return "[validWriteIdList=" + this.validWriteIdList + ", writeId=" + this.writeId + "]";
        }
    }

    private static class HdfsFileStatusWithoutId
    implements HadoopShims.HdfsFileStatusWithId {
        private final FileStatus fs;

        public HdfsFileStatusWithoutId(FileStatus fs) {
            this.fs = fs;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.fs;
        }

        @Override
        public Long getFileId() {
            return null;
        }
    }

    public static class HdfsDirSnapshotImpl
    implements HdfsDirSnapshot {
        private Path dirPath;
        private FileStatus fStatus;
        private FileStatus metadataFStatus = null;
        private FileStatus orcAcidFormatFStatus = null;
        private List<FileStatus> files = new ArrayList<FileStatus>();
        private Long fileId = null;
        private Boolean isRawFormat = null;
        private Boolean isBase = null;
        private Boolean isValidBase = null;
        private Boolean isCompactedBase = null;

        public HdfsDirSnapshotImpl(Path path, FileStatus fStatus, List<FileStatus> files) {
            this.dirPath = path;
            this.fStatus = fStatus;
            this.files = files;
        }

        public HdfsDirSnapshotImpl(Path path, FileStatus fStatus) {
            this.dirPath = path;
            this.fStatus = fStatus;
        }

        @Override
        public Path getPath() {
            return this.dirPath;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.fStatus;
        }

        @Override
        public void setFileStatus(FileStatus fStatus) {
            this.fStatus = fStatus;
        }

        @Override
        public List<FileStatus> getFiles() {
            return this.files;
        }

        @Override
        public void addFile(FileStatus file) {
            this.files.add(file);
        }

        @Override
        public Long getFileId() {
            return this.fileId;
        }

        @Override
        public Boolean isRawFormat() {
            return this.isRawFormat;
        }

        @Override
        public void setIsRawFormat(boolean isRawFormat) {
            this.isRawFormat = isRawFormat;
        }

        @Override
        public Boolean isBase() {
            return this.isBase;
        }

        @Override
        public Boolean isValidBase() {
            return this.isValidBase;
        }

        @Override
        public Boolean isCompactedBase() {
            return this.isCompactedBase;
        }

        @Override
        public void setIsBase(boolean isBase) {
            this.isBase = isBase;
        }

        @Override
        public void setIsValidBase(boolean isValidBase) {
            this.isValidBase = isValidBase;
        }

        @Override
        public void setIsCompactedBase(boolean isCompactedBase) {
            this.isCompactedBase = isCompactedBase;
        }

        @Override
        public void addOrcAcidFormatFile(FileStatus fStatus) {
            this.orcAcidFormatFStatus = fStatus;
        }

        @Override
        public FileStatus getOrcAcidFormatFile() {
            return this.orcAcidFormatFStatus;
        }

        @Override
        public void addMetadataFile(FileStatus fStatus) {
            this.metadataFStatus = fStatus;
        }

        @Override
        public FileStatus getMetadataFile(FileStatus fStatus) {
            return this.metadataFStatus;
        }

        @Override
        public boolean contains(Path path) {
            for (FileStatus fileStatus : this.getFiles()) {
                if (!fileStatus.getPath().equals((Object)path)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Path: " + this.dirPath);
            sb.append("; ");
            sb.append("Files: { ");
            for (FileStatus fstatus : this.files) {
                sb.append(fstatus);
                sb.append(", ");
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public static interface HdfsDirSnapshot {
        public Path getPath();

        public void addOrcAcidFormatFile(FileStatus var1);

        public FileStatus getOrcAcidFormatFile();

        public void addMetadataFile(FileStatus var1);

        public FileStatus getMetadataFile(FileStatus var1);

        public FileStatus getFileStatus();

        public List<FileStatus> getFiles();

        public void setFileStatus(FileStatus var1);

        public void addFile(FileStatus var1);

        public Long getFileId();

        public Boolean isRawFormat();

        public void setIsRawFormat(boolean var1);

        public Boolean isBase();

        public void setIsBase(boolean var1);

        public Boolean isValidBase();

        public void setIsValidBase(boolean var1);

        public Boolean isCompactedBase();

        public void setIsCompactedBase(boolean var1);

        public boolean contains(Path var1);
    }

    private static class TxnBase {
        private FileStatus status;
        private long writeId = 0L;
        private long oldestBaseWriteId = Long.MAX_VALUE;
        private Path oldestBase = null;
        private HdfsDirSnapshot dirSnapShot;

        private TxnBase() {
        }
    }

    @Immutable
    public static class ParsedDeltaLight
    implements Comparable<ParsedDeltaLight> {
        final long minWriteId;
        final long maxWriteId;
        final Path path;
        final int statementId;
        final boolean isDeleteDelta;
        final long visibilityTxnId;

        public static ParsedDeltaLight parse(Path deltaDir) {
            ParsedDelta pd = AcidUtils.parsedDelta(deltaDir, false);
            return new ParsedDeltaLight(pd.getMinWriteId(), pd.getMaxWriteId(), deltaDir, pd.getStatementId(), pd.isDeleteDelta(), pd.getVisibilityTxnId());
        }

        private ParsedDeltaLight(long min, long max, Path path, int statementId, boolean isDeleteDelta, long visibilityTxnId) {
            this.minWriteId = min;
            this.maxWriteId = max;
            this.path = path;
            this.statementId = statementId;
            this.isDeleteDelta = isDeleteDelta;
            this.visibilityTxnId = visibilityTxnId;
        }

        public long getMinWriteId() {
            return this.minWriteId;
        }

        public long getMaxWriteId() {
            return this.maxWriteId;
        }

        public Path getPath() {
            return this.path;
        }

        public int getStatementId() {
            return this.statementId == -1 ? 0 : this.statementId;
        }

        public boolean isDeleteDelta() {
            return this.isDeleteDelta;
        }

        public long getVisibilityTxnId() {
            return this.visibilityTxnId;
        }

        boolean mayContainSideFile() {
            return !this.isDeleteDelta() && this.getMinWriteId() != this.getMaxWriteId() && this.getVisibilityTxnId() <= 0L;
        }

        @Override
        public int compareTo(ParsedDeltaLight parsedDelta) {
            if (this.minWriteId != parsedDelta.minWriteId) {
                if (this.minWriteId < parsedDelta.minWriteId) {
                    return -1;
                }
                return 1;
            }
            if (this.maxWriteId != parsedDelta.maxWriteId) {
                if (this.maxWriteId < parsedDelta.maxWriteId) {
                    return 1;
                }
                return -1;
            }
            if (this.statementId != parsedDelta.statementId) {
                if (this.statementId < parsedDelta.statementId) {
                    return -1;
                }
                return 1;
            }
            return this.path.compareTo((Object)parsedDelta.path);
        }
    }

    @Immutable
    public static final class ParsedDelta
    extends ParsedDeltaLight {
        private final boolean isRawFormat;

        private ParsedDelta(long min, long max, Path path, boolean isDeleteDelta, boolean isRawFormat, long visibilityTxnId) {
            this(min, max, path, -1, isDeleteDelta, isRawFormat, visibilityTxnId);
        }

        private ParsedDelta(long min, long max, Path path, int statementId, boolean isDeleteDelta, boolean isRawFormat, long visibilityTxnId) {
            super(min, max, path, statementId, isDeleteDelta, visibilityTxnId);
            this.isRawFormat = isRawFormat;
        }

        public boolean isRawFormat() {
            return this.isRawFormat;
        }
    }

    public static final class ParsedBase {
        private final long writeId;
        private final long visibilityTxnId;
        private final Path baseDirPath;

        ParsedBase(long writeId, Path baseDirPath) {
            this(writeId, 0L, baseDirPath);
        }

        ParsedBase(long writeId, long visibilityTxnId, Path baseDirPath) {
            this.writeId = writeId;
            this.visibilityTxnId = visibilityTxnId;
            this.baseDirPath = baseDirPath;
        }

        public long getWriteId() {
            return this.writeId;
        }

        public long getVisibilityTxnId() {
            return this.visibilityTxnId;
        }

        public Path getBaseDirPath() {
            return this.baseDirPath;
        }

        public static ParsedBase parseBase(Path path) {
            String filename = path.getName();
            if (!filename.startsWith(AcidUtils.BASE_PREFIX)) {
                throw new IllegalArgumentException(filename + " does not start with " + AcidUtils.BASE_PREFIX);
            }
            int idxOfv = filename.indexOf(AcidUtils.VISIBILITY_PREFIX);
            if (idxOfv < 0) {
                return new ParsedBase(Long.parseLong(filename.substring(AcidUtils.BASE_PREFIX.length())), path);
            }
            return new ParsedBase(Long.parseLong(filename.substring(AcidUtils.BASE_PREFIX.length(), idxOfv)), Long.parseLong(filename.substring(idxOfv + AcidUtils.VISIBILITY_PREFIX.length())), path);
        }
    }

    public static interface Directory {
        public Path getBaseDirectory();

        public List<HadoopShims.HdfsFileStatusWithId> getBaseFiles();

        public boolean isBaseInRawFormat();

        public List<HadoopShims.HdfsFileStatusWithId> getOriginalFiles();

        public List<ParsedDelta> getCurrentDirectories();

        public List<Path> getObsolete();

        public List<Path> getAbortedDirectories();
    }

    public static class AcidOperationalProperties {
        private int description = 0;
        public static final int SPLIT_UPDATE_BIT = 1;
        public static final String SPLIT_UPDATE_STRING = "split_update";
        public static final int HASH_BASED_MERGE_BIT = 2;
        public static final String HASH_BASED_MERGE_STRING = "hash_merge";
        public static final int INSERT_ONLY_BIT = 4;
        public static final String INSERT_ONLY_STRING = "insert_only";
        public static final String DEFAULT_VALUE_STRING = "default";
        public static final String INSERTONLY_VALUE_STRING = "insert_only";

        private AcidOperationalProperties() {
        }

        public static AcidOperationalProperties getDefault() {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            obj.setSplitUpdate(true);
            obj.setHashBasedMerge(false);
            obj.setInsertOnly(false);
            return obj;
        }

        public static AcidOperationalProperties getInsertOnly() {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            obj.setInsertOnly(true);
            return obj;
        }

        public static AcidOperationalProperties parseString(String propertiesStr) {
            String[] options;
            if (propertiesStr == null) {
                return AcidOperationalProperties.getDefault();
            }
            if (propertiesStr.equalsIgnoreCase(DEFAULT_VALUE_STRING)) {
                return AcidOperationalProperties.getDefault();
            }
            if (propertiesStr.equalsIgnoreCase("insert_only")) {
                return AcidOperationalProperties.getInsertOnly();
            }
            AcidOperationalProperties obj = new AcidOperationalProperties();
            block8: for (String option : options = propertiesStr.split("\\|")) {
                if (option.trim().length() == 0) continue;
                switch (option) {
                    case "split_update": {
                        obj.setSplitUpdate(true);
                        continue block8;
                    }
                    case "hash_merge": {
                        obj.setHashBasedMerge(true);
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value " + option + " for ACID operational properties!");
                    }
                }
            }
            return obj;
        }

        public static AcidOperationalProperties parseInt(int properties) {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            if ((properties & 1) > 0) {
                obj.setSplitUpdate(true);
            }
            if ((properties & 2) > 0) {
                obj.setHashBasedMerge(true);
            }
            if ((properties & 4) > 0) {
                obj.setInsertOnly(true);
            }
            return obj;
        }

        public AcidOperationalProperties setSplitUpdate(boolean isSplitUpdate) {
            this.description = isSplitUpdate ? this.description | 1 : this.description & 0xFFFFFFFE;
            return this;
        }

        public AcidOperationalProperties setHashBasedMerge(boolean isHashBasedMerge) {
            this.description = isHashBasedMerge ? this.description | 2 : this.description & 0xFFFFFFFD;
            return this;
        }

        public AcidOperationalProperties setInsertOnly(boolean isInsertOnly) {
            this.description = isInsertOnly ? this.description | 4 : this.description & 0xFFFFFFFB;
            return this;
        }

        public boolean isSplitUpdate() {
            return (this.description & 1) > 0;
        }

        public boolean isHashBasedMerge() {
            return (this.description & 2) > 0;
        }

        public boolean isInsertOnly() {
            return (this.description & 4) > 0;
        }

        public int toInt() {
            return this.description;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            if (this.isSplitUpdate()) {
                str.append("|split_update");
            }
            if (this.isHashBasedMerge()) {
                str.append("|hash_merge");
            }
            if (this.isInsertOnly()) {
                str.append("|insert_only");
            }
            return str.toString();
        }
    }

    public static class AcidBaseFileInfo {
        private final HadoopShims.HdfsFileStatusWithId fileId;
        private final AcidBaseFileType acidBaseFileType;

        public AcidBaseFileInfo(HadoopShims.HdfsFileStatusWithId fileId, AcidBaseFileType acidBaseFileType) {
            this.fileId = fileId;
            this.acidBaseFileType = acidBaseFileType;
        }

        public boolean isOriginal() {
            return this.acidBaseFileType == AcidBaseFileType.ORIGINAL_BASE;
        }

        public boolean isAcidSchema() {
            return this.acidBaseFileType == AcidBaseFileType.ACID_SCHEMA;
        }

        public HadoopShims.HdfsFileStatusWithId getHdfsFileStatusWithId() {
            return this.fileId;
        }
    }

    public static enum AcidBaseFileType {
        ORIGINAL_BASE,
        ACID_SCHEMA;

    }

    public static enum Operation implements Serializable
    {
        NOT_ACID,
        INSERT,
        UPDATE,
        DELETE;

    }

    public static final class DirectoryImpl
    implements Directory {
        private final List<Path> abortedDirectories;
        private final boolean isBaseInRawFormat;
        private final List<HadoopShims.HdfsFileStatusWithId> original;
        private final List<Path> obsolete;
        private final List<ParsedDelta> deltas;
        private final Path base;
        private List<HadoopShims.HdfsFileStatusWithId> baseFiles;

        public DirectoryImpl(List<Path> abortedDirectories, boolean isBaseInRawFormat, List<HadoopShims.HdfsFileStatusWithId> original, List<Path> obsolete, List<ParsedDelta> deltas, Path base) {
            this.abortedDirectories = abortedDirectories == null ? Collections.emptyList() : abortedDirectories;
            this.isBaseInRawFormat = isBaseInRawFormat;
            this.original = original == null ? Collections.emptyList() : original;
            this.obsolete = obsolete == null ? Collections.emptyList() : obsolete;
            this.deltas = deltas == null ? Collections.emptyList() : deltas;
            this.base = base;
        }

        @Override
        public Path getBaseDirectory() {
            return this.base;
        }

        @Override
        public List<HadoopShims.HdfsFileStatusWithId> getBaseFiles() {
            return this.baseFiles;
        }

        void setBaseFiles(List<HadoopShims.HdfsFileStatusWithId> baseFiles) {
            this.baseFiles = baseFiles;
        }

        @Override
        public boolean isBaseInRawFormat() {
            return this.isBaseInRawFormat;
        }

        @Override
        public List<HadoopShims.HdfsFileStatusWithId> getOriginalFiles() {
            return this.original;
        }

        @Override
        public List<ParsedDelta> getCurrentDirectories() {
            return this.deltas;
        }

        @Override
        public List<Path> getObsolete() {
            return this.obsolete;
        }

        @Override
        public List<Path> getAbortedDirectories() {
            return this.abortedDirectories;
        }

        public String toString() {
            return "Aborted Directories: " + this.abortedDirectories + "; isBaseInRawFormat: " + this.isBaseInRawFormat + "; original: " + this.original + "; obsolete: " + this.obsolete + "; deltas: " + this.deltas + "; base: " + this.base;
        }
    }

    public static final class BucketMetaData {
        private static final BucketMetaData INVALID = new BucketMetaData(-1, 0);
        public final int bucketId;
        public final int copyNumber;

        public static BucketMetaData parse(String bucketFileName) {
            Matcher matcher;
            if (ORIGINAL_PATTERN.matcher(bucketFileName).matches()) {
                int bucketId = Integer.parseInt(bucketFileName.substring(0, bucketFileName.indexOf(95)));
                return new BucketMetaData(bucketId, 0);
            }
            if (ORIGINAL_PATTERN_COPY.matcher(bucketFileName).matches()) {
                int copyNumber = Integer.parseInt(bucketFileName.substring(bucketFileName.lastIndexOf(95) + 1));
                int bucketId = Integer.parseInt(bucketFileName.substring(0, bucketFileName.indexOf(95)));
                return new BucketMetaData(bucketId, copyNumber);
            }
            if (bucketFileName.startsWith(AcidUtils.BUCKET_PREFIX) && (matcher = BUCKET_PATTERN.matcher(bucketFileName)).matches()) {
                String bucketId = matcher.group(1);
                bucketFileName = bucketFileName.substring(0, matcher.end(1));
                if (Utilities.FILE_OP_LOGGER.isDebugEnabled()) {
                    Utilities.FILE_OP_LOGGER.debug("Parsing bucket ID = " + bucketId + " from file name '" + bucketFileName + "'");
                }
                return new BucketMetaData(Integer.parseInt(bucketId), 0);
            }
            return INVALID;
        }

        public static BucketMetaData parse(Path bucketFile) {
            return BucketMetaData.parse(bucketFile.getName());
        }

        private BucketMetaData(int bucketId, int copyNumber) {
            this.bucketId = bucketId;
            this.copyNumber = copyNumber;
        }
    }
}

