/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedStringCommon;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class VectorMapJoinOptimizedStringHashMap
extends VectorMapJoinOptimizedHashMap
implements VectorMapJoinBytesHashMap {
    private VectorMapJoinOptimizedStringCommon stringCommon;

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        return new NonMatchedStringHashMapIterator(matchTracker, this);
    }

    @Override
    public JoinUtil.JoinResult lookup(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMapResult hashMapResult) throws IOException {
        VectorMapJoinOptimizedHashTable.SerializedBytes serializedBytes = this.stringCommon.serialize(keyBytes, keyStart, keyLength);
        return super.lookup(serializedBytes.bytes, serializedBytes.offset, serializedBytes.length, hashMapResult);
    }

    @Override
    public JoinUtil.JoinResult lookup(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMapResult hashMapResult, MatchTracker matchTracker) throws IOException {
        VectorMapJoinOptimizedHashTable.SerializedBytes serializedBytes = this.stringCommon.serialize(keyBytes, keyStart, keyLength);
        return super.lookup(serializedBytes.bytes, serializedBytes.offset, serializedBytes.length, hashMapResult, matchTracker);
    }

    public VectorMapJoinOptimizedStringHashMap(boolean isOuterJoin, MapJoinTableContainer originalTableContainer, MapJoinTableContainer.ReusableGetAdaptor hashMapRowGetter) {
        super(originalTableContainer, hashMapRowGetter);
        this.stringCommon = new VectorMapJoinOptimizedStringCommon(isOuterJoin);
    }

    private static class NonMatchedStringHashMapIterator
    extends VectorMapJoinOptimizedHashMap.NonMatchedBytesHashMapIterator {
        private BinarySortableDeserializeRead keyBinarySortableDeserializeRead;

        NonMatchedStringHashMapIterator(MatchTracker matchTracker, VectorMapJoinOptimizedStringHashMap hashMap) {
            super(matchTracker, hashMap);
        }

        @Override
        public void init() {
            super.init();
            TypeInfo[] typeInfos = new TypeInfo[]{TypeInfoFactory.stringTypeInfo};
            this.keyBinarySortableDeserializeRead = new BinarySortableDeserializeRead(typeInfos, false);
        }

        @Override
        public boolean readNonMatchedBytesKey() throws HiveException {
            super.doReadNonMatchedBytesKey();
            byte[] bytes = this.keyRef.getBytes();
            int keyOffset = (int)this.keyRef.getOffset();
            int keyLength = this.keyRef.getLength();
            try {
                this.keyBinarySortableDeserializeRead.set(bytes, keyOffset, keyLength);
                return this.keyBinarySortableDeserializeRead.readNextField();
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }

        @Override
        public byte[] getNonMatchedBytes() {
            return this.keyBinarySortableDeserializeRead.currentBytes;
        }

        @Override
        public int getNonMatchedBytesOffset() {
            return this.keyBinarySortableDeserializeRead.currentBytesStart;
        }

        @Override
        public int getNonMatchedBytesLength() {
            return this.keyBinarySortableDeserializeRead.currentBytesLength;
        }
    }
}

