/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashKeyRef;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMultiSetStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastBytesHashMultiSet
extends VectorMapJoinFastBytesHashTable
implements VectorMapJoinBytesHashMultiSet {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastBytesHashMultiSet.class);
    private VectorMapJoinFastBytesHashMultiSetStore hashMultiSetStore;

    @Override
    public VectorMapJoinHashMultiSetResult createHashMultiSetResult() {
        return new VectorMapJoinFastBytesHashMultiSetStore.HashMultiSetResult();
    }

    @Override
    public void add(byte[] keyBytes, int keyStart, int keyLength, BytesWritable currentValue) {
        boolean isNewKey;
        long refWord;
        if (this.checkResize()) {
            this.expandAndRehash();
        }
        long hashCode = HashCodeUtil.murmurHash(keyBytes, keyStart, keyLength);
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        long partialHashCode = VectorMapJoinFastBytesHashKeyRef.extractPartialHashCode(hashCode);
        while (true) {
            if ((refWord = this.slots[slot]) == 0L) {
                isNewKey = true;
                break;
            }
            if (VectorMapJoinFastBytesHashKeyRef.getPartialHashCodeFromRefWord(refWord) == partialHashCode && VectorMapJoinFastBytesHashKeyRef.equalKey(refWord, keyBytes, keyStart, keyLength, this.writeBuffers, this.unsafeReadPos)) {
                isNewKey = false;
                break;
            }
            ++this.metricPutConflict;
            slot = (int)((probeSlot += (long)(++i)) & (long)this.logicalHashBucketMask);
        }
        if (this.largestNumberOfSteps < i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probed " + i + " slots (the longest so far) to find space");
            }
            this.largestNumberOfSteps = i;
        }
        if (isNewKey) {
            this.slots[slot] = this.hashMultiSetStore.addFirst(partialHashCode, keyBytes, keyStart, keyLength);
            ++this.keysAssigned;
        } else {
            long newRefWord = this.hashMultiSetStore.bumpCount(refWord, this.unsafeReadPos);
            if (newRefWord != refWord) {
                this.slots[slot] = newRefWord;
            }
        }
    }

    @Override
    public JoinUtil.JoinResult contains(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMultiSetResult hashMultiSetResult) {
        VectorMapJoinFastBytesHashMultiSetStore.HashMultiSetResult fastHashMultiSetResult = (VectorMapJoinFastBytesHashMultiSetStore.HashMultiSetResult)hashMultiSetResult;
        fastHashMultiSetResult.forget();
        long hashCode = HashCodeUtil.murmurHash(keyBytes, keyStart, keyLength);
        this.doHashMultiSetContains(keyBytes, keyStart, keyLength, hashCode, fastHashMultiSetResult);
        return fastHashMultiSetResult.joinResult();
    }

    protected final void doHashMultiSetContains(byte[] keyBytes, int keyStart, int keyLength, long hashCode, VectorMapJoinFastBytesHashMultiSetStore.HashMultiSetResult fastHashMultiSetResult) {
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        long partialHashCode = VectorMapJoinFastBytesHashKeyRef.extractPartialHashCode(hashCode);
        long refWord;
        while ((refWord = this.slots[slot]) != 0L) {
            if (VectorMapJoinFastBytesHashKeyRef.getPartialHashCodeFromRefWord(refWord) == partialHashCode) {
                fastHashMultiSetResult.setKey(this.hashMultiSetStore, refWord);
                if (fastHashMultiSetResult.equalKey(keyBytes, keyStart, keyLength)) {
                    fastHashMultiSetResult.setContains();
                    return;
                }
            }
            probeSlot += (long)(++i);
            if (i > this.largestNumberOfSteps) {
                return;
            }
            slot = (int)(probeSlot & (long)this.logicalHashBucketMask);
        }
        return;
    }

    public VectorMapJoinFastBytesHashMultiSet(boolean isFullOuter, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount) {
        super(isFullOuter, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
        this.hashMultiSetStore = new VectorMapJoinFastBytesHashMultiSetStore(writeBuffersSize);
        this.writeBuffers = this.hashMultiSetStore.getWriteBuffers();
    }

    @Override
    public long getEstimatedMemorySize() {
        long size = super.getEstimatedMemorySize();
        return size += this.hashMultiSetStore.getEstimatedMemorySize();
    }
}

