/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMultiSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinInnerBigOnlyLongOperator
extends VectorMapJoinInnerBigOnlyGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinInnerBigOnlyLongOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private transient VectorMapJoinLongHashMultiSet hashMultiSet;
    private transient boolean useMinMax;
    private transient long min;
    private transient long max;
    private transient int singleJoinColumn;

    @Override
    protected String getLoggingPrefix() {
        return super.getLoggingPrefix(CLASS_NAME);
    }

    protected VectorMapJoinInnerBigOnlyLongOperator() {
    }

    public VectorMapJoinInnerBigOnlyLongOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinInnerBigOnlyLongOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    protected void commonSetup() throws HiveException {
        super.commonSetup();
        this.singleJoinColumn = this.bigTableKeyColumnMap[0];
    }

    @Override
    public void hashTableSetup() throws HiveException {
        super.hashTableSetup();
        this.hashMultiSet = (VectorMapJoinLongHashMultiSet)this.vectorMapJoinHashTable;
        this.useMinMax = this.hashMultiSet.useMinMax();
        if (this.useMinMax) {
            this.min = this.hashMultiSet.min();
            this.max = this.hashMultiSet.max();
        }
    }

    @Override
    public void processBatch(VectorizedRowBatch batch) throws HiveException {
        try {
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            LongColumnVector joinColVector = (LongColumnVector)batch.cols[this.singleJoinColumn];
            long[] vector = joinColVector.vector;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (!joinColVector.noNulls && joinColVector.isNull[0]) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    long key = vector[0];
                    joinResult = this.useMinMax && (key < this.min || key > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMultiSet.contains(key, this.hashMultiSetResults[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishInnerBigOnlyRepeated(batch, joinResult, this.hashMultiSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMultiSetResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                long saveKey = 0L;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    boolean isNull;
                    long currentKey;
                    int batchIndex;
                    int n = batchIndex = selectedInUse ? selected[logical] : logical;
                    if (!joinColVector.noNulls && joinColVector.isNull[batchIndex]) {
                        currentKey = 0L;
                        isNull = true;
                    } else {
                        currentKey = vector[batchIndex];
                        isNull = false;
                    }
                    if (isNull || !haveSaveKey || currentKey != saveKey) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMultiSetResultCount;
                                    break;
                                }
                            }
                        }
                        if (isNull) {
                            saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                            haveSaveKey = false;
                        } else {
                            haveSaveKey = true;
                            saveKey = currentKey;
                            saveJoinResult = this.useMinMax && (currentKey < this.min || currentKey > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMultiSet.contains(currentKey, this.hashMultiSetResults[hashMultiSetResultCount]);
                        }
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesValueCounts[equalKeySeriesCount] = this.hashMultiSetResults[hashMultiSetResultCount].count();
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMultiSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n2 = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n2] = this.equalKeySeriesDuplicateCounts[n2] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMultiSetResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMultiSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " allMatchs " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesValueCounts " + VectorMapJoinInnerBigOnlyLongOperator.longArrayToRangesString(this.equalKeySeriesValueCounts, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesDuplicateCounts " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.equalKeySeriesDuplicateCounts, equalKeySeriesCount) + " spills " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMultiSetResults, 0, hashMultiSetResultCount)));
                }
                this.finishInnerBigOnly(batch, allMatchCount, equalKeySeriesCount, spillCount, this.hashMultiSetResults, hashMultiSetResultCount);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

