/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

@Description(name="variance, var_pop, var_samp, std, stddev, stddev_pop, stddev_samp", value="_FUNC_(x) - Returns one of the variance family of a set of numbers (vectorized, double)")
public class VectorUDAFVarDoubleComplete
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private transient GenericUDAFVariance.VarianceKind varianceKind = GenericUDAFVariance.VarianceKind.NONE;

    public VectorUDAFVarDoubleComplete() {
    }

    public VectorUDAFVarDoubleComplete(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        Preconditions.checkState(this.mode == GenericUDAFEvaluator.Mode.COMPLETE);
        this.init();
    }

    private void init() {
        String aggregateName = this.vecAggrDesc.getAggregationName();
        this.varianceKind = GenericUDAFVariance.VarianceKind.nameMap.get(aggregateName);
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DoubleColumnVector inputVector = (DoubleColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        double[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                this.iterateRepeatingNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize);
            }
        } else if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateRepeatingNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, double value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            if (myagg.isNull) {
                myagg.init();
            }
            myagg.varianceValue(value);
        }
    }

    private void iterateSelectionHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, double[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, j);
            int i = selected[j];
            if (isNull[i]) continue;
            double value = vector[i];
            if (myagg.isNull) {
                myagg.init();
            }
            myagg.varianceValue(value);
        }
    }

    private void iterateSelectionNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, double[] vector, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            double value = vector[selected[i]];
            if (myagg.isNull) {
                myagg.init();
            }
            myagg.varianceValue(value);
        }
    }

    private void iterateNoSelectionHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, double[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            double value = vector[i];
            if (myagg.isNull) {
                myagg.init();
            }
            myagg.varianceValue(value);
        }
    }

    private void iterateNoSelectionNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, double[] vector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            if (myagg.isNull) {
                myagg.init();
            }
            myagg.varianceValue(vector[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DoubleColumnVector inputVector = (DoubleColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        double[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                this.iterateRepeatingNoNulls(myagg, vector[0], batchSize);
            }
        } else if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateRepeatingNoNulls(Aggregation myagg, double value, int batchSize) {
        if (myagg.isNull) {
            myagg.init();
        }
        myagg.varianceValue(value);
        for (int i = 1; i < batchSize; ++i) {
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, double[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            double value = vector[i];
            if (myagg.isNull) {
                myagg.init();
            }
            myagg.varianceValue(value);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, double[] vector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.init();
        }
        double value = vector[selected[0]];
        myagg.varianceValue(value);
        for (int i = 1; i < batchSize; ++i) {
            value = vector[selected[i]];
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, double[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            double value = vector[i];
            if (myagg.isNull) {
                myagg.init();
            }
            myagg.varianceValue(value);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, double[] vector, int batchSize) {
        if (myagg.isNull) {
            myagg.init();
        }
        double value = vector[0];
        myagg.varianceValue(value);
        for (int i = 1; i < batchSize; ++i) {
            value = vector[i];
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object() + model.primitive2() * 3 + model.primitive1(), model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return GenericUDAFVariance.isVarianceFamilyName(name) && inputColVectorType == ColumnVector.Type.DOUBLE && outputColVectorType == ColumnVector.Type.DOUBLE && mode == GenericUDAFEvaluator.Mode.COMPLETE;
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (GenericUDAFVariance.isVarianceNull(myagg.count, this.varianceKind)) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        outputColVector.isNull[batchIndex] = false;
        double result = myagg.count > 1L ? GenericUDAFVariance.calculateVarianceFamilyResult(myagg.variance, myagg.count, this.varianceKind) : 0.0;
        outputColVector.vector[batchIndex] = result;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient double sum;
        private transient long count;
        private transient double variance;
        private transient boolean isNull = true;

        private Aggregation() {
        }

        public void init() {
            this.isNull = false;
            this.sum = 0.0;
            this.count = 0L;
            this.variance = 0.0;
        }

        public void varianceValue(double value) {
            if (this.isNull) {
                this.sum = value;
                this.count = 1L;
                this.variance = 0.0;
                this.isNull = false;
            } else {
                this.sum += value;
                ++this.count;
                if (this.count > 1L) {
                    this.variance = GenericUDAFVariance.calculateIntermediate(this.count, this.sum, value, this.variance);
                }
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum = 0.0;
            this.count = 0L;
            this.variance = 0.0;
        }
    }
}

