/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class VectorUDFMapIndexBaseScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int mapColumnNum;

    public VectorUDFMapIndexBaseScalar() {
    }

    public VectorUDFMapIndexBaseScalar(int mapColumnNum, int outputColumnNum) {
        super(outputColumnNum);
        this.mapColumnNum = mapColumnNum;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        MapColumnVector mapV = (MapColumnVector)batch.cols[this.mapColumnNum];
        ColumnVector valuesV = mapV.values;
        int[] sel = batch.selected;
        boolean[] mapIsNull = mapV.isNull;
        boolean[] outputIsNull = outV.isNull;
        outV.isRepeating = false;
        if (mapV.isRepeating) {
            if (mapV.noNulls || !mapIsNull[0]) {
                int repeatedMapIndex = this.findScalarInMap(mapV, 0);
                if (repeatedMapIndex == -1) {
                    outV.isNull[0] = true;
                    outV.noNulls = false;
                } else {
                    outV.isNull[0] = false;
                    outV.setElement(0, repeatedMapIndex, valuesV);
                }
            } else {
                outV.isNull[0] = true;
                outV.noNulls = false;
            }
            outV.isRepeating = true;
            return;
        }
        if (mapV.noNulls) {
            if (batch.selectedInUse) {
                if (!outV.noNulls) {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        int mapIndex = this.findScalarInMap(mapV, i);
                        if (mapIndex == -1) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.isNull[i] = false;
                        outV.setElement(i, mapIndex, valuesV);
                    }
                } else {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        int mapIndex = this.findScalarInMap(mapV, i);
                        if (mapIndex == -1) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.setElement(i, mapIndex, valuesV);
                    }
                }
            } else {
                if (!outV.noNulls) {
                    Arrays.fill(outV.isNull, false);
                    outV.noNulls = true;
                }
                for (int i = 0; i < n; ++i) {
                    long longListLength = mapV.lengths[i];
                    int mapIndex = this.findScalarInMap(mapV, i);
                    if (mapIndex == -1) {
                        outV.isNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    outV.setElement(i, mapIndex, valuesV);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!mapIsNull[i]) {
                    int mapIndex = this.findScalarInMap(mapV, i);
                    if (mapIndex == -1) {
                        outV.isNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    outV.isNull[i] = false;
                    outV.setElement(i, mapIndex, valuesV);
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!mapIsNull[i]) {
                    int mapIndex = this.findScalarInMap(mapV, i);
                    if (mapIndex == -1) {
                        outV.isNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    outV.isNull[i] = false;
                    outV.setElement(i, mapIndex, valuesV);
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    public int findScalarInMap(MapColumnVector mapColumnVector, int mapBatchIndex) {
        throw new RuntimeException("Not implemented");
    }

    public int getMapColumnNum() {
        return this.mapColumnNum;
    }
}

