/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncDateToDate;

public class VectorUDFDatetimeLegacyHybridCalendarDate
extends FuncDateToDate {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter.setLenient(false);
        return formatter;
    });

    public VectorUDFDatetimeLegacyHybridCalendarDate() {
    }

    public VectorUDFDatetimeLegacyHybridCalendarDate(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    @Override
    protected void func(LongColumnVector outputColVector, LongColumnVector inputColVector, int i) {
        Date inputDate = Date.ofEpochDay((int)inputColVector.vector[i]);
        java.sql.Date oldDate = new java.sql.Date(inputDate.toEpochMilli());
        Date adjustedDate = Date.valueOf(SIMPLE_DATE_FORMAT_THREAD_LOCAL.get().format(oldDate));
        outputColVector.vector[i] = adjustedDate.toEpochDay();
    }
}

