/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncLongToLong;

public class GroupingColumn
extends MathFuncLongToLong {
    private static final long serialVersionUID = 1L;
    private final long mask;

    public GroupingColumn(int inputColumnNum, int index, int outputColumnNum) {
        super(inputColumnNum, outputColumnNum);
        this.mask = 1L << index;
    }

    public GroupingColumn() {
        this.mask = 0L;
    }

    @Override
    protected long func(long v) {
        return (v & this.mask) == 0L ? 0L : 1L;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", mask " + this.mask;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }
}

