/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.ExternalSessionsRegistry;
import org.apache.hadoop.hive.ql.exec.tez.TezSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezExternalSessionState
extends TezSessionState {
    private static final Logger LOG = LoggerFactory.getLogger((String)TezExternalSessionState.class.getName());
    private String externalAppId;
    private boolean isDestroying = false;
    private final ExternalSessionsRegistry registry;

    public TezExternalSessionState(DagUtils utils, HiveConf conf, ExternalSessionsRegistry registry) {
        super(utils, conf);
        this.registry = registry;
    }

    public TezExternalSessionState(String sessionId, HiveConf conf, ExternalSessionsRegistry registry) {
        super(sessionId, conf);
        this.registry = registry;
    }

    @Override
    public void ensureLocalResources(Configuration conf, String[] newFilesNotFromConf) throws IOException, LoginException, URISyntaxException, TezException {
    }

    @Override
    protected void openInternal(String[] additionalFilesNotFromConf, boolean isAsync, SessionState.LogHelper console, TezSession.HiveResources resources, boolean isPoolInit) throws IOException, LoginException, URISyntaxException, TezException {
        this.initQueueAndUser();
        boolean llapMode = this.isLlapMode();
        HashMap amEnv = new HashMap();
        MRHelpers.updateEnvBasedOnMRAMEnv((Configuration)this.conf, amEnv);
        TezConfiguration tezConfig = this.createTezConfig();
        ServicePluginsDescriptor spd = TezExternalSessionState.createServicePluginDescriptor(llapMode, tezConfig);
        Credentials llapCredentials = this.createLlapCredentials(llapMode, tezConfig);
        TezClient session = TezClient.newBuilder((String)("HIVE-" + this.getSessionId()), (TezConfiguration)tezConfig).setIsSession(true).setCredentials(llapCredentials).setServicePluginDescriptor(spd).build();
        LOG.info("Opening new External Tez Session (id: " + this.getSessionId() + ")");
        TezJobMonitor.initShutdownHook();
        if (isAsync) {
            LOG.info("Ignoring the async argument for an external session {}", (Object)this.getSessionId());
        }
        boolean perQuerySession = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_PER_QUERY_TEZ_EXTERNAL_SESSION);
        String hiveQueryId = this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID);
        try {
            if (perQuerySession) {
                LOG.info("Requesting tez session corresponding to queryId: {}", (Object)hiveQueryId);
                this.externalAppId = this.registry.getSession(hiveQueryId);
            } else {
                this.externalAppId = this.registry.getSession();
            }
        }
        catch (IOException | LoginException | TezException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        session.getClient(ApplicationId.fromString((String)this.externalAppId));
        LOG.info("Started an external session; client name {}, app ID {}, perQuerySession: {} hiveQueryId: {}", new Object[]{session.getClientName(), this.externalAppId, perQuerySession, hiveQueryId});
        this.setTezClient(session);
        this.tryKillRunningDAGs(session);
    }

    @Override
    public void close(boolean keepDagFilesDir) throws Exception {
        if (this.externalAppId != null) {
            LOG.info("Returning external session with appID: {}", (Object)this.externalAppId);
            SessionState sessionState = SessionState.get();
            if (sessionState != null) {
                sessionState.setTezSession(null);
            }
            this.registry.returnSession(this.externalAppId);
        }
        this.externalAppId = null;
        if (this.isDestroying) {
            super.close(keepDagFilesDir);
        }
    }

    @Override
    public TezSession reopen() throws Exception {
        this.isDestroying = true;
        LOG.info("Reopening external session with appId: {}", (Object)this.externalAppId);
        return super.reopen();
    }

    @Override
    public void destroy() throws Exception {
        LOG.info("Destroying external session with appId: {}", (Object)this.externalAppId);
        this.isDestroying = true;
        super.destroy();
    }

    @Override
    public boolean killQuery(String reason) throws HiveException {
        if (this.killQuery == null || this.wmContext == null) {
            return false;
        }
        String queryId = this.wmContext.getQueryId();
        if (queryId == null) {
            return false;
        }
        LOG.info("Killing the query {}: {}", (Object)queryId, (Object)reason);
        this.killQuery.killQuery(queryId, reason, this.conf, false);
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + ", externalAppId=" + this.externalAppId;
    }

    private void tryKillRunningDAGs(TezClient session) throws IOException, TezException {
        TezAppMasterStatus amStatus = session.getAppMasterStatus();
        if (amStatus == TezAppMasterStatus.RUNNING) {
            List dagClients;
            LOG.info("External session has an AM which appears to be already running a DAG: client name {}, app ID {}", (Object)session.getClientName(), (Object)this.externalAppId);
            try {
                dagClients = session.getCurrentDAGClients();
            }
            catch (Exception err) {
                throw new IOException("Error getting DAGClients for app ID " + this.externalAppId, err);
            }
            for (DAGClient dagClient : dagClients) {
                LOG.info("External session: attempting to kill dagId {} on app ID {}", (Object)dagClient.getDagIdentifierString(), (Object)this.externalAppId);
                try {
                    dagClient.tryKillDAG();
                }
                catch (Exception err) {
                    throw new TezException("Error while trying to kill existing DAG " + dagClient.getDagIdentifierString() + " running on app ID " + this.externalAppId, (Throwable)err);
                }
                finally {
                    dagClient.close();
                }
            }
        }
    }
}

