/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.dag.api.TezConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezConfigurationFactory {
    private static TezConfiguration defaultConf = new TezConfiguration();
    private static final Logger LOG = LoggerFactory.getLogger((String)TezConfigurationFactory.class.getName());

    public static Configuration copyInto(Configuration target, Configuration src, Predicate<String> sourceFilter) {
        for (Map.Entry entry : src) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] sources = src.getPropertySources(name);
            String source = sources == null || sources.length == 0 ? null : sources[sources.length - 1];
            if (sourceFilter != null && !sourceFilter.test(source)) continue;
            target.set(name, value);
        }
        return target;
    }

    public static JobConf wrapWithJobConf(Configuration conf, Predicate<String> sourceFilter) {
        JobConf jc = new JobConf(false);
        TezConfigurationFactory.copyInto((Configuration)jc, (Configuration)defaultConf, sourceFilter);
        TezConfigurationFactory.copyInto((Configuration)jc, conf, sourceFilter);
        return jc;
    }

    static {
        String sslConf = defaultConf.get("hadoop.ssl.client.conf", "ssl-client.xml");
        defaultConf.addResource(sslConf);
        LOG.info("SSL conf : " + sslConf);
    }
}

