/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ExternalSessionsRegistry {
    public static final Logger LOG = LoggerFactory.getLogger(ExternalSessionsRegistry.class);
    public static final Map<String, ExternalSessionsRegistry> INSTANCES = new HashMap<String, ExternalSessionsRegistry>();

    public String getSession() throws Exception;

    public String getSession(String var1) throws Exception;

    public void returnSession(String var1);

    public void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalSessionsRegistry getClient(Configuration conf) throws MetaException {
        ExternalSessionsRegistry registry;
        Map<String, ExternalSessionsRegistry> map = INSTANCES;
        synchronized (map) {
            String namespace = conf.get("tez.am.registry.namespace");
            conf.setBoolean("tez.am.registry.enable.compute.groups", false);
            registry = INSTANCES.get(namespace);
            String clazz = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_TEZ_EXTERNAL_SESSIONS_REGISTRY_CLASS);
            if (registry == null) {
                registry = JavaUtils.newInstance(JavaUtils.getClass(clazz, ExternalSessionsRegistry.class), new Class[]{Configuration.class}, new Object[]{conf});
                INSTANCES.put(namespace, registry);
            }
            LOG.info("Returning tez external AM registry ({}) for namespace '{}'", (Object)System.identityHashCode(registry), (Object)namespace);
        }
        return registry;
    }
}

