/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolSession;

public abstract class AbstractTriggerValidator {
    private ScheduledExecutorService scheduledExecutorService = null;

    abstract Runnable getTriggerValidatorRunnable();

    void startTriggerValidator(long triggerValidationIntervalMs) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TriggerValidator").build());
            Runnable triggerValidatorRunnable = this.getTriggerValidatorRunnable();
            this.scheduledExecutorService.scheduleWithFixedDelay(triggerValidatorRunnable, triggerValidationIntervalMs, triggerValidationIntervalMs, TimeUnit.MILLISECONDS);
            TezSessionPoolSession.LOG.info("Started trigger validator with interval: {} ms", (Object)triggerValidationIntervalMs);
        }
    }

    void stopTriggerValidator() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
            TezSessionPoolSession.LOG.info("Stopped trigger validator");
        }
    }
}

