/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableSetPropertiesDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.UpdatedMetaDataTracker;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;
import org.apache.hadoop.hive.ql.util.HiveStrictManagedMigration;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.thrift.TException;

public class ReplUtils {
    public static final String LAST_REPL_ID_KEY = "hive.repl.last.repl.id";
    public static final String REPL_CHECKPOINT_KEY = "hive.repl.ckpt.key";
    public static final String REPL_FIRST_INC_PENDING_FLAG = "hive.repl.first.inc.pending";
    public static final String REPL_CURRENT_TBL_WRITE_ID = "hive.repl.current.table.write.id";
    public static final String REPL_CLEAN_TABLES_FROM_BOOTSTRAP_CONFIG = "hive.repl.clean.tables.from.bootstrap";
    public static final String FUNCTIONS_ROOT_DIR_NAME = "_functions";
    public static final String CONSTRAINTS_ROOT_DIR_NAME = "_constraints";
    public static final String INC_BOOTSTRAP_ROOT_DIR_NAME = "_bootstrap";
    public static final String REPL_TABLE_LIST_DIR_NAME = "_tables";
    public static final Long REPL_BOOTSTRAP_MIGRATION_BASE_WRITE_ID = 1L;
    public static final int REPL_BOOTSTRAP_MIGRATION_BASE_STMT_ID = 0;
    public static final String REPL_DUMP_INCLUDE_ACID_TABLES = "hive.repl.dump.include.acid.tables";

    public static Map<Integer, List<ExprNodeGenericFuncDesc>> genPartSpecs(Table table, List<Map<String, String>> partitions) throws SemanticException {
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        int partPrefixLength = 0;
        if (partitions.size() > 0) {
            partPrefixLength = partitions.get(0).size();
        }
        ArrayList<ExprNodeGenericFuncDesc> partitionDesc = new ArrayList<ExprNodeGenericFuncDesc>();
        for (Map<String, String> ptn : partitions) {
            ExprNodeGenericFuncDesc expr = null;
            for (Map.Entry<String, String> kvp : ptn.entrySet()) {
                String key = kvp.getKey();
                String val = kvp.getValue();
                String type = table.getPartColByName(key).getType();
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo(type);
                ExprNodeColumnDesc column = new ExprNodeColumnDesc(pti, key, null, true);
                ExprNodeGenericFuncDesc op = PartitionUtils.makeBinaryPredicate("=", column, new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, val));
                expr = expr == null ? op : PartitionUtils.makeBinaryPredicate("and", expr, op);
            }
            if (expr == null) continue;
            partitionDesc.add(expr);
        }
        if (partitionDesc.size() > 0) {
            partSpecs.put(partPrefixLength, partitionDesc);
        }
        return partSpecs;
    }

    public static Task<?> getTableReplLogTask(ImportTableDesc tableDesc, ReplLogger replLogger, HiveConf conf) throws SemanticException {
        TableType tableType = tableDesc.isExternal() ? TableType.EXTERNAL_TABLE : tableDesc.tableType();
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, tableDesc.getTableName(), tableType);
        return TaskFactory.get(replLogWork, conf);
    }

    public static Task<?> getTableCheckpointTask(ImportTableDesc tableDesc, HashMap<String, String> partSpec, String dumpRoot, HiveConf conf) throws SemanticException {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put(REPL_CHECKPOINT_KEY, dumpRoot);
        TableName tName = TableName.fromString(tableDesc.getTableName(), null, tableDesc.getDatabaseName());
        AlterTableSetPropertiesDesc alterTblDesc = new AlterTableSetPropertiesDesc(tName, partSpec, null, false, mapProp, false, false, null);
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterTblDesc), conf);
    }

    public static boolean replCkptStatus(String dbName, Map<String, String> props, String dumpRoot) throws InvalidOperationException {
        if (props != null && props.containsKey(REPL_CHECKPOINT_KEY) && !props.get(REPL_CHECKPOINT_KEY).isEmpty()) {
            if (props.get(REPL_CHECKPOINT_KEY).equals(dumpRoot)) {
                return true;
            }
            throw new InvalidOperationException(ErrorMsg.REPL_BOOTSTRAP_LOAD_PATH_NOT_VALID.format(dumpRoot, props.get(REPL_CHECKPOINT_KEY)));
        }
        return false;
    }

    public static boolean isTableMigratingToTransactional(HiveConf conf, org.apache.hadoop.hive.metastore.api.Table tableObj) throws TException, IOException {
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_STRICT_MANAGED_TABLES) && !AcidUtils.isTransactionalTable(tableObj) && TableType.valueOf(tableObj.getTableType()) == TableType.MANAGED_TABLE) {
            HiveStrictManagedMigration.TableMigrationOption migrationOption = HiveStrictManagedMigration.determineMigrationTypeAutomatically(tableObj, TableType.MANAGED_TABLE, null, conf, null, true);
            return migrationOption == HiveStrictManagedMigration.TableMigrationOption.MANAGED;
        }
        return false;
    }

    private static void addOpenTxnTaskForMigration(String actualDbName, String actualTblName, HiveConf conf, UpdatedMetaDataTracker updatedMetaDataTracker, List<Task<? extends Serializable>> taskList, Task<? extends Serializable> childTask) {
        Task<ReplTxnWork> replTxnTask = TaskFactory.get(new ReplTxnWork(actualDbName, actualTblName, ReplTxnWork.OperationType.REPL_MIGRATION_OPEN_TXN), conf);
        replTxnTask.addDependentTask(childTask);
        updatedMetaDataTracker.setNeedCommitTxn(true);
        taskList.add(replTxnTask);
    }

    public static List<Task<? extends Serializable>> addOpenTxnTaskForMigration(String actualDbName, String actualTblName, HiveConf conf, UpdatedMetaDataTracker updatedMetaDataTracker, Task<? extends Serializable> childTask, org.apache.hadoop.hive.metastore.api.Table tableObj) throws IOException, TException {
        ArrayList<Task<? extends Serializable>> taskList = new ArrayList<Task<? extends Serializable>>();
        taskList.add(childTask);
        if (ReplUtils.isTableMigratingToTransactional(conf, tableObj) && updatedMetaDataTracker != null) {
            ReplUtils.addOpenTxnTaskForMigration(actualDbName, actualTblName, conf, updatedMetaDataTracker, taskList, childTask);
        }
        return taskList;
    }

    public static List<Task<? extends Serializable>> addTasksForLoadingColStats(ColumnStatistics colStats, HiveConf conf, UpdatedMetaDataTracker updatedMetadata, org.apache.hadoop.hive.metastore.api.Table tableObj, long writeId) throws IOException, TException {
        ArrayList<Task<? extends Serializable>> taskList = new ArrayList<Task<? extends Serializable>>();
        boolean isMigratingToTxn = ReplUtils.isTableMigratingToTransactional(conf, tableObj);
        ColumnStatsUpdateWork work = new ColumnStatsUpdateWork(colStats, isMigratingToTxn);
        work.setWriteId(writeId);
        Task<ColumnStatsUpdateWork> task = TaskFactory.get(work, conf);
        taskList.add(task);
        if (isMigratingToTxn) {
            ReplUtils.addOpenTxnTaskForMigration(colStats.getStatsDesc().getDbName(), colStats.getStatsDesc().getTableName(), conf, updatedMetadata, taskList, task);
        }
        return taskList;
    }

    public static PathFilter getEventsDirectoryFilter(FileSystem fs) {
        return p -> {
            try {
                return fs.isDirectory(p) && !p.getName().equalsIgnoreCase(INC_BOOTSTRAP_ROOT_DIR_NAME) && !p.getName().equalsIgnoreCase(REPL_TABLE_LIST_DIR_NAME);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static PathFilter getBootstrapDirectoryFilter(FileSystem fs) {
        return p -> {
            try {
                return fs.isDirectory(p) && !p.getName().equalsIgnoreCase(REPL_TABLE_LIST_DIR_NAME);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static boolean isFirstIncPending(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        String firstIncPendFlag = parameters.get(REPL_FIRST_INC_PENDING_FLAG);
        return firstIncPendFlag != null && !firstIncPendFlag.isEmpty() && "true".equalsIgnoreCase(firstIncPendFlag);
    }

    public static EnvironmentContext setReplDataLocationChangedFlag(EnvironmentContext envContext) {
        if (envContext == null) {
            envContext = new EnvironmentContext();
        }
        envContext.putToProperties("REPL_DATA_LOCATION_CHANGED", "true");
        return envContext;
    }

    public static boolean includeAcidTableInDump(HiveConf conf) {
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL)) {
            return conf.getBoolean(REPL_DUMP_INCLUDE_ACID_TABLES, true);
        }
        return true;
    }

    public static Long getMigrationCurrentTblWriteId(HiveConf conf) {
        String writeIdString = conf.get(REPL_CURRENT_TBL_WRITE_ID);
        if (writeIdString == null) {
            return null;
        }
        return Long.parseLong(writeIdString);
    }

    public static boolean tableIncludedInReplScope(ReplScope replScope, String tableName) {
        return replScope == null || replScope.tableIncludedInReplScope(tableName);
    }

    public static enum ReplLoadOpType {
        LOAD_NEW,
        LOAD_SKIP,
        LOAD_REPLACE;

    }
}

