/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.incremental;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.repl.load.EventDumpDirComparator;

public class IncrementalLoadEventsIterator
implements Iterator<FileStatus> {
    private FileStatus[] eventDirs;
    private int currentIndex;
    private int numEvents;

    public IncrementalLoadEventsIterator(String loadPath, HiveConf conf) throws IOException {
        Path eventPath = new Path(loadPath);
        FileSystem fs = eventPath.getFileSystem((Configuration)conf);
        this.eventDirs = fs.listStatus(eventPath, ReplUtils.getEventsDirectoryFilter(fs));
        if (this.eventDirs == null || this.eventDirs.length == 0) {
            this.currentIndex = 0;
            this.numEvents = 0;
            return;
        }
        Arrays.sort(this.eventDirs, new EventDumpDirComparator());
        this.currentIndex = 0;
        this.numEvents = this.eventDirs.length;
    }

    @Override
    public boolean hasNext() {
        return this.eventDirs != null && this.currentIndex < this.numEvents;
    }

    @Override
    public FileStatus next() {
        if (this.hasNext()) {
            return this.eventDirs[this.currentIndex++];
        }
        throw new NoSuchElementException("no more events");
    }

    public int getNumEvents() {
        return this.numEvents;
    }
}

