/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.drop.DropTableDesc;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.PathUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTable {
    private static final Logger LOG = LoggerFactory.getLogger(LoadTable.class);
    private final Context context;
    private final ReplLogger replLogger;
    private final TableContext tableContext;
    private final TaskTracker tracker;
    private final TableEvent event;

    public LoadTable(TableEvent event, Context context, ReplLogger replLogger, TableContext tableContext, TaskTracker limiter) {
        this.event = event;
        this.context = context;
        this.replLogger = replLogger;
        this.tableContext = tableContext;
        this.tracker = new TaskTracker(limiter);
    }

    public TaskTracker tasks(boolean isBootstrapDuringInc) throws Exception {
        if (this.event.shouldNotReplicate()) {
            return this.tracker;
        }
        String dbName = this.tableContext.dbNameToLoadIn;
        ImportTableDesc tableDesc = this.event.tableDesc(dbName);
        Table table = ImportSemanticAnalyzer.tableIfExists(tableDesc, this.context.hiveDb);
        Database parentDb = this.context.hiveDb.getDatabase(tableDesc.getDatabaseName());
        if (parentDb == null && !this.tableContext.waitOnPrecursor()) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(tableDesc.getDatabaseName()));
        }
        Task<?> tblRootTask = null;
        ReplUtils.ReplLoadOpType loadTblType = this.getLoadTableType(table, isBootstrapDuringInc);
        switch (loadTblType) {
            case LOAD_NEW: {
                break;
            }
            case LOAD_REPLACE: {
                tblRootTask = this.dropTableTask(table);
                break;
            }
            case LOAD_SKIP: {
                return this.tracker;
            }
        }
        TableLocationTuple tableLocationTuple = LoadTable.tableLocation(tableDesc, parentDb, this.tableContext, this.context);
        tableDesc.setLocation(tableLocationTuple.location);
        this.newTableTasks(tableDesc, tblRootTask, tableLocationTuple);
        Task<?> ckptTask = ReplUtils.getTableCheckpointTask(tableDesc, null, this.context.dumpDirectory, this.context.hiveConf);
        if (!ImportSemanticAnalyzer.isPartitioned(tableDesc)) {
            Task<?> replLogTask = ReplUtils.getTableReplLogTask(tableDesc, this.replLogger, this.context.hiveConf);
            ckptTask.addDependentTask(replLogTask);
        }
        this.tracker.addDependentTask(ckptTask);
        return this.tracker;
    }

    private ReplUtils.ReplLoadOpType getLoadTableType(Table table, boolean isBootstrapDuringInc) throws InvalidOperationException, HiveException {
        if (table == null) {
            return ReplUtils.ReplLoadOpType.LOAD_NEW;
        }
        if (isBootstrapDuringInc) {
            LOG.info("Table " + table.getTableName() + " will be replaced as bootstrap is requested during incremental load");
            return ReplUtils.ReplLoadOpType.LOAD_REPLACE;
        }
        if (ReplUtils.replCkptStatus(table.getDbName(), table.getParameters(), this.context.dumpDirectory)) {
            return ReplUtils.ReplLoadOpType.LOAD_SKIP;
        }
        return ReplUtils.ReplLoadOpType.LOAD_REPLACE;
    }

    private void newTableTasks(ImportTableDesc tblDesc, Task<?> tblRootTask, TableLocationTuple tuple) throws Exception {
        boolean shouldCreateLoadTableTask;
        ReplTxnWork replTxnWork;
        Table table = tblDesc.toTable(this.context.hiveConf);
        ReplicationSpec replicationSpec = this.event.replicationSpec();
        Task<?> createTableTask = tblDesc.getCreateTableTask(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), this.context.hiveConf);
        if (tblRootTask == null) {
            tblRootTask = createTableTask;
        } else {
            tblRootTask.addDependentTask(createTableTask);
        }
        if (replicationSpec.isMetadataOnly()) {
            this.tracker.addTask(tblRootTask);
            return;
        }
        Task<Object> parentTask = createTableTask;
        if (replicationSpec.isTransactionalTableDump()) {
            List<String> partNames = ImportSemanticAnalyzer.isPartitioned(tblDesc) ? this.event.partitions(tblDesc) : null;
            replTxnWork = new ReplTxnWork(tblDesc.getDatabaseName(), tblDesc.getTableName(), partNames, replicationSpec.getValidWriteIdList(), ReplTxnWork.OperationType.REPL_WRITEID_STATE);
            Task<ReplTxnWork> replTxnTask = TaskFactory.get(replTxnWork, this.context.hiveConf);
            parentTask.addDependentTask(replTxnTask);
            parentTask = replTxnTask;
        } else if (replicationSpec.isMigratingToTxnTable()) {
            ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(AcidUtils.getFullTableName(tblDesc.getDatabaseName(), tblDesc.getTableName()), new long[0], new BitSet(), ReplUtils.REPL_BOOTSTRAP_MIGRATION_BASE_WRITE_ID);
            replTxnWork = new ReplTxnWork(tblDesc.getDatabaseName(), tblDesc.getTableName(), null, validWriteIdList.writeToString(), ReplTxnWork.OperationType.REPL_WRITEID_STATE);
            Task<ReplTxnWork> replTxnTask = TaskFactory.get(replTxnWork, this.context.hiveConf);
            parentTask.addDependentTask(replTxnTask);
            parentTask = replTxnTask;
        }
        boolean bl = shouldCreateLoadTableTask = !ImportSemanticAnalyzer.isPartitioned(tblDesc) && !TableType.EXTERNAL_TABLE.equals((Object)table.getTableType()) || tuple.isConvertedFromManagedToExternal;
        if (shouldCreateLoadTableTask) {
            LOG.debug("adding dependent ReplTxnTask/CopyWork/MoveWork for table");
            Task<?> loadTableTask = this.loadTableTask(table, replicationSpec, new Path(tblDesc.getLocation()), this.event.metadataPath());
            parentTask.addDependentTask(loadTableTask);
        }
        this.tracker.addTask(tblRootTask);
    }

    static TableLocationTuple tableLocation(ImportTableDesc tblDesc, Database parentDb, TableContext tableContext, Context context) throws MetaException, SemanticException {
        Warehouse wh = context.warehouse;
        Path defaultTablePath = parentDb == null ? wh.getDefaultTablePath(tblDesc.getDatabaseName(), tblDesc.getTableName(), tblDesc.isExternal()) : wh.getDefaultTablePath(parentDb, tblDesc.getTableName(), tblDesc.isExternal());
        if (tblDesc.isExternal()) {
            if (tblDesc.getLocation() == null) {
                return new TableLocationTuple(wh.getDnsPath(defaultTablePath).toString(), true);
            }
            String currentLocation = new Path(tblDesc.getLocation()).toUri().getPath();
            String newLocation = ReplExternalTables.externalTableLocation(context.hiveConf, currentLocation);
            LOG.debug("external table {} data location is: {}", (Object)tblDesc.getTableName(), (Object)newLocation);
            return new TableLocationTuple(newLocation, false);
        }
        Path path = tableContext.waitOnPrecursor() ? wh.getDnsPath(defaultTablePath) : wh.getDefaultTablePath(parentDb, tblDesc.getTableName(), tblDesc.isExternal());
        return new TableLocationTuple(path.toString(), false);
    }

    private Task<?> loadTableTask(Table table, ReplicationSpec replicationSpec, Path tgtPath, Path fromURI) {
        LoadTableDesc loadTableWork;
        LoadTableDesc.LoadFileType loadFileType;
        Path dataPath = new Path(fromURI, "data");
        Path tmpPath = tgtPath;
        if (replicationSpec.isInReplicationScope() && this.context.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_ENABLE_MOVE_OPTIMIZATION)) {
            loadFileType = LoadTableDesc.LoadFileType.IGNORE;
            if (this.event.replicationSpec().isMigratingToTxnTable()) {
                tmpPath = new Path(tmpPath, AcidUtils.baseDir(ReplUtils.REPL_BOOTSTRAP_MIGRATION_BASE_WRITE_ID));
            }
        } else {
            loadFileType = replicationSpec.isReplace() || replicationSpec.isMigratingToTxnTable() ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING;
            tmpPath = PathUtils.getExternalTmpPath(tgtPath, this.context.pathInfo);
        }
        LOG.debug("adding dependent CopyWork/AddPart/MoveWork for table " + table.getCompleteName() + " with source location: " + dataPath.toString() + " and target location " + tgtPath.toString());
        Task<?> copyTask = ReplCopyTask.getLoadCopyTask(replicationSpec, dataPath, tmpPath, this.context.hiveConf);
        MoveWork moveWork = new MoveWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), null, null, false);
        if (AcidUtils.isTransactionalTable(table)) {
            if (replicationSpec.isMigratingToTxnTable()) {
                loadTableWork = new LoadTableDesc(tmpPath, Utilities.getTableDesc(table), new TreeMap<String, String>(), loadFileType, ReplUtils.REPL_BOOTSTRAP_MIGRATION_BASE_WRITE_ID);
                loadTableWork.setStmtId(0);
                loadTableWork.setInsertOverwrite(true);
                moveWork.setLoadTableWork(loadTableWork);
            } else {
                LoadMultiFilesDesc loadFilesWork = new LoadMultiFilesDesc(Collections.singletonList(tmpPath), Collections.singletonList(tgtPath), true, null, null);
                moveWork.setMultiFilesDesc(loadFilesWork);
            }
        } else {
            loadTableWork = new LoadTableDesc(tmpPath, Utilities.getTableDesc(table), new TreeMap<String, String>(), loadFileType, (Long)0L);
            moveWork.setLoadTableWork(loadTableWork);
        }
        moveWork.setIsInReplicationScope(replicationSpec.isInReplicationScope());
        Task<MoveWork> loadTableTask = TaskFactory.get(moveWork, this.context.hiveConf);
        copyTask.addDependentTask(loadTableTask);
        return copyTask;
    }

    private Task<?> dropTableTask(Table table) {
        assert (table != null);
        DropTableDesc dropTblDesc = new DropTableDesc(table.getFullyQualifiedName(), true, false, this.event.replicationSpec());
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), dropTblDesc), this.context.hiveConf);
    }

    static class TableLocationTuple {
        final String location;
        private final boolean isConvertedFromManagedToExternal;

        TableLocationTuple(String location, boolean isConvertedFromManagedToExternal) {
            this.location = location;
            this.isConvertedFromManagedToExternal = isConvertedFromManagedToExternal;
        }
    }
}

