/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.util.HiveStrictManagedMigration;

public class FSTableEvent
implements TableEvent {
    private final Path fromPath;
    private final MetaData metadata;
    private final HiveConf hiveConf;

    FSTableEvent(HiveConf hiveConf, String metadataDir) {
        try {
            URI fromURI = EximUtil.getValidatedURI(hiveConf, PlanUtils.stripQuotes(metadataDir));
            this.fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
            FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)hiveConf);
            this.metadata = EximUtil.readMetaData(fs, new Path(this.fromPath, "_metadata"));
            this.hiveConf = hiveConf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDbName() {
        return this.metadata.getTable().getDbName();
    }

    public String getTableName() {
        return this.metadata.getTable().getTableName();
    }

    @Override
    public boolean shouldNotReplicate() {
        ReplicationSpec spec = this.replicationSpec();
        return spec.isNoop() || !spec.isInReplicationScope();
    }

    @Override
    public Path metadataPath() {
        return this.fromPath;
    }

    @Override
    public ImportTableDesc tableDesc(String dbName) throws SemanticException {
        try {
            Table table = new Table(this.metadata.getTable());
            boolean externalTableOnSource = TableType.EXTERNAL_TABLE.equals((Object)table.getTableType());
            if (!AcidUtils.isTransactionalTable(table) && this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_STRICT_MANAGED_TABLES) && table.getTableType() == TableType.MANAGED_TABLE) {
                Hive hiveDb = Hive.get(this.hiveConf);
                HiveStrictManagedMigration.TableMigrationOption migrationOption = HiveStrictManagedMigration.determineMigrationTypeAutomatically(table.getTTable(), table.getTableType(), null, this.hiveConf, hiveDb.getMSC(), true);
                HiveStrictManagedMigration.migrateTable(table.getTTable(), table.getTableType(), migrationOption, false, HiveStrictManagedMigration.getHiveUpdater(this.hiveConf), hiveDb.getMSC(), this.hiveConf);
                if (AcidUtils.isTransactionalTable(table)) {
                    this.replicationSpec().setMigratingToTxnTable();
                    if (table.getTTable().isSetColStats()) {
                        table.getTTable().setWriteId(ReplUtils.REPL_BOOTSTRAP_MIGRATION_BASE_WRITE_ID);
                    }
                }
                if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType())) {
                    table.setDataLocation(null);
                    if (!externalTableOnSource) {
                        this.replicationSpec().setMigratingToExternalTable();
                    }
                }
            }
            ImportTableDesc tableDesc = new ImportTableDesc(StringUtils.isBlank(dbName) ? table.getDbName() : dbName, table);
            if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType())) {
                tableDesc.setLocation(table.getDataLocation() == null ? null : table.getDataLocation().toString());
                tableDesc.setExternal(true);
            }
            if (table.getOwner() != null) {
                tableDesc.setOwnerName(table.getOwner());
            }
            tableDesc.setReplicationSpec(this.replicationSpec());
            return tableDesc;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public List<AlterTableAddPartitionDesc> partitionDescriptions(ImportTableDesc tblDesc) throws SemanticException {
        ArrayList<AlterTableAddPartitionDesc> descs = new ArrayList<AlterTableAddPartitionDesc>();
        for (Partition partition : this.metadata.getPartitions()) {
            AlterTableAddPartitionDesc partsDesc = this.partitionDesc(this.fromPath, tblDesc, partition);
            descs.add(partsDesc);
        }
        return descs;
    }

    @Override
    public List<String> partitions(ImportTableDesc tblDesc) throws SemanticException {
        ArrayList<String> partitions = new ArrayList<String>();
        try {
            for (Partition partition : this.metadata.getPartitions()) {
                String partName = Warehouse.makePartName(tblDesc.getPartCols(), partition.getValues());
                partitions.add(partName);
            }
        }
        catch (MetaException e) {
            throw new SemanticException(e);
        }
        return partitions;
    }

    private AlterTableAddPartitionDesc partitionDesc(Path fromPath, ImportTableDesc tblDesc, Partition partition) throws SemanticException {
        try {
            AlterTableAddPartitionDesc partsDesc = new AlterTableAddPartitionDesc(tblDesc.getDatabaseName(), tblDesc.getTableName(), EximUtil.makePartSpec(tblDesc.getPartCols(), partition.getValues()), partition.getSd().getLocation(), partition.getParameters());
            AlterTableAddPartitionDesc.PartitionDesc partDesc = partsDesc.getPartition(0);
            partDesc.setInputFormat(partition.getSd().getInputFormat());
            partDesc.setOutputFormat(partition.getSd().getOutputFormat());
            partDesc.setNumBuckets(partition.getSd().getNumBuckets());
            partDesc.setCols(partition.getSd().getCols());
            partDesc.setSerializationLib(partition.getSd().getSerdeInfo().getSerializationLib());
            partDesc.setSerdeParams(partition.getSd().getSerdeInfo().getParameters());
            partDesc.setBucketCols(partition.getSd().getBucketCols());
            partDesc.setSortCols(partition.getSd().getSortCols());
            if (tblDesc.isExternal() && !this.replicationSpec().isMigratingToExternalTable()) {
                partDesc.setLocation(partition.getSd().getLocation());
            } else {
                partDesc.setLocation(new Path(fromPath, Warehouse.makePartName(tblDesc.getPartCols(), partition.getValues())).toString());
            }
            partsDesc.setReplicationSpec(this.replicationSpec());
            if (partition.isSetColStats()) {
                ColumnStatistics colStats = partition.getColStats();
                ColumnStatisticsDesc colStatsDesc = new ColumnStatisticsDesc(colStats.getStatsDesc());
                colStatsDesc.setTableName(tblDesc.getTableName());
                colStatsDesc.setDbName(tblDesc.getDatabaseName());
                ColumnStatistics cs = new ColumnStatistics(colStatsDesc, colStats.getStatsObj());
                cs.setEngine(colStats.getEngine());
                partDesc.setColStats(cs);
                long writeId = this.replicationSpec().isMigratingToTxnTable() ? ReplUtils.REPL_BOOTSTRAP_MIGRATION_BASE_WRITE_ID.longValue() : partition.getWriteId();
                partDesc.setWriteId(writeId);
            }
            return partsDesc;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public ReplicationSpec replicationSpec() {
        return this.metadata.getReplicationSpec();
    }

    @Override
    public BootstrapEvent.EventType eventType() {
        return BootstrapEvent.EventType.Table;
    }
}

