/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.PartitionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSTableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;

public class FSPartitionEvent
implements PartitionEvent {
    private final ReplicationState replicationState;
    private final TableEvent tableEvent;

    FSPartitionEvent(HiveConf hiveConf, String metadataDir, ReplicationState replicationState) {
        this.tableEvent = new FSTableEvent(hiveConf, metadataDir);
        this.replicationState = replicationState;
    }

    @Override
    public BootstrapEvent.EventType eventType() {
        return BootstrapEvent.EventType.Partition;
    }

    @Override
    public AlterTableAddPartitionDesc lastPartitionReplicated() {
        assert (this.replicationState != null && this.replicationState.partitionState != null);
        return this.replicationState.partitionState.lastReplicatedPartition;
    }

    @Override
    public TableEvent asTableEvent() {
        return this.tableEvent;
    }

    @Override
    public ImportTableDesc tableDesc(String dbName) throws SemanticException {
        return this.tableEvent.tableDesc(dbName);
    }

    @Override
    public List<AlterTableAddPartitionDesc> partitionDescriptions(ImportTableDesc tblDesc) throws SemanticException {
        return this.tableEvent.partitionDescriptions(tblDesc);
    }

    @Override
    public List<String> partitions(ImportTableDesc tblDesc) throws SemanticException {
        return this.tableEvent.partitions(tblDesc);
    }

    @Override
    public ReplicationSpec replicationSpec() {
        return this.tableEvent.replicationSpec();
    }

    @Override
    public boolean shouldNotReplicate() {
        return this.tableEvent.shouldNotReplicate();
    }

    @Override
    public Path metadataPath() {
        return this.tableEvent.metadataPath();
    }
}

