/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.ExternalTableCopyTaskBuilder;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.BootstrapEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.ConstraintEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.incremental.IncrementalLoadEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.incremental.IncrementalLoadTasksBuilder;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.session.LineageState;

@Explain(displayName="Replication Load Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplLoadWork
implements Serializable {
    final String dbNameToLoadIn;
    final ReplScope currentReplScope;
    final String dumpDirectory;
    final String bootstrapDumpToCleanTables;
    boolean needCleanTablesFromBootstrap;
    private final ConstraintEventsIterator constraintsIterator;
    private int loadTaskRunCount = 0;
    private DatabaseEvent.State state = null;
    private final transient BootstrapEventsIterator bootstrapIterator;
    private transient IncrementalLoadTasksBuilder incrementalLoadTasksBuilder;
    private transient Task<? extends Serializable> rootTask;
    private final transient Iterator<ExternalTableCopyTaskBuilder.DirCopyWork> pathsToCopyIterator;
    final LineageState sessionStateLineageState;

    public ReplLoadWork(HiveConf hiveConf, String dumpDirectory, String dbNameToLoadIn, ReplScope currentReplScope, LineageState lineageState, boolean isIncrementalDump, Long eventTo, List<ExternalTableCopyTaskBuilder.DirCopyWork> pathsToCopyIterator) throws IOException {
        this.sessionStateLineageState = lineageState;
        this.dumpDirectory = dumpDirectory;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.currentReplScope = currentReplScope;
        if (currentReplScope != null && StringUtils.isNotBlank(dbNameToLoadIn)) {
            currentReplScope.setDbName(dbNameToLoadIn);
        }
        this.bootstrapDumpToCleanTables = hiveConf.get("hive.repl.clean.tables.from.bootstrap");
        this.needCleanTablesFromBootstrap = StringUtils.isNotBlank(this.bootstrapDumpToCleanTables);
        this.rootTask = null;
        if (isIncrementalDump) {
            this.incrementalLoadTasksBuilder = new IncrementalLoadTasksBuilder(dbNameToLoadIn, dumpDirectory, new IncrementalLoadEventsIterator(dumpDirectory, hiveConf), hiveConf, eventTo);
            Path incBootstrapDir = new Path(dumpDirectory, "_bootstrap");
            FileSystem fs = incBootstrapDir.getFileSystem((Configuration)hiveConf);
            if (fs.exists(incBootstrapDir)) {
                this.bootstrapIterator = new BootstrapEventsIterator(incBootstrapDir.toString(), dbNameToLoadIn, true, hiveConf);
                this.constraintsIterator = new ConstraintEventsIterator(dumpDirectory, hiveConf);
            } else {
                this.bootstrapIterator = null;
                this.constraintsIterator = null;
            }
        } else {
            this.bootstrapIterator = new BootstrapEventsIterator(dumpDirectory, dbNameToLoadIn, true, hiveConf);
            this.constraintsIterator = new ConstraintEventsIterator(dumpDirectory, hiveConf);
            this.incrementalLoadTasksBuilder = null;
        }
        this.pathsToCopyIterator = pathsToCopyIterator.iterator();
    }

    BootstrapEventsIterator bootstrapIterator() {
        return this.bootstrapIterator;
    }

    ConstraintEventsIterator constraintsIterator() {
        return this.constraintsIterator;
    }

    int executedLoadTask() {
        return ++this.loadTaskRunCount;
    }

    void updateDbEventState(DatabaseEvent.State state) {
        this.state = state;
    }

    DatabaseEvent databaseEvent(HiveConf hiveConf) {
        return this.state.toEvent(hiveConf);
    }

    boolean hasDbState() {
        return this.state != null;
    }

    boolean isIncrementalLoad() {
        return this.incrementalLoadTasksBuilder != null;
    }

    boolean hasBootstrapLoadTasks() {
        return this.bootstrapIterator != null && this.bootstrapIterator.hasNext() || this.constraintsIterator != null && this.constraintsIterator.hasNext();
    }

    IncrementalLoadTasksBuilder incrementalLoadTasksBuilder() {
        return this.incrementalLoadTasksBuilder;
    }

    public Task<? extends Serializable> getRootTask() {
        return this.rootTask;
    }

    public void setRootTask(Task<? extends Serializable> rootTask) {
        this.rootTask = rootTask;
    }

    public Iterator<ExternalTableCopyTaskBuilder.DirCopyWork> getPathsToCopyIterator() {
        return this.pathsToCopyIterator;
    }
}

