/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.alter.poperties.AlterDatabaseSetPropertiesDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ExternalTableCopyTaskBuilder;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.ConstraintEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.FunctionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.PartitionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.BootstrapEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.ConstraintEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSTableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadConstraint;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadDatabase;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadFunction;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadPartitions;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadTable;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.incremental.IncrementalLoadTasksBuilder;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.PathBuilder;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.api.StageType;

public class ReplLoadTask
extends Task<ReplLoadWork>
implements Serializable {
    private static final int ZERO_TASKS = 0;

    @Override
    public String getName() {
        return ((ReplLoadWork)this.work).isIncrementalLoad() ? "REPL_INCREMENTAL_LOAD" : "REPL_BOOTSTRAP_LOAD";
    }

    @Override
    public StageType getType() {
        return ((ReplLoadWork)this.work).isIncrementalLoad() ? StageType.REPL_INCREMENTAL_LOAD : StageType.REPL_BOOTSTRAP_LOAD;
    }

    @Override
    public int execute() {
        Task<? extends Serializable> rootTask = ((ReplLoadWork)this.work).getRootTask();
        if (rootTask != null) {
            rootTask.setChildTasks(null);
        }
        ((ReplLoadWork)this.work).setRootTask(this);
        this.parentTasks = null;
        if (((ReplLoadWork)this.work).isIncrementalLoad()) {
            return this.executeIncrementalLoad();
        }
        return this.executeBootStrapLoad();
    }

    private int executeBootStrapLoad() {
        try {
            boolean addAnotherLoadTask;
            int maxTasks = this.conf.getIntVar(HiveConf.ConfVars.REPL_APPROX_MAX_LOAD_TASKS);
            Context loadContext = new Context(((ReplLoadWork)this.work).dumpDirectory, this.conf, this.getHive(), ((ReplLoadWork)this.work).sessionStateLineageState, this.context);
            TaskTracker loadTaskTracker = new TaskTracker(maxTasks);
            BootstrapEventsIterator iterator = ((ReplLoadWork)this.work).bootstrapIterator();
            ConstraintEventsIterator constraintIterator = ((ReplLoadWork)this.work).constraintsIterator();
            TaskTracker dbTracker = new TaskTracker(0);
            TaskTracker tableTracker = new TaskTracker(0);
            Scope scope = new Scope();
            boolean loadingConstraint = false;
            if (!iterator.hasNext() && constraintIterator.hasNext()) {
                loadingConstraint = true;
            }
            while ((iterator.hasNext() || loadingConstraint && constraintIterator.hasNext() || ((ReplLoadWork)this.work).getPathsToCopyIterator().hasNext()) && loadTaskTracker.canAddMoreTasks()) {
                if (((ReplLoadWork)this.work).getPathsToCopyIterator().hasNext()) {
                    scope.rootTasks.addAll(new ExternalTableCopyTaskBuilder((ReplLoadWork)this.work, this.conf).tasks(loadTaskTracker));
                    break;
                }
                BootstrapEvent next = !loadingConstraint ? iterator.next() : constraintIterator.next();
                switch (next.eventType()) {
                    case Database: {
                        DatabaseEvent dbEvent = (DatabaseEvent)next;
                        dbTracker = new LoadDatabase(loadContext, dbEvent, ((ReplLoadWork)this.work).dbNameToLoadIn, loadTaskTracker).tasks();
                        loadTaskTracker.update(dbTracker);
                        if (((ReplLoadWork)this.work).hasDbState()) {
                            loadTaskTracker.update(this.updateDatabaseLastReplID(maxTasks, loadContext, scope));
                        } else {
                            scope.database = false;
                        }
                        ((ReplLoadWork)this.work).updateDbEventState(dbEvent.toState());
                        if (dbTracker.hasTasks()) {
                            scope.rootTasks.addAll(dbTracker.tasks());
                            scope.database = true;
                        }
                        dbTracker.debugLog("database");
                        break;
                    }
                    case Table: {
                        TableContext tableContext = new TableContext(dbTracker, ((ReplLoadWork)this.work).dbNameToLoadIn);
                        TableEvent tableEvent = (TableEvent)next;
                        LoadTable loadTable = new LoadTable(tableEvent, loadContext, iterator.replLogger(), tableContext, loadTaskTracker);
                        tableTracker = loadTable.tasks(((ReplLoadWork)this.work).isIncrementalLoad());
                        this.setUpDependencies(dbTracker, tableTracker);
                        if (!scope.database && tableTracker.hasTasks()) {
                            scope.rootTasks.addAll(tableTracker.tasks());
                            scope.table = true;
                        } else {
                            scope.table = false;
                        }
                        LoadPartitions loadPartitions = new LoadPartitions(loadContext, iterator.replLogger(), loadTaskTracker, tableEvent, ((ReplLoadWork)this.work).dbNameToLoadIn, tableContext);
                        TaskTracker partitionsTracker = loadPartitions.tasks();
                        this.partitionsPostProcessing(iterator, scope, loadTaskTracker, tableTracker, partitionsTracker);
                        tableTracker.debugLog("table");
                        partitionsTracker.debugLog("partitions for table");
                        break;
                    }
                    case Partition: {
                        PartitionEvent event = (PartitionEvent)next;
                        TableContext tableContext = new TableContext(dbTracker, ((ReplLoadWork)this.work).dbNameToLoadIn);
                        LoadPartitions loadPartitions = new LoadPartitions(loadContext, iterator.replLogger(), tableContext, loadTaskTracker, event.asTableEvent(), ((ReplLoadWork)this.work).dbNameToLoadIn, event.lastPartitionReplicated());
                        TaskTracker partitionsTracker = loadPartitions.tasks();
                        this.partitionsPostProcessing(iterator, scope, loadTaskTracker, tableTracker, partitionsTracker);
                        partitionsTracker.debugLog("partitions");
                        break;
                    }
                    case Function: {
                        LoadFunction loadFunction = new LoadFunction(loadContext, iterator.replLogger(), (FunctionEvent)next, ((ReplLoadWork)this.work).dbNameToLoadIn, dbTracker);
                        TaskTracker functionsTracker = loadFunction.tasks();
                        if (!scope.database) {
                            scope.rootTasks.addAll(functionsTracker.tasks());
                        } else {
                            this.setUpDependencies(dbTracker, functionsTracker);
                        }
                        loadTaskTracker.update(functionsTracker);
                        functionsTracker.debugLog("functions");
                        break;
                    }
                    case Constraint: {
                        LoadConstraint loadConstraint = new LoadConstraint(loadContext, (ConstraintEvent)next, ((ReplLoadWork)this.work).dbNameToLoadIn, dbTracker);
                        TaskTracker constraintTracker = loadConstraint.tasks();
                        scope.rootTasks.addAll(constraintTracker.tasks());
                        loadTaskTracker.update(constraintTracker);
                        constraintTracker.debugLog("constraints");
                    }
                }
                if (loadingConstraint || iterator.currentDbHasNext()) continue;
                this.createEndReplLogTask(loadContext, scope, iterator.replLogger());
            }
            boolean bl = addAnotherLoadTask = iterator.hasNext() || loadTaskTracker.hasReplicationState() || constraintIterator.hasNext() || ((ReplLoadWork)this.work).getPathsToCopyIterator().hasNext();
            if (addAnotherLoadTask) {
                this.createBuilderTask(scope.rootTasks);
            }
            if (!(iterator.hasNext() || constraintIterator.hasNext() || ((ReplLoadWork)this.work).getPathsToCopyIterator().hasNext() || ((ReplLoadWork)this.work).isIncrementalLoad())) {
                loadTaskTracker.update(this.updateDatabaseLastReplID(maxTasks, loadContext, scope));
                ((ReplLoadWork)this.work).updateDbEventState(null);
            }
            this.childTasks = scope.rootTasks;
            LOG.info("Root Tasks / Total Tasks : {} / {} ", (Object)this.childTasks.size(), (Object)loadTaskTracker.numberOfTasks());
            this.context.getFsScratchDirs().putAll(loadContext.pathInfo.getFsScratchDirs());
        }
        catch (RuntimeException e) {
            LOG.error("replication failed with run time exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error("replication failed", (Throwable)e);
            this.setException(e);
            return ErrorMsg.getErrorMsg(e.getMessage()).getErrorCode();
        }
        LOG.info("completed load task run : {}", (Object)((ReplLoadWork)this.work).executedLoadTask());
        return 0;
    }

    private void cleanTablesFromBootstrap() throws HiveException, IOException, InvalidInputException {
        Path bootstrapDirectory = new PathBuilder(((ReplLoadWork)this.work).bootstrapDumpToCleanTables).addDescendant("_bootstrap").build();
        FileSystem fs = bootstrapDirectory.getFileSystem((Configuration)this.conf);
        if (!fs.exists(bootstrapDirectory)) {
            throw new InvalidInputException("Input bootstrap dump directory specified to clean tables from is invalid: " + bootstrapDirectory);
        }
        FileStatus[] fileStatuses = fs.listStatus(bootstrapDirectory, EximUtil.getDirectoryFilter(fs));
        if (fileStatuses == null || fileStatuses.length == 0) {
            throw new InvalidInputException("Input bootstrap dump directory specified to clean tables from is empty: " + bootstrapDirectory);
        }
        if (StringUtils.isNotBlank(((ReplLoadWork)this.work).dbNameToLoadIn) && fileStatuses.length > 1) {
            throw new InvalidInputException("Input bootstrap dump directory specified to clean tables from has multiple DB dirs in the dump: " + bootstrapDirectory + " which is not allowed on single target DB: " + ((ReplLoadWork)this.work).dbNameToLoadIn);
        }
        BootstrapEventsIterator bootstrapEventsIterator = new BootstrapEventsIterator(bootstrapDirectory.toString(), ((ReplLoadWork)this.work).dbNameToLoadIn, false, this.conf);
        HashMap dbToTblsListMap = new HashMap();
        while (bootstrapEventsIterator.hasNext()) {
            List<String> tableNames;
            String dbName;
            BootstrapEvent event = bootstrapEventsIterator.next();
            if (!event.eventType().equals((Object)BootstrapEvent.EventType.Table)) continue;
            FSTableEvent tableEvent = (FSTableEvent)event;
            String string = dbName = StringUtils.isBlank(((ReplLoadWork)this.work).dbNameToLoadIn) ? tableEvent.getDbName() : ((ReplLoadWork)this.work).dbNameToLoadIn;
            if (dbToTblsListMap.containsKey(dbName)) {
                tableNames = (List)dbToTblsListMap.get(dbName);
            } else {
                tableNames = new ArrayList();
                dbToTblsListMap.put(dbName, tableNames);
            }
            tableNames.add(tableEvent.getTableName());
        }
        if (dbToTblsListMap.isEmpty()) {
            LOG.info("No DB/tables are listed in the bootstrap dump: {} specified to clean tables.", (Object)bootstrapDirectory);
            return;
        }
        Hive db = this.getHive();
        for (Map.Entry dbEntry : dbToTblsListMap.entrySet()) {
            String dbName = (String)dbEntry.getKey();
            List tableNames = (List)dbEntry.getValue();
            for (String table : tableNames) {
                db.dropTable(dbName + "." + table, true);
            }
            LOG.info("Tables listed in the Database: {} in the bootstrap dump: {} are cleaned", (Object)dbName, (Object)bootstrapDirectory);
        }
    }

    private void dropTablesExcludedInReplScope(ReplScope replScope) throws HiveException {
        if (replScope == null || replScope.includeAllTables()) {
            return;
        }
        Hive db = this.getHive();
        String dbName = replScope.getDbName();
        Collection<String> tableNames = Collections2.filter(db.getAllTables(dbName), tableName -> {
            assert (tableName != null);
            return !tableName.toLowerCase().startsWith("Values__Tmp__Table__".toLowerCase()) && !replScope.tableIncludedInReplScope((String)tableName);
        });
        for (String table : tableNames) {
            db.dropTable(dbName + "." + table, true);
        }
        LOG.info("Tables in the Database: {} that are excluded in the replication scope are dropped.", (Object)dbName);
    }

    private void createEndReplLogTask(Context context, Scope scope, ReplLogger replLogger) throws SemanticException {
        HashMap<String, String> dbProps;
        if (((ReplLoadWork)this.work).isIncrementalLoad()) {
            dbProps = new HashMap<String, String>();
            dbProps.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), ((ReplLoadWork)this.work).incrementalLoadTasksBuilder().eventTo().toString());
        } else {
            Database dbInMetadata = ((ReplLoadWork)this.work).databaseEvent(context.hiveConf).dbInMetadata(((ReplLoadWork)this.work).dbNameToLoadIn);
            dbProps = dbInMetadata.getParameters();
        }
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, dbProps);
        Task<ReplStateLogWork> replLogTask = TaskFactory.get(replLogWork, this.conf);
        if (scope.rootTasks.isEmpty()) {
            scope.rootTasks.add(replLogTask);
        } else {
            DAGTraversal.traverse(scope.rootTasks, new AddDependencyToLeaves(Collections.singletonList(replLogTask)));
        }
    }

    private TaskTracker updateDatabaseLastReplID(int maxTasks, Context context, Scope scope) throws SemanticException {
        TaskTracker taskTracker = new LoadDatabase.AlterDatabase(context, ((ReplLoadWork)this.work).databaseEvent(context.hiveConf), ((ReplLoadWork)this.work).dbNameToLoadIn, new TaskTracker(maxTasks)).tasks();
        AddDependencyToLeaves function = new AddDependencyToLeaves(taskTracker.tasks());
        DAGTraversal.traverse(scope.rootTasks, function);
        return taskTracker;
    }

    private void partitionsPostProcessing(BootstrapEventsIterator iterator, Scope scope, TaskTracker loadTaskTracker, TaskTracker tableTracker, TaskTracker partitionsTracker) {
        this.setUpDependencies(tableTracker, partitionsTracker);
        if (!scope.database && !scope.table) {
            scope.rootTasks.addAll(partitionsTracker.tasks());
            scope.partition = true;
        }
        loadTaskTracker.update(tableTracker);
        loadTaskTracker.update(partitionsTracker);
        if (partitionsTracker.hasReplicationState()) {
            iterator.setReplicationState(partitionsTracker.replicationState());
        }
    }

    private void setUpDependencies(TaskTracker parentTasks, TaskTracker childTasks) {
        if (parentTasks.hasTasks()) {
            for (Task<? extends Serializable> parentTask : parentTasks.tasks()) {
                for (Task<? extends Serializable> childTask : childTasks.tasks()) {
                    parentTask.addDependentTask(childTask);
                }
            }
        } else {
            for (Task<? extends Serializable> childTask : childTasks.tasks()) {
                parentTasks.addTask(childTask);
            }
        }
    }

    private void createBuilderTask(List<Task<? extends Serializable>> rootTasks) {
        Task<Serializable> loadTask = TaskFactory.get(this.work, this.conf);
        DAGTraversal.traverse(rootTasks, new AddDependencyToLeaves(loadTask));
    }

    private int executeIncrementalLoad() {
        try {
            if (((ReplLoadWork)this.work).needCleanTablesFromBootstrap) {
                this.cleanTablesFromBootstrap();
                ((ReplLoadWork)this.work).needCleanTablesFromBootstrap = false;
            }
            this.dropTablesExcludedInReplScope(((ReplLoadWork)this.work).currentReplScope);
            IncrementalLoadTasksBuilder builder = ((ReplLoadWork)this.work).incrementalLoadTasksBuilder();
            if (!builder.hasMoreWork() && !((ReplLoadWork)this.work).getPathsToCopyIterator().hasNext() && ((ReplLoadWork)this.work).hasBootstrapLoadTasks()) {
                LOG.debug("Current incremental dump have tables to be bootstrapped. Switching to bootstrap mode after applying all events.");
                return this.executeBootStrapLoad();
            }
            ArrayList<Task<? extends Serializable>> childTasks = new ArrayList<Task<? extends Serializable>>();
            int maxTasks = this.conf.getIntVar(HiveConf.ConfVars.REPL_APPROX_MAX_LOAD_TASKS);
            TaskTracker tracker = new TaskTracker(maxTasks);
            if (((ReplLoadWork)this.work).getPathsToCopyIterator().hasNext()) {
                childTasks.addAll(new ExternalTableCopyTaskBuilder((ReplLoadWork)this.work, this.conf).tasks(tracker));
            } else {
                childTasks.add(builder.build(this.context, this.getHive(), LOG, tracker));
            }
            if (!builder.hasMoreWork() && !((ReplLoadWork)this.work).getPathsToCopyIterator().hasNext()) {
                String replScopeDbName;
                String dbName = ((ReplLoadWork)this.work).dbNameToLoadIn;
                if ((dbName == null || StringUtils.isBlank(dbName)) && ((ReplLoadWork)this.work).currentReplScope != null && (replScopeDbName = ((ReplLoadWork)this.work).currentReplScope.getDbName()) != null && !"*".equals(replScopeDbName)) {
                    dbName = replScopeDbName;
                }
                if (StringUtils.isNotBlank(dbName)) {
                    String lastEventid = builder.eventTo().toString();
                    HashMap<String, String> mapProp = new HashMap<String, String>();
                    mapProp.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), lastEventid);
                    AlterDatabaseSetPropertiesDesc alterDbDesc = new AlterDatabaseSetPropertiesDesc(dbName, mapProp, new ReplicationSpec(lastEventid, lastEventid));
                    Task<DDLWork> updateReplIdTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc), this.conf);
                    DAGTraversal.traverse(childTasks, new AddDependencyToLeaves(updateReplIdTask));
                    LOG.debug("Added task to set last repl id of db " + dbName + " to " + lastEventid);
                }
            }
            if (builder.hasMoreWork() || ((ReplLoadWork)this.work).getPathsToCopyIterator().hasNext() || ((ReplLoadWork)this.work).hasBootstrapLoadTasks()) {
                DAGTraversal.traverse(childTasks, new AddDependencyToLeaves(TaskFactory.get(this.work, this.conf)));
            }
            this.childTasks = childTasks;
            return 0;
        }
        catch (Exception e) {
            LOG.error("failed replication", (Throwable)e);
            this.setException(e);
            return 1;
        }
    }

    private static class Scope {
        boolean database = false;
        boolean table = false;
        boolean partition = false;
        List<Task<? extends Serializable>> rootTasks = new ArrayList<Task<? extends Serializable>>();

        private Scope() {
        }
    }
}

