/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.PathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplExternalTables {
    private static final Logger LOG = LoggerFactory.getLogger(ReplExternalTables.class);
    private static final String FIELD_SEPARATOR = ",";
    public static final String FILE_NAME = "_external_tables_info";
    private static final int MAX_RETRIES = 5;

    private ReplExternalTables() {
    }

    public static String externalTableLocation(HiveConf hiveConf, String location) throws SemanticException {
        String baseDir = hiveConf.get(HiveConf.ConfVars.REPL_EXTERNAL_TABLE_BASE_DIR.varname);
        Path basePath = new Path(baseDir);
        Path currentPath = new Path(location);
        Path dataLocation = ReplExternalTables.externalTableDataPath(hiveConf, basePath, currentPath);
        LOG.info("Incoming external table location: {} , new location: {}", (Object)location, (Object)dataLocation.toString());
        return dataLocation.toString();
    }

    public static Path externalTableDataPath(HiveConf hiveConf, Path basePath, Path sourcePath) throws SemanticException {
        Path dataPath;
        String baseUriPath = basePath.toUri().getPath();
        String sourceUriPath = sourcePath.toUri().getPath();
        String targetPathWithoutSchemeAndAuth = "/".equalsIgnoreCase(baseUriPath) ? sourceUriPath : baseUriPath + sourceUriPath;
        try {
            dataPath = PathBuilder.fullyQualifiedHDFSUri(new Path(targetPathWithoutSchemeAndAuth), basePath.getFileSystem((Configuration)hiveConf));
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
        }
        return dataPath;
    }

    public static class Reader {
        private static Logger LOG = LoggerFactory.getLogger(Reader.class);
        private final HiveConf hiveConf;
        private final Path rootReplLoadPath;
        private final boolean isIncrementalPhase;

        public Reader(HiveConf conf, Path rootReplLoadPath, boolean isIncrementalPhase) {
            this.hiveConf = conf;
            this.rootReplLoadPath = rootReplLoadPath;
            this.isIncrementalPhase = isIncrementalPhase;
        }

        public Set<String> sourceLocationsToCopy() throws IOException {
            FileStatus[] fileStatuses;
            if (this.isIncrementalPhase) {
                return this.sourceLocationsToCopy(new Path(this.rootReplLoadPath, ReplExternalTables.FILE_NAME));
            }
            HashSet<String> locationsToCopy = new HashSet<String>();
            FileSystem fileSystem = this.rootReplLoadPath.getFileSystem((Configuration)this.hiveConf);
            for (FileStatus next : fileStatuses = fileSystem.listStatus(this.rootReplLoadPath)) {
                if (!next.isDirectory()) continue;
                Path externalTableInfoPath = new Path(next.getPath(), ReplExternalTables.FILE_NAME);
                locationsToCopy.addAll(this.sourceLocationsToCopy(externalTableInfoPath));
            }
            return locationsToCopy;
        }

        private BufferedReader reader(FileSystem fs, Path externalTableInfo) throws IOException {
            InputStreamReader in = new InputStreamReader((InputStream)fs.open(externalTableInfo), StandardCharsets.UTF_8);
            return new BufferedReader(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> sourceLocationsToCopy(Path externalTableInfo) throws IOException {
            HashSet<String> locationsToCopy = new HashSet<String>();
            FileSystem fileSystem = externalTableInfo.getFileSystem((Configuration)this.hiveConf);
            if (!fileSystem.exists(externalTableInfo)) {
                return locationsToCopy;
            }
            int currentRetry = 0;
            BufferedReader reader = null;
            while (currentRetry < 5) {
                Object line;
                try {
                    reader = this.reader(fileSystem, externalTableInfo);
                    line = reader.readLine();
                    while (line != null) {
                        String[] splits = ((String)line).split(ReplExternalTables.FIELD_SEPARATOR);
                        locationsToCopy.add(new String(Base64.getDecoder().decode(splits[1]), StandardCharsets.UTF_8));
                        line = reader.readLine();
                    }
                    line = locationsToCopy;
                }
                catch (IOException e) {
                    try {
                        if (++currentRetry >= 5) {
                            LOG.error("failed to read {}", (Object)externalTableInfo.toString(), (Object)e);
                            throw e;
                        }
                        Reader.closeQuietly(reader);
                        LOG.warn("failed to read {}", (Object)externalTableInfo.toString(), (Object)e);
                    }
                    catch (Throwable throwable) {
                        Reader.closeQuietly(reader);
                        throw throwable;
                    }
                    Reader.closeQuietly(reader);
                    continue;
                }
                Reader.closeQuietly(reader);
                return line;
            }
            throw new IllegalStateException("we should never reach this condition");
        }

        private static void closeQuietly(BufferedReader reader) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOG.debug("error while closing reader ", (Throwable)e);
            }
        }
    }

    public static class Writer
    implements Closeable {
        private static Logger LOG = LoggerFactory.getLogger(Writer.class);
        private final HiveConf hiveConf;
        private final Path writePath;
        private final boolean includeExternalTables;
        private final boolean dumpMetadataOnly;
        private OutputStream writer;

        Writer(Path dbRoot, HiveConf hiveConf) throws IOException {
            this.hiveConf = hiveConf;
            this.writePath = new Path(dbRoot, ReplExternalTables.FILE_NAME);
            this.includeExternalTables = hiveConf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES);
            boolean bl = this.dumpMetadataOnly = hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY) || hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY_FOR_EXTERNAL_TABLE);
            if (this.shouldWrite()) {
                this.writer = FileSystem.get((Configuration)hiveConf).create(this.writePath);
            }
        }

        private boolean shouldWrite() {
            return !this.dumpMetadataOnly && this.includeExternalTables;
        }

        void dataLocationDump(Table table) throws InterruptedException, IOException, HiveException {
            if (!this.shouldWrite()) {
                return;
            }
            if (!TableType.EXTERNAL_TABLE.equals((Object)table.getTableType())) {
                throw new IllegalArgumentException("only External tables can be writen via this writer, provided table is " + (Object)((Object)table.getTableType()));
            }
            Path fullyQualifiedDataLocation = PathBuilder.fullyQualifiedHDFSUri(table.getDataLocation(), FileSystem.get((Configuration)this.hiveConf));
            this.write(Writer.lineFor(table.getTableName(), fullyQualifiedDataLocation, this.hiveConf));
            if (table.isPartitioned()) {
                List<Partition> partitions;
                try {
                    partitions = Hive.get(this.hiveConf).getPartitions(table);
                }
                catch (HiveException e) {
                    if (e.getCause() instanceof NoSuchObjectException) {
                        LOG.debug(e.getMessage());
                        return;
                    }
                    throw e;
                }
                for (Partition partition : partitions) {
                    boolean partitionLocOutsideTableLoc = !FileUtils.isPathWithinSubtree(partition.getDataLocation(), table.getDataLocation());
                    if (!partitionLocOutsideTableLoc) continue;
                    fullyQualifiedDataLocation = PathBuilder.fullyQualifiedHDFSUri(partition.getDataLocation(), FileSystem.get((Configuration)this.hiveConf));
                    this.write(Writer.lineFor(table.getTableName(), fullyQualifiedDataLocation, this.hiveConf));
                }
            }
        }

        private static String lineFor(String tableName, Path dataLoc, HiveConf hiveConf) throws IOException, SemanticException {
            StringWriter lineToWrite = new StringWriter();
            lineToWrite.append(tableName).append(ReplExternalTables.FIELD_SEPARATOR);
            Path dataLocation = PathBuilder.fullyQualifiedHDFSUri(dataLoc, dataLoc.getFileSystem((Configuration)hiveConf));
            byte[] encodedBytes = Base64.getEncoder().encode(dataLocation.toString().getBytes(StandardCharsets.UTF_8));
            String encodedPath = new String(encodedBytes, StandardCharsets.UTF_8);
            lineToWrite.append(encodedPath).append("\n");
            return lineToWrite.toString();
        }

        private void write(String line) throws InterruptedException {
            int currentRetry = 0;
            while (currentRetry < 5) {
                try {
                    this.writer.write(line.getBytes(StandardCharsets.UTF_8));
                    break;
                }
                catch (IOException e) {
                    if (++currentRetry >= 5) {
                        LOG.error("failed to write data with maxRetries {} due to", (Object)currentRetry, (Object)e);
                        throw new RuntimeException("failed to write data", e);
                    }
                    LOG.warn("failed to write data with maxRetries {} due to", (Object)currentRetry, (Object)e);
                    Thread.sleep(100 * currentRetry * currentRetry);
                    this.writer = this.openWriterAppendMode();
                }
            }
        }

        private OutputStream openWriterAppendMode() {
            try {
                this.close();
                return FileSystem.get((Configuration)this.hiveConf).append(this.writePath);
            }
            catch (IOException e1) {
                String message = "there was an error to open the file {} in append mode";
                LOG.error(message, (Object)this.writePath.toString(), (Object)e1);
                throw new IllegalStateException(message, e1);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }
}

