/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.messaging.event.filters.AndFilter;
import org.apache.hadoop.hive.metastore.messaging.event.filters.EventBoundaryFilter;
import org.apache.hadoop.hive.metastore.messaging.event.filters.ReplEventFilter;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.events.EventUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.HiveWrapper;
import org.apache.hadoop.hive.ql.parse.repl.dump.TableExport;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandlerFactory;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.ConstraintsSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.FunctionSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.BootstrapDumpLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.IncrementalDumpLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplDumpTask
extends Task<ReplDumpWork>
implements Serializable {
    private static final String dumpSchema = "dump_dir,last_repl_id#string,string";
    private static final String FUNCTION_METADATA_FILE_NAME = "_metadata";
    private static final long SLEEP_TIME = 60000L;
    Set<String> tablesForBootstrap = new HashSet<String>();
    private Logger LOG = LoggerFactory.getLogger(ReplDumpTask.class);
    private ReplLogger replLogger;

    @Override
    public String getName() {
        return "REPL_DUMP";
    }

    @Override
    public int execute() {
        try {
            Hive hiveDb = this.getHive();
            Path dumpRoot = new Path(this.conf.getVar(HiveConf.ConfVars.REPLDIR), this.getNextDumpDir());
            DumpMetaData dmd = new DumpMetaData(dumpRoot, this.conf);
            ReplChangeManager.getInstance(this.conf);
            Path cmRoot = new Path(this.conf.getVar(HiveConf.ConfVars.REPLCMDIR));
            Long lastReplId = ((ReplDumpWork)this.work).isBootStrapDump() ? this.bootStrapDump(dumpRoot, dmd, cmRoot, hiveDb) : this.incrementalDump(dumpRoot, dmd, cmRoot, hiveDb);
            this.prepareReturnValues(Arrays.asList(dumpRoot.toUri().toString(), String.valueOf(lastReplId)));
        }
        catch (Exception e) {
            this.LOG.error("failed", (Throwable)e);
            this.setException(e);
            return ErrorMsg.getErrorMsg(e.getMessage()).getErrorCode();
        }
        return 0;
    }

    private void prepareReturnValues(List<String> values) throws SemanticException {
        this.LOG.debug("prepareReturnValues : dump_dir,last_repl_id#string,string");
        for (String s : values) {
            this.LOG.debug("    > " + s);
        }
        org.apache.hadoop.hive.ql.parse.repl.dump.Utils.writeOutput(Collections.singletonList(values), new Path(((ReplDumpWork)this.work).resultTempPath), this.conf);
    }

    private boolean shouldExamineTablesToDump() {
        return ((ReplDumpWork)this.work).oldReplScope != null || !this.tablesForBootstrap.isEmpty() || this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES) || this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES);
    }

    private boolean shouldDumpExternalTableLocation() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES) && !this.conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY) && !this.conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY_FOR_EXTERNAL_TABLE);
    }

    private boolean shouldBootstrapDumpExternalTable(String tableName) {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES) && (this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_EXTERNAL_TABLES) || !ReplUtils.tableIncludedInReplScope(((ReplDumpWork)this.work).oldReplScope, tableName));
    }

    private boolean shouldBootstrapDumpAcidTable(String tableName) {
        return ReplUtils.includeAcidTableInDump(this.conf) && (this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES) || !ReplUtils.tableIncludedInReplScope(((ReplDumpWork)this.work).oldReplScope, tableName));
    }

    private boolean shouldBootstrapDumpTable(Table table) {
        if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType()) && this.shouldBootstrapDumpExternalTable(table.getTableName())) {
            return true;
        }
        if (AcidUtils.isTransactionalTable(table) && this.shouldBootstrapDumpAcidTable(table.getTableName())) {
            return true;
        }
        if (this.tablesForBootstrap.contains(table.getTableName().toLowerCase())) {
            return true;
        }
        return !ReplUtils.tableIncludedInReplScope(((ReplDumpWork)this.work).oldReplScope, table.getTableName());
    }

    private boolean isTableSatifiesConfig(Table table) {
        if (table == null) {
            return false;
        }
        if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType()) && !this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES)) {
            return false;
        }
        return !AcidUtils.isTransactionalTable(table) || ReplUtils.includeAcidTableInDump(this.conf);
    }

    private Long incrementalDump(Path dumpRoot, DumpMetaData dmd, Path cmRoot, Hive hiveDb) throws Exception {
        ArrayList<String> tableList;
        String validTxnList = null;
        long waitUntilTime = 0L;
        long bootDumpBeginReplId = -1L;
        ArrayList<String> arrayList = tableList = ((ReplDumpWork)this.work).replScope.includeAllTables() ? null : new ArrayList<String>();
        if (this.needBootstrapAcidTablesDuringIncrementalDump()) {
            bootDumpBeginReplId = this.queryState.getConf().getLong("hive.repl.last.repl.id", -1L);
            assert (bootDumpBeginReplId >= 0L);
            this.LOG.info("Dump for bootstrapping ACID tables during an incremental dump for db {}", (Object)((ReplDumpWork)this.work).dbNameOrPattern);
            long timeoutInMs = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.REPL_BOOTSTRAP_DUMP_OPEN_TXN_TIMEOUT, TimeUnit.MILLISECONDS);
            waitUntilTime = System.currentTimeMillis() + timeoutInMs;
        }
        ((ReplDumpWork)this.work).overrideLastEventToDump(hiveDb, bootDumpBeginReplId);
        AndFilter evFilter = new AndFilter(new ReplEventFilter(((ReplDumpWork)this.work).replScope), new EventBoundaryFilter(((ReplDumpWork)this.work).eventFrom, ((ReplDumpWork)this.work).eventTo));
        EventUtils.MSClientNotificationFetcher evFetcher = new EventUtils.MSClientNotificationFetcher(hiveDb);
        EventUtils.NotificationEventIterator evIter = new EventUtils.NotificationEventIterator(evFetcher, ((ReplDumpWork)this.work).eventFrom, ((ReplDumpWork)this.work).maxEventLimit(), evFilter);
        Long lastReplId = ((ReplDumpWork)this.work).eventTo;
        String dbName = null != ((ReplDumpWork)this.work).dbNameOrPattern && !((ReplDumpWork)this.work).dbNameOrPattern.isEmpty() ? ((ReplDumpWork)this.work).dbNameOrPattern : "?";
        int maxEventLimit = ((ReplDumpWork)this.work).maxEventLimit();
        this.replLogger = new IncrementalDumpLogger(dbName, dumpRoot.toString(), evFetcher.getDbNotificationEventsCount(((ReplDumpWork)this.work).eventFrom, dbName, ((ReplDumpWork)this.work).eventTo, maxEventLimit), ((ReplDumpWork)this.work).eventFrom, ((ReplDumpWork)this.work).eventTo, maxEventLimit);
        this.replLogger.startLog();
        while (evIter.hasNext()) {
            NotificationEvent ev = evIter.next();
            lastReplId = ev.getEventId();
            Path evRoot = new Path(dumpRoot, String.valueOf(lastReplId));
            this.dumpEvent(ev, evRoot, cmRoot, hiveDb);
        }
        this.replLogger.endLog(lastReplId.toString());
        this.LOG.info("Done dumping events, preparing to return {},{}", (Object)dumpRoot.toUri(), (Object)lastReplId);
        dmd.setDump(DumpType.INCREMENTAL, ((ReplDumpWork)this.work).eventFrom, lastReplId, cmRoot);
        if (((ReplDumpWork)this.work).oldReplScope != null) {
            dmd.setReplScope(((ReplDumpWork)this.work).replScope);
        }
        dmd.write();
        if (this.shouldExamineTablesToDump() || tableList != null) {
            if (this.needBootstrapAcidTablesDuringIncrementalDump()) {
                assert (waitUntilTime > 0L);
                validTxnList = this.getValidTxnListForReplDump(hiveDb, waitUntilTime);
            }
            Path dbRoot = this.getBootstrapDbRoot(dumpRoot, dbName, true);
            try (ReplExternalTables.Writer writer = new ReplExternalTables.Writer(dumpRoot, this.conf);){
                for (String tableName : org.apache.hadoop.hive.ql.parse.repl.dump.Utils.matchesTbl(hiveDb, dbName, ((ReplDumpWork)this.work).replScope)) {
                    try {
                        Table table = hiveDb.getTable(dbName, tableName);
                        if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType()) && this.shouldDumpExternalTableLocation()) {
                            writer.dataLocationDump(table);
                        }
                        if (this.shouldBootstrapDumpTable(table)) {
                            HiveWrapper.Tuple<Table> tableTuple = new HiveWrapper(hiveDb, dbName).table(table);
                            this.dumpTable(dbName, tableName, validTxnList, dbRoot, bootDumpBeginReplId, hiveDb, tableTuple);
                        }
                        if (tableList == null || !this.isTableSatifiesConfig(table)) continue;
                        tableList.add(tableName);
                    }
                    catch (InvalidTableException te) {
                        this.LOG.debug(te.getMessage());
                    }
                }
            }
            this.dumpTableListToDumpLocation(tableList, dumpRoot, dbName, this.conf);
        }
        return lastReplId;
    }

    private boolean needBootstrapAcidTablesDuringIncrementalDump() {
        if (!ReplUtils.includeAcidTableInDump(this.conf)) {
            return false;
        }
        return !((ReplDumpWork)this.work).replScope.includeAllTables() || ((ReplDumpWork)this.work).oldReplScope != null || this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES);
    }

    private Path getBootstrapDbRoot(Path dumpRoot, String dbName, boolean isIncrementalPhase) {
        if (isIncrementalPhase) {
            dumpRoot = new Path(dumpRoot, "_bootstrap");
        }
        return new Path(dumpRoot, dbName);
    }

    private void dumpEvent(NotificationEvent ev, Path evRoot, Path cmRoot, Hive db) throws Exception {
        EventHandler.Context context = new EventHandler.Context(evRoot, cmRoot, db, this.conf, this.getNewEventOnlyReplicationSpec(ev.getEventId()), ((ReplDumpWork)this.work).replScope, ((ReplDumpWork)this.work).oldReplScope, this.tablesForBootstrap);
        EventHandler eventHandler = EventHandlerFactory.handlerFor(ev);
        eventHandler.handle(context);
        this.replLogger.eventLog(String.valueOf(ev.getEventId()), eventHandler.dumpType().toString());
    }

    private ReplicationSpec getNewEventOnlyReplicationSpec(Long eventId) {
        ReplicationSpec rspec = this.getNewReplicationSpec(eventId.toString(), eventId.toString(), this.conf.getBoolean(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY.varname, false));
        rspec.setReplSpecType(ReplicationSpec.Type.INCREMENTAL_DUMP);
        return rspec;
    }

    private void dumpTableListToDumpLocation(List<String> tableList, Path dbRoot, String dbName, HiveConf hiveConf) throws IOException, LoginException {
        if (tableList == null) {
            this.LOG.debug("Table list file is not created for db level replication.");
            return;
        }
        Path tableListFile = new Path(dbRoot, "_tables");
        tableListFile = new Path(tableListFile, dbName.toLowerCase());
        for (int count = 0; count < 5; ++count) {
            try (FSDataOutputStream writer = FileSystem.get((Configuration)hiveConf).create(tableListFile);){
                for (String tableName : tableList) {
                    String line = tableName.toLowerCase().concat("\n");
                    writer.write(line.getBytes(StandardCharsets.UTF_8));
                }
                writer.close();
                break;
            }
            catch (IOException e) {
                this.LOG.info("File operation failed", (Throwable)e);
                if (count >= 4) {
                    this.LOG.error("File " + tableListFile.toUri() + " creation failed even after " + 5 + " attempts.");
                    throw new IOException(ErrorMsg.REPL_FILE_SYSTEM_OPERATION_RETRY.getMsg());
                }
                int sleepTime = FileUtils.getSleepTime(count);
                this.LOG.info("Sleep for " + sleepTime + " milliseconds before retry " + (count + 1));
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException timerEx) {
                    this.LOG.info("Sleep interrupted", (Object)timerEx.getMessage());
                }
                FileSystem.closeAllForUGI((UserGroupInformation)Utils.getUGI());
                continue;
            }
        }
        this.LOG.info("Table list file " + tableListFile.toUri() + " is created for table list - " + tableList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long bootStrapDump(Path dumpRoot, DumpMetaData dmd, Path cmRoot, Hive hiveDb) throws Exception {
        Long bootDumpBeginReplId = this.queryState.getConf().getLong("hive.repl.last.repl.id", -1L);
        assert (bootDumpBeginReplId >= 0L);
        this.LOG.info("Bootstrap Dump for db {}", (Object)((ReplDumpWork)this.work).dbNameOrPattern);
        long timeoutInMs = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.REPL_BOOTSTRAP_DUMP_OPEN_TXN_TIMEOUT, TimeUnit.MILLISECONDS);
        long waitUntilTime = System.currentTimeMillis() + timeoutInMs;
        String validTxnList = this.getValidTxnListForReplDump(hiveDb, waitUntilTime);
        for (String dbName : org.apache.hadoop.hive.ql.parse.repl.dump.Utils.matchesDb(hiveDb, ((ReplDumpWork)this.work).dbNameOrPattern)) {
            block31: {
                this.LOG.debug("Dumping db: " + dbName);
                ArrayList<String> tableList = ((ReplDumpWork)this.work).replScope.includeAllTables() ? null : new ArrayList<String>();
                Database db = hiveDb.getDatabase(dbName);
                if (db != null && ReplUtils.isFirstIncPending(db.getParameters())) {
                    throw new HiveException("Replication dump not allowed for replicated database with first incremental dump pending : " + dbName);
                }
                this.replLogger = new BootstrapDumpLogger(dbName, dumpRoot.toString(), org.apache.hadoop.hive.ql.parse.repl.dump.Utils.getAllTables(hiveDb, dbName, ((ReplDumpWork)this.work).replScope).size(), hiveDb.getAllFunctions().size());
                this.replLogger.startLog();
                Path dbRoot = this.dumpDbMetadata(dbName, dumpRoot, bootDumpBeginReplId, hiveDb);
                this.dumpFunctionMetadata(dbName, dumpRoot, hiveDb);
                String uniqueKey = org.apache.hadoop.hive.ql.parse.repl.dump.Utils.setDbBootstrapDumpState(hiveDb, dbName);
                Exception caught = null;
                try (ReplExternalTables.Writer writer = new ReplExternalTables.Writer(dbRoot, this.conf);){
                    for (String tblName : org.apache.hadoop.hive.ql.parse.repl.dump.Utils.matchesTbl(hiveDb, dbName, ((ReplDumpWork)this.work).replScope)) {
                        this.LOG.debug("Dumping table: " + tblName + " to db root " + dbRoot.toUri());
                        Table table = null;
                        try {
                            HiveWrapper.Tuple<Table> tableTuple = new HiveWrapper(hiveDb, dbName).table(tblName, this.conf);
                            Table table2 = table = tableTuple != null ? (Table)tableTuple.object : null;
                            if (this.shouldDumpExternalTableLocation() && TableType.EXTERNAL_TABLE.equals((Object)((Table)tableTuple.object).getTableType())) {
                                this.LOG.debug("Adding table {} to external tables list", (Object)tblName);
                                writer.dataLocationDump((Table)tableTuple.object);
                            }
                            this.dumpTable(dbName, tblName, validTxnList, dbRoot, bootDumpBeginReplId, hiveDb, tableTuple);
                        }
                        catch (InvalidTableException te) {
                            this.LOG.debug(te.getMessage());
                        }
                        this.dumpConstraintMetadata(dbName, tblName, dbRoot, hiveDb);
                        if (tableList == null || !this.isTableSatifiesConfig(table)) continue;
                        tableList.add(tblName);
                    }
                    this.dumpTableListToDumpLocation(tableList, dumpRoot, dbName, this.conf);
                }
                catch (Exception e) {
                    caught = e;
                    return caught;
                }
                finally {
                    try {
                        org.apache.hadoop.hive.ql.parse.repl.dump.Utils.resetDbBootstrapDumpState(hiveDb, dbName, uniqueKey);
                    }
                    catch (Exception e) {
                        if (caught == null) {
                            throw e;
                        }
                        this.LOG.error("failed to reset the db state for " + uniqueKey + " on failure of repl dump", (Throwable)e);
                        throw caught;
                    }
                    if (caught == null) break block31;
                    throw caught;
                }
            }
            this.replLogger.endLog(bootDumpBeginReplId.toString());
        }
        Long bootDumpEndReplId = this.currentNotificationId(hiveDb);
        this.LOG.info("Preparing to return {},{}->{}", new Object[]{dumpRoot.toUri(), bootDumpBeginReplId, bootDumpEndReplId});
        dmd.setDump(DumpType.BOOTSTRAP, bootDumpBeginReplId, bootDumpEndReplId, cmRoot);
        dmd.write();
        return bootDumpBeginReplId;
    }

    long currentNotificationId(Hive hiveDb) throws TException {
        return hiveDb.getMSC().getCurrentNotificationEventId().getEventId();
    }

    Path dumpDbMetadata(String dbName, Path dumpRoot, long lastReplId, Hive hiveDb) throws Exception {
        Path dbRoot = this.getBootstrapDbRoot(dumpRoot, dbName, false);
        FileSystem fs = dbRoot.getFileSystem((Configuration)this.conf);
        Path dumpPath = new Path(dbRoot, FUNCTION_METADATA_FILE_NAME);
        HiveWrapper.Tuple<Database> database = new HiveWrapper(hiveDb, dbName, lastReplId).database();
        EximUtil.createDbExportDump(fs, dumpPath, (Database)database.object, database.replicationSpec);
        return dbRoot;
    }

    void dumpTable(String dbName, String tblName, String validTxnList, Path dbRoot, long lastReplId, Hive hiveDb, HiveWrapper.Tuple<Table> tuple) throws Exception {
        this.LOG.info("Bootstrap Dump for table " + tblName);
        BaseSemanticAnalyzer.TableSpec tableSpec = new BaseSemanticAnalyzer.TableSpec((Table)tuple.object);
        TableExport.Paths exportPaths = new TableExport.Paths(((ReplDumpWork)this.work).astRepresentationForErrorMsg, dbRoot, tblName, this.conf, true);
        String distCpDoAsUser = this.conf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
        tuple.replicationSpec.setIsReplace(true);
        if (AcidUtils.isTransactionalTable(tableSpec.tableHandle)) {
            tuple.replicationSpec.setValidTxnList(validTxnList);
            tuple.replicationSpec.setValidWriteIdList(this.getValidWriteIdList(dbName, tblName, validTxnList));
            tuple.replicationSpec.setCurrentReplicationState(String.valueOf(lastReplId));
        }
        ExportWork.MmContext mmCtx = ExportWork.MmContext.createIfNeeded(tableSpec.tableHandle);
        tuple.replicationSpec.setRepl(true);
        new TableExport(exportPaths, tableSpec, tuple.replicationSpec, hiveDb, distCpDoAsUser, this.conf, mmCtx).write();
        this.replLogger.tableLog(tblName, tableSpec.tableHandle.getTableType());
    }

    private String getValidWriteIdList(String dbName, String tblName, String validTxnString) throws LockException {
        if (validTxnString == null || validTxnString.isEmpty()) {
            return null;
        }
        String fullTableName = AcidUtils.getFullTableName(dbName, tblName);
        ValidWriteIdList validWriteIds = this.getTxnMgr().getValidWriteIds(Collections.singletonList(fullTableName), validTxnString).getTableValidWriteIdList(fullTableName);
        return validWriteIds != null ? validWriteIds.toString() : null;
    }

    private List<Long> getOpenTxns(ValidTxnList validTxnList) {
        long[] invalidTxns = validTxnList.getInvalidTransactions();
        ArrayList<Long> openTxns = new ArrayList<Long>();
        for (long invalidTxn : invalidTxns) {
            if (validTxnList.isTxnAborted(invalidTxn)) continue;
            openTxns.add(invalidTxn);
        }
        return openTxns;
    }

    String getValidTxnListForReplDump(Hive hiveDb, long waitUntilTime) throws HiveException {
        ValidTxnList validTxnList = this.getTxnMgr().getValidTxns();
        while (System.currentTimeMillis() < waitUntilTime) {
            if (this.getOpenTxns(validTxnList).isEmpty()) {
                return validTxnList.toString();
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                this.LOG.info("REPL DUMP thread sleep interrupted", (Throwable)e);
            }
            validTxnList = this.getTxnMgr().getValidTxns();
        }
        List<Long> openTxns = this.getOpenTxns(validTxnList);
        if (!openTxns.isEmpty()) {
            hiveDb.abortTransactions(openTxns);
            validTxnList = this.getTxnMgr().getValidTxns();
            if (validTxnList.getMinOpenTxn() != null) {
                openTxns = this.getOpenTxns(validTxnList);
                this.LOG.warn("REPL DUMP unable to force abort all the open txns: {} after timeout due to unknown reasons. However, this is rare case that shouldn't happen.", openTxns);
                throw new IllegalStateException("REPL DUMP triggered abort txns failed for unknown reasons.");
            }
        }
        return validTxnList.toString();
    }

    private ReplicationSpec getNewReplicationSpec(String evState, String objState, boolean isMetadataOnly) {
        return new ReplicationSpec(true, isMetadataOnly, evState, objState, false, true, true);
    }

    private String getNextDumpDir() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            if (ReplDumpWork.testInjectDumpDir == null) {
                return "next";
            }
            return ReplDumpWork.testInjectDumpDir;
        }
        return UUID.randomUUID().toString();
    }

    void dumpFunctionMetadata(String dbName, Path dumpRoot, Hive hiveDb) throws Exception {
        Path functionsRoot = new Path(new Path(dumpRoot, dbName), "_functions");
        List<String> functionNames = hiveDb.getFunctions(dbName, "*");
        for (String functionName : functionNames) {
            HiveWrapper.Tuple<Function> tuple = this.functionTuple(functionName, dbName, hiveDb);
            if (tuple == null) continue;
            Path functionRoot = new Path(functionsRoot, functionName);
            Path functionMetadataFile = new Path(functionRoot, FUNCTION_METADATA_FILE_NAME);
            try (JsonWriter jsonWriter = new JsonWriter(functionMetadataFile.getFileSystem((Configuration)this.conf), functionMetadataFile);){
                FunctionSerializer serializer = new FunctionSerializer((Function)tuple.object, this.conf);
                serializer.writeTo(jsonWriter, tuple.replicationSpec);
            }
            this.replLogger.functionLog(functionName);
        }
    }

    void dumpConstraintMetadata(String dbName, String tblName, Path dbRoot, Hive hiveDb) throws Exception {
        block28: {
            try {
                ConstraintsSerializer serializer2;
                Throwable throwable;
                JsonWriter jsonWriter;
                Path constraintsRoot = new Path(dbRoot, "_constraints");
                Path commonConstraintsFile = new Path(constraintsRoot, ConstraintFileType.COMMON.getPrefix() + tblName);
                Path fkConstraintsFile = new Path(constraintsRoot, ConstraintFileType.FOREIGNKEY.getPrefix() + tblName);
                List<SQLPrimaryKey> pks = hiveDb.getPrimaryKeyList(dbName, tblName);
                List<SQLForeignKey> fks = hiveDb.getForeignKeyList(dbName, tblName);
                List<SQLUniqueConstraint> uks = hiveDb.getUniqueConstraintList(dbName, tblName);
                List<SQLNotNullConstraint> nns = hiveDb.getNotNullConstraintList(dbName, tblName);
                if (pks != null && !pks.isEmpty() || uks != null && !uks.isEmpty() || nns != null && !nns.isEmpty()) {
                    jsonWriter = new JsonWriter(commonConstraintsFile.getFileSystem((Configuration)this.conf), commonConstraintsFile);
                    throwable = null;
                    try {
                        serializer2 = new ConstraintsSerializer(pks, null, uks, nns, this.conf);
                        serializer2.writeTo(jsonWriter, null);
                    }
                    catch (Throwable serializer2) {
                        throwable = serializer2;
                        throw serializer2;
                    }
                    finally {
                        if (jsonWriter != null) {
                            if (throwable != null) {
                                try {
                                    jsonWriter.close();
                                }
                                catch (Throwable serializer2) {
                                    throwable.addSuppressed(serializer2);
                                }
                            } else {
                                jsonWriter.close();
                            }
                        }
                    }
                }
                if (fks == null || fks.isEmpty()) break block28;
                jsonWriter = new JsonWriter(fkConstraintsFile.getFileSystem((Configuration)this.conf), fkConstraintsFile);
                throwable = null;
                try {
                    serializer2 = new ConstraintsSerializer(null, fks, null, null, this.conf);
                    serializer2.writeTo(jsonWriter, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jsonWriter != null) {
                        if (throwable != null) {
                            try {
                                jsonWriter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            jsonWriter.close();
                        }
                    }
                }
            }
            catch (NoSuchObjectException e) {
                this.LOG.debug(e.getMessage());
            }
        }
    }

    private HiveWrapper.Tuple<Function> functionTuple(String functionName, String dbName, Hive hiveDb) {
        try {
            HiveWrapper.Tuple<Function> tuple = new HiveWrapper(hiveDb, dbName).function(functionName);
            if (((Function)tuple.object).getResourceUris().isEmpty()) {
                this.LOG.warn("Not replicating function: " + functionName + " as it seems to have been created " + "without USING clause");
                return null;
            }
            return tuple;
        }
        catch (HiveException e) {
            this.LOG.info("Function " + functionName + " could not be found, we are ignoring it as it can be a valid state ", (Throwable)e);
            return null;
        }
    }

    @Override
    public StageType getType() {
        return StageType.REPL_DUMP;
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }

    public static enum ConstraintFileType {
        COMMON("common", "c_"),
        FOREIGNKEY("fk", "f_");

        private final String name;
        private final String prefix;

        private ConstraintFileType(String name, String prefix) {
            this.name = name;
            this.prefix = prefix;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

