/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalTableCopyTaskBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalTableCopyTaskBuilder.class);
    private final ReplLoadWork work;
    private final HiveConf conf;

    ExternalTableCopyTaskBuilder(ReplLoadWork work, HiveConf conf) {
        this.work = work;
        this.conf = conf;
    }

    List<Task<? extends Serializable>> tasks(TaskTracker tracker) {
        ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
        Iterator<DirCopyWork> itr = this.work.getPathsToCopyIterator();
        while (tracker.canAddMoreTasks() && itr.hasNext()) {
            DirCopyWork dirCopyWork = itr.next();
            Task<DirCopyWork> task = TaskFactory.get(dirCopyWork, this.conf);
            tasks.add(task);
            tracker.addTask(task);
            LOG.debug("added task for {}", (Object)dirCopyWork);
        }
        return tasks;
    }

    @Explain(displayName="HDFS Copy Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public static class DirCopyWork
    implements Serializable {
        private final Path fullyQualifiedSourcePath;
        private final Path fullyQualifiedTargetPath;

        public DirCopyWork(Path fullyQualifiedSourcePath, Path fullyQualifiedTargetPath) {
            this.fullyQualifiedSourcePath = fullyQualifiedSourcePath;
            this.fullyQualifiedTargetPath = fullyQualifiedTargetPath;
        }

        public String toString() {
            return "DirCopyWork{fullyQualifiedSourcePath=" + this.fullyQualifiedSourcePath + ", fullyQualifiedTargetPath=" + this.fullyQualifiedTargetPath + '}';
        }
    }

    public static class DirCopyTask
    extends Task<DirCopyWork>
    implements Serializable {
        private static final Logger LOG = LoggerFactory.getLogger(DirCopyTask.class);
        private static final int MAX_COPY_RETRY = 5;

        private boolean createAndSetPathOwner(Path destPath, Path sourcePath) throws IOException {
            FileStatus status;
            FileSystem targetFs = destPath.getFileSystem((Configuration)this.conf);
            boolean createdDir = false;
            if (!targetFs.exists(destPath)) {
                if (!targetFs.mkdirs(destPath)) {
                    throw new IOException(destPath + " is not a directory or unable to create one");
                }
                createdDir = true;
            }
            try {
                status = sourcePath.getFileSystem((Configuration)this.conf).getFileStatus(sourcePath);
            }
            catch (FileNotFoundException e) {
                LOG.warn("source path missing " + sourcePath);
                return createdDir;
            }
            LOG.info("Setting permission for path dest {} from source {} owner {} : {} : {}", new Object[]{destPath, sourcePath, status.getOwner(), status.getGroup(), status.getPermission()});
            destPath.getFileSystem((Configuration)this.conf).setOwner(destPath, status.getOwner(), status.getGroup());
            destPath.getFileSystem((Configuration)this.conf).setPermission(destPath, status.getPermission());
            return createdDir;
        }

        private boolean setTargetPathOwner(Path targetPath, Path sourcePath, UserGroupInformation proxyUser) throws IOException, InterruptedException {
            if (proxyUser == null) {
                return this.createAndSetPathOwner(targetPath, sourcePath);
            }
            return (Boolean)proxyUser.doAs(() -> this.createAndSetPathOwner(targetPath, sourcePath));
        }

        private boolean checkIfPathExist(Path sourcePath, UserGroupInformation proxyUser) throws Exception {
            if (proxyUser == null) {
                return sourcePath.getFileSystem((Configuration)this.conf).exists(sourcePath);
            }
            return (Boolean)proxyUser.doAs(() -> sourcePath.getFileSystem((Configuration)this.conf).exists(sourcePath));
        }

        private int handleException(Exception e, Path sourcePath, Path targetPath, int currentRetry, UserGroupInformation proxyUser) {
            try {
                LOG.info("Checking if source path " + sourcePath + " is missing for exception ", (Throwable)e);
                if (!this.checkIfPathExist(sourcePath, proxyUser)) {
                    LOG.info("Source path is missing. Ignoring exception.");
                    return 0;
                }
            }
            catch (Exception ex) {
                LOG.warn("Source path missing check failed. ", (Throwable)ex);
            }
            if (!(e instanceof IOException)) {
                LOG.error("Unable to copy {} to {}", new Object[]{sourcePath, targetPath, e});
                this.setException(e);
                return ErrorMsg.getErrorMsg(e.getMessage()).getErrorCode();
            }
            if (currentRetry > 5) {
                LOG.error("Unable to copy {} to {} even after retrying for {} time", new Object[]{sourcePath, targetPath, currentRetry, e});
                this.setException(e);
                return ErrorMsg.REPL_FILE_SYSTEM_OPERATION_RETRY.getErrorCode();
            }
            LOG.warn("Unable to copy {} to {}", new Object[]{sourcePath, targetPath, e});
            int sleepTime = FileUtils.getSleepTime(currentRetry);
            LOG.info("Sleep for " + sleepTime + " milliseconds before retry no " + currentRetry);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException timerEx) {
                LOG.info("Sleep interrupted", (Object)timerEx.getMessage());
            }
            try {
                if (proxyUser == null) {
                    proxyUser = Utils.getUGI();
                }
                FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
            }
            catch (Exception ex) {
                LOG.warn("Unable to closeAllForUGI for user " + proxyUser, (Throwable)ex);
            }
            return ErrorMsg.getErrorMsg(e.getMessage()).getErrorCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public int execute() {
            String distCpDoAsUser = this.conf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
            Path sourcePath = ((DirCopyWork)this.work).fullyQualifiedSourcePath;
            Path targetPath = ((DirCopyWork)this.work).fullyQualifiedTargetPath;
            if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_ADD_RAW_RESERVED_NAMESPACE)) {
                sourcePath = DirCopyTask.reservedRawPath(((DirCopyWork)this.work).fullyQualifiedSourcePath.toUri());
                targetPath = DirCopyTask.reservedRawPath(((DirCopyWork)this.work).fullyQualifiedTargetPath.toUri());
            }
            int currentRetry = 0;
            int error = 0;
            UserGroupInformation proxyUser = null;
            while (currentRetry <= 5) {
                int n;
                block16: {
                    UserGroupInformation ugi = Utils.getUGI();
                    String currentUser = ugi.getShortUserName();
                    if (distCpDoAsUser != null && !currentUser.equals(distCpDoAsUser)) {
                        proxyUser = UserGroupInformation.createProxyUser((String)distCpDoAsUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
                    }
                    this.setTargetPathOwner(targetPath, sourcePath, proxyUser);
                    FileUtils.distCp(sourcePath.getFileSystem((Configuration)this.conf), Collections.singletonList(sourcePath), targetPath, false, proxyUser, this.conf, ShimLoader.getHadoopShims());
                    n = 0;
                    if (proxyUser == null) break block16;
                    try {
                        FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
                    }
                    catch (IOException e) {
                        LOG.error("Unable to closeAllForUGI for user " + proxyUser, (Throwable)e);
                        if (error != 0) break;
                        this.setException(e);
                        error = ErrorMsg.getErrorMsg(e.getMessage()).getErrorCode();
                        break;
                    }
                }
                return n;
                catch (Exception e) {
                    block17: {
                        int n2;
                        block18: {
                            error = this.handleException(e, sourcePath, targetPath, ++currentRetry, proxyUser);
                            if (error != 0) break block17;
                            n2 = 0;
                            if (proxyUser == null) break block18;
                            try {
                                FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
                            }
                            catch (IOException e2) {
                                LOG.error("Unable to closeAllForUGI for user " + proxyUser, (Throwable)e2);
                                if (error != 0) break;
                                this.setException(e2);
                                error = ErrorMsg.getErrorMsg(e2.getMessage()).getErrorCode();
                                break;
                            }
                        }
                        return n2;
                    }
                    if (proxyUser == null) continue;
                    try {
                        FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
                        continue;
                    }
                    catch (IOException e3) {
                        LOG.error("Unable to closeAllForUGI for user " + proxyUser, (Throwable)e3);
                        if (error != 0) break;
                        this.setException(e3);
                        error = ErrorMsg.getErrorMsg(e3.getMessage()).getErrorCode();
                        break;
                    }
                    catch (Throwable throwable) {
                        if (proxyUser != null) {
                            try {
                                FileSystem.closeAllForUGI(proxyUser);
                            }
                            catch (IOException e4) {
                                LOG.error("Unable to closeAllForUGI for user " + proxyUser, (Throwable)e4);
                                if (error != 0) break;
                                this.setException(e4);
                                error = ErrorMsg.getErrorMsg(e4.getMessage()).getErrorCode();
                                break;
                            }
                        }
                        throw throwable;
                    }
                }
            }
            return error;
        }

        private static Path reservedRawPath(URI uri) {
            return new Path(uri.getScheme(), uri.getAuthority(), "/.reserved/raw/" + uri.getPath());
        }

        @Override
        public StageType getType() {
            return StageType.COPY;
        }

        @Override
        public String getName() {
            return "DIR_COPY_TASK";
        }

        @Override
        public boolean canExecuteInParallel() {
            return true;
        }
    }
}

