/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.DDLTask;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.exec.ColumnStatsUpdateTask;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.CopyTask;
import org.apache.hadoop.hive.ql.exec.DependencyCollectionTask;
import org.apache.hadoop.hive.ql.exec.ExplainSQRewriteTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.ExportTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.ReplTxnTask;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.repl.ExternalTableCopyTaskBuilder;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpTask;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadTask;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogTask;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.schq.ScheduledQueryMaintenanceTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.hive.ql.plan.ExplainSQRewriteWork;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.ReplCopyWork;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryMaintenanceWork;

public final class TaskFactory {
    public static ArrayList<TaskTuple<? extends Serializable>> taskvec = new ArrayList();
    private static ThreadLocal<Integer> tid;

    public static int getAndIncrementId() {
        int curValue = tid.get();
        tid.set(new Integer(curValue + 1));
        return curValue;
    }

    public static void resetId() {
        tid.set(0);
    }

    @VisibleForTesting
    static <T extends Serializable> Task<T> get(Class<T> workClass) {
        for (TaskTuple<? extends Serializable> t : taskvec) {
            if (t.workClass != workClass) continue;
            try {
                Task ret = t.taskClass.newInstance();
                ret.setId("Stage-" + Integer.toString(TaskFactory.getAndIncrementId()));
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No task for work class " + workClass.getName());
    }

    public static <T extends Serializable> Task<T> get(T work, HiveConf conf) {
        Task<Class<?>> ret = TaskFactory.get(work.getClass());
        ret.setWork((Class<?>)work);
        if (null != conf) {
            ret.setConf(conf);
        }
        return ret;
    }

    public static <T extends Serializable> Task<T> get(T work) {
        return TaskFactory.get(work, null);
    }

    @SafeVarargs
    public static <T extends Serializable> Task<T> getAndMakeChild(T work, HiveConf conf, Task<? extends Serializable> ... tasklist) {
        Task<T> ret = TaskFactory.get(work);
        if (tasklist.length == 0) {
            return ret;
        }
        TaskFactory.makeChild(ret, tasklist);
        return ret;
    }

    @SafeVarargs
    public static void makeChild(Task<?> ret, Task<? extends Serializable> ... tasklist) {
        for (Task<? extends Serializable> tsk : tasklist) {
            List<Task<? extends Serializable>> children = tsk.getChildTasks();
            if (children == null) {
                children = new ArrayList<Task<Serializable>>();
            }
            children.add(ret);
            tsk.setChildTasks(children);
        }
    }

    private TaskFactory() {
    }

    static {
        taskvec.add(new TaskTuple<MoveWork>(MoveWork.class, MoveTask.class));
        taskvec.add(new TaskTuple<FetchWork>(FetchWork.class, FetchTask.class));
        taskvec.add(new TaskTuple<CopyWork>(CopyWork.class, CopyTask.class));
        taskvec.add(new TaskTuple<ReplCopyWork>(ReplCopyWork.class, ReplCopyTask.class));
        taskvec.add(new TaskTuple<DDLWork>(DDLWork.class, DDLTask.class));
        taskvec.add(new TaskTuple<ExplainWork>(ExplainWork.class, ExplainTask.class));
        taskvec.add(new TaskTuple<ExplainSQRewriteWork>(ExplainSQRewriteWork.class, ExplainSQRewriteTask.class));
        taskvec.add(new TaskTuple<ConditionalWork>(ConditionalWork.class, ConditionalTask.class));
        taskvec.add(new TaskTuple<MapredWork>(MapredWork.class, MapRedTask.class));
        taskvec.add(new TaskTuple<MapredLocalWork>(MapredLocalWork.class, MapredLocalTask.class));
        taskvec.add(new TaskTuple<StatsWork>(StatsWork.class, StatsTask.class));
        taskvec.add(new TaskTuple<ColumnStatsUpdateWork>(ColumnStatsUpdateWork.class, ColumnStatsUpdateTask.class));
        taskvec.add(new TaskTuple<MergeFileWork>(MergeFileWork.class, MergeFileTask.class));
        taskvec.add(new TaskTuple<DependencyCollectionWork>(DependencyCollectionWork.class, DependencyCollectionTask.class));
        taskvec.add(new TaskTuple<TezWork>(TezWork.class, TezTask.class));
        taskvec.add(new TaskTuple<SparkWork>(SparkWork.class, SparkTask.class));
        taskvec.add(new TaskTuple<ReplDumpWork>(ReplDumpWork.class, ReplDumpTask.class));
        taskvec.add(new TaskTuple<ReplLoadWork>(ReplLoadWork.class, ReplLoadTask.class));
        taskvec.add(new TaskTuple<ReplStateLogWork>(ReplStateLogWork.class, ReplStateLogTask.class));
        taskvec.add(new TaskTuple<ExportWork>(ExportWork.class, ExportTask.class));
        taskvec.add(new TaskTuple<ReplTxnWork>(ReplTxnWork.class, ReplTxnTask.class));
        taskvec.add(new TaskTuple<ExternalTableCopyTaskBuilder.DirCopyWork>(ExternalTableCopyTaskBuilder.DirCopyWork.class, ExternalTableCopyTaskBuilder.DirCopyTask.class));
        taskvec.add(new TaskTuple<ScheduledQueryMaintenanceWork>(ScheduledQueryMaintenanceWork.class, ScheduledQueryMaintenanceTask.class));
        tid = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
    }

    public static final class TaskTuple<T extends Serializable> {
        public Class<T> workClass;
        public Class<? extends Task<T>> taskClass;

        public TaskTuple(Class<T> workClass, Class<? extends Task<T>> taskClass) {
            this.workClass = workClass;
            this.taskClass = taskClass;
        }
    }
}

