/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hive.common.util.ReflectionUtil;

public class JoinUtil {
    private static final short[] MASKS;
    private static String KEY_FIELD_PREFIX;
    private static String VALUE_FIELD_PREFIX;

    public static List<ObjectInspector>[] getObjectInspectorsFromEvaluators(List<ExprNodeEvaluator>[] exprEntries, ObjectInspector[] inputObjInspector, int posBigTableAlias, int tagLen) throws HiveException {
        List[] result = new List[tagLen];
        int iterate = Math.min(exprEntries.length, inputObjInspector.length);
        for (int alias = 0; alias < iterate; alias = (int)((byte)(alias + 1))) {
            ObjectInspector inputOI = inputObjInspector[alias];
            inputOI = JoinUtil.unflattenObjInspector(inputOI);
            if (alias == (byte)posBigTableAlias || exprEntries[alias] == null || inputOI == null) continue;
            List<ExprNodeEvaluator> exprList = exprEntries[alias];
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>();
            for (int i = 0; i < exprList.size(); ++i) {
                fieldOIList.add(exprList.get(i).initialize(inputOI));
            }
            result[alias] = fieldOIList;
        }
        return result;
    }

    public static List<ObjectInspector>[] getStandardObjectInspectors(List<ObjectInspector>[] aliasToObjectInspectors, int posBigTableAlias, int tagLen) {
        List[] result = new List[tagLen];
        for (int alias = 0; alias < aliasToObjectInspectors.length; alias = (int)((byte)(alias + 1))) {
            if (alias == (byte)posBigTableAlias || aliasToObjectInspectors[alias] == null) continue;
            List<ObjectInspector> oiList = aliasToObjectInspectors[alias];
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>(oiList.size());
            for (int i = 0; i < oiList.size(); ++i) {
                fieldOIList.add(ObjectInspectorUtils.getStandardObjectInspector(oiList.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            }
            result[alias] = fieldOIList;
        }
        return result;
    }

    public static int populateJoinKeyValue(List<ExprNodeEvaluator>[] outMap, Map<Byte, List<ExprNodeDesc>> inputMap, int posBigTableAlias, Configuration conf) throws HiveException {
        return JoinUtil.populateJoinKeyValue(outMap, inputMap, null, posBigTableAlias, conf);
    }

    public static int populateJoinKeyValue(List<ExprNodeEvaluator>[] outMap, Map<Byte, List<ExprNodeDesc>> inputMap, Byte[] order, int posBigTableAlias, Configuration conf) throws HiveException {
        int total = 0;
        for (Map.Entry<Byte, List<ExprNodeDesc>> e : inputMap.entrySet()) {
            if (e.getValue() == null) continue;
            Byte key = order == null ? e.getKey() : order[e.getKey()];
            ArrayList<ExprNodeEvaluator> valueFields = new ArrayList<ExprNodeEvaluator>();
            for (ExprNodeDesc expr : e.getValue()) {
                if (key == (byte)posBigTableAlias) {
                    valueFields.add(null);
                    continue;
                }
                valueFields.add(expr == null ? null : ExprNodeEvaluatorFactory.get(expr, conf));
            }
            outMap[key.byteValue()] = valueFields;
            total += valueFields.size();
        }
        return total;
    }

    public static ArrayList<Object> computeKeys(Object row, List<ExprNodeEvaluator> keyFields, List<ObjectInspector> keyFieldsOI) throws HiveException {
        ArrayList<Object> nr = new ArrayList<Object>(keyFields.size());
        for (int i = 0; i < keyFields.size(); ++i) {
            nr.add(ObjectInspectorUtils.copyToStandardObject(keyFields.get(i).evaluate(row), keyFieldsOI.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
        }
        return nr;
    }

    public static Object[] computeMapJoinValues(Object row, List<ExprNodeEvaluator> valueFields, List<ObjectInspector> valueFieldsOI, List<ExprNodeEvaluator> filters, List<ObjectInspector> filtersOI, int[] filterMap) throws HiveException {
        Object[] nr;
        if (filterMap != null) {
            nr = new Object[valueFields.size() + 1];
            nr[valueFields.size()] = new ShortWritable(JoinUtil.isFiltered(row, filters, filtersOI, filterMap));
        } else {
            nr = new Object[valueFields.size()];
        }
        for (int i = 0; i < valueFields.size(); ++i) {
            nr[i] = ObjectInspectorUtils.copyToStandardObject(valueFields.get(i).evaluate(row), valueFieldsOI.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        return nr;
    }

    public static List<Object> computeValues(Object row, List<ExprNodeEvaluator> valueFields, List<ObjectInspector> valueFieldsOI, boolean hasFilter) throws HiveException {
        int reserve = hasFilter ? valueFields.size() + 1 : valueFields.size();
        ArrayList<Object> nr = new ArrayList<Object>(reserve);
        for (int i = 0; i < valueFields.size(); ++i) {
            nr.add(ObjectInspectorUtils.copyToStandardObject(valueFields.get(i).evaluate(row), valueFieldsOI.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
        }
        return nr;
    }

    protected static boolean isFiltered(Object row, List<ExprNodeEvaluator> filters, List<ObjectInspector> filtersOIs) throws HiveException {
        for (int i = 0; i < filters.size(); ++i) {
            ExprNodeEvaluator evaluator = filters.get(i);
            Object condition = evaluator.evaluate(row);
            Boolean result = (Boolean)((PrimitiveObjectInspector)filtersOIs.get(i)).getPrimitiveJavaObject(condition);
            if (result != null && result.booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected static short isFiltered(Object row, List<ExprNodeEvaluator> filters, List<ObjectInspector> ois, int[] filterMap) throws HiveException {
        short ret = 0;
        int j = 0;
        for (int i = 0; i < filterMap.length; i += 2) {
            int tag = filterMap[i];
            int length = filterMap[i + 1];
            boolean passed = true;
            while (length > 0) {
                if (passed) {
                    Object condition = filters.get(j).evaluate(row);
                    Boolean result = (Boolean)((PrimitiveObjectInspector)ois.get(j)).getPrimitiveJavaObject(condition);
                    if (result == null || !result.booleanValue()) {
                        passed = false;
                    }
                }
                --length;
                ++j;
            }
            if (passed) continue;
            ret = (short)(ret | MASKS[tag]);
        }
        return ret;
    }

    protected static boolean isFiltered(short filter, int tag) {
        return (filter & MASKS[tag]) != 0;
    }

    protected static boolean hasAnyFiltered(short tag) {
        return tag != 0;
    }

    public static TableDesc getSpillTableDesc(Byte alias, TableDesc[] spillTableDesc, JoinDesc conf, boolean noFilter) {
        if (spillTableDesc == null || spillTableDesc.length == 0) {
            spillTableDesc = JoinUtil.initSpillTables(conf, noFilter);
        }
        return spillTableDesc[alias];
    }

    public static AbstractSerDe getSpillSerDe(byte alias, TableDesc[] spillTableDesc, JoinDesc conf, boolean noFilter) {
        TableDesc desc = JoinUtil.getSpillTableDesc(alias, spillTableDesc, conf, noFilter);
        if (desc == null) {
            return null;
        }
        AbstractSerDe sd = (AbstractSerDe)ReflectionUtil.newInstance(desc.getDeserializerClass(), null);
        try {
            SerDeUtils.initializeSerDe(sd, null, desc.getProperties(), null);
        }
        catch (SerDeException e) {
            e.printStackTrace();
            return null;
        }
        return sd;
    }

    public static TableDesc[] initSpillTables(JoinDesc conf, boolean noFilter) {
        int tagLen = conf.getTagLength();
        Map<Byte, List<ExprNodeDesc>> exprs = conf.getExprs();
        TableDesc[] spillTableDesc = new TableDesc[tagLen];
        for (int tag = 0; tag < exprs.size(); ++tag) {
            TableDesc tblDesc;
            List<ExprNodeDesc> valueCols = exprs.get((byte)tag);
            int columnSize = valueCols.size();
            StringBuilder colNames = new StringBuilder();
            StringBuilder colTypes = new StringBuilder();
            if (columnSize <= 0) continue;
            for (int k = 0; k < columnSize; ++k) {
                String newColName = tag + "_VALUE_" + k;
                colNames.append(newColName);
                colNames.append(',');
                colTypes.append(valueCols.get(k).getTypeString());
                colTypes.append(',');
            }
            if (!noFilter) {
                colNames.append("filtered");
                colNames.append(',');
                colTypes.append(TypeInfoFactory.shortTypeInfo.getTypeName());
                colTypes.append(',');
            }
            colNames.setLength(colNames.length() - 1);
            colTypes.setLength(colTypes.length() - 1);
            spillTableDesc[tag] = tblDesc = new TableDesc(SequenceFileInputFormat.class, HiveSequenceFileOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", colNames.toString(), "columns.types", colTypes.toString(), "serialization.lib", LazyBinarySerDe.class.getName()));
        }
        return spillTableDesc;
    }

    public static RowContainer<List<Object>> getRowContainer(Configuration hconf, List<ObjectInspector> structFieldObjectInspectors, Byte alias, int containerSize, TableDesc[] spillTableDesc, JoinDesc conf, boolean noFilter, Reporter reporter) throws HiveException {
        TableDesc tblDesc = JoinUtil.getSpillTableDesc(alias, spillTableDesc, conf, noFilter);
        AbstractSerDe serde = JoinUtil.getSpillSerDe(alias, spillTableDesc, conf, noFilter);
        if (serde == null) {
            containerSize = -1;
        }
        RowContainer<List<Object>> rc = new RowContainer<List<Object>>(containerSize, hconf, reporter);
        StandardStructObjectInspector rcOI = null;
        if (tblDesc != null) {
            List<String> colNames = Utilities.getColumnNames(tblDesc.getProperties());
            rcOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, structFieldObjectInspectors);
        }
        rc.setSerDe(serde, rcOI);
        rc.setTableDesc(tblDesc);
        return rc;
    }

    private static ObjectInspector createStructFromFields(List<StructField> fields, String prefixToRemove) {
        int prefixLength = prefixToRemove.length() + 1;
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (StructField field : fields) {
            fieldNames.add(field.getFieldName().substring(prefixLength));
            fieldOIs.add(field.getFieldObjectInspector());
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    private static ObjectInspector unflattenObjInspector(ObjectInspector oi) {
        if (oi instanceof StructObjectInspector) {
            ArrayList<StructField> keyFields = new ArrayList<StructField>();
            ArrayList<StructField> valueFields = new ArrayList<StructField>();
            for (StructField structField : ((StructObjectInspector)oi).getAllStructFieldRefs()) {
                String fieldNameLower = structField.getFieldName().toLowerCase();
                if (fieldNameLower.startsWith(KEY_FIELD_PREFIX)) {
                    keyFields.add(structField);
                    continue;
                }
                if (fieldNameLower.startsWith(VALUE_FIELD_PREFIX)) {
                    valueFields.add(structField);
                    continue;
                }
                return oi;
            }
            ArrayList<ObjectInspector> reduceFieldOIs = new ArrayList<ObjectInspector>();
            reduceFieldOIs.add(JoinUtil.createStructFromFields(keyFields, Utilities.ReduceField.KEY.toString()));
            reduceFieldOIs.add(JoinUtil.createStructFromFields(valueFields, Utilities.ReduceField.VALUE.toString()));
            return ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, reduceFieldOIs);
        }
        return oi;
    }

    static {
        int num = 32;
        MASKS = new short[num];
        JoinUtil.MASKS[0] = 1;
        for (int idx = 1; idx < num; ++idx) {
            JoinUtil.MASKS[idx] = (short)(2 * MASKS[idx - 1]);
        }
        KEY_FIELD_PREFIX = ((Object)((Object)Utilities.ReduceField.KEY) + ".").toLowerCase();
        VALUE_FIELD_PREFIX = ((Object)((Object)Utilities.ReduceField.VALUE) + ".").toLowerCase();
    }

    public static enum JoinResult {
        MATCH,
        NOMATCH,
        SPILL;

    }
}

