/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.HashMultimap;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;

public final class FunctionUtils {
    private FunctionUtils() {
        throw new UnsupportedOperationException("FunctionUtils should not be instantiated");
    }

    public static FunctionInfo.FunctionResource[] toFunctionResource(List<ResourceUri> resources) throws HiveException {
        if (resources == null) {
            return null;
        }
        FunctionInfo.FunctionResource[] converted = new FunctionInfo.FunctionResource[resources.size()];
        for (int i = 0; i < converted.length; ++i) {
            ResourceUri resource = resources.get(i);
            SessionState.ResourceType type = FunctionUtils.getResourceType(resource.getResourceType());
            converted[i] = new FunctionInfo.FunctionResource(type, resource.getUri());
        }
        return converted;
    }

    public static void addFunctionResources(FunctionInfo.FunctionResource[] resources) throws HiveException {
        if (resources != null) {
            HashMultimap<SessionState.ResourceType, String> mappings = HashMultimap.create();
            for (FunctionInfo.FunctionResource res : resources) {
                mappings.put(res.getResourceType(), res.getResourceURI());
            }
            for (SessionState.ResourceType type : mappings.keys()) {
                SessionState.get().add_resources(type, mappings.get(type));
            }
        }
    }

    public static SessionState.ResourceType getResourceType(ResourceType rt) {
        switch (rt) {
            case JAR: {
                return SessionState.ResourceType.JAR;
            }
            case FILE: {
                return SessionState.ResourceType.FILE;
            }
            case ARCHIVE: {
                return SessionState.ResourceType.ARCHIVE;
            }
        }
        throw new AssertionError((Object)("Unexpected resource type " + rt));
    }

    public static boolean isQualifiedFunctionName(String functionName) {
        return functionName.indexOf(46) >= 0;
    }

    public static String qualifyFunctionName(String functionName, String dbName) {
        if (FunctionUtils.isQualifiedFunctionName(functionName)) {
            return functionName;
        }
        return dbName + "." + functionName;
    }

    public static String[] splitQualifiedFunctionName(String functionName) throws HiveException {
        String[] names = functionName.split("\\.");
        if (names.length == 1) {
            String[] retval = new String[]{null, functionName};
            return retval;
        }
        if (names.length > 2) {
            throw new HiveException("Function name does not have correct format: " + functionName);
        }
        return names;
    }

    public static String[] getQualifiedFunctionNameParts(String name) throws HiveException {
        if (FunctionUtils.isQualifiedFunctionName(name)) {
            return FunctionUtils.splitQualifiedFunctionName(name);
        }
        String dbName = SessionState.get().getCurrentDatabase();
        return new String[]{dbName, name};
    }

    public static UDFClassType getUDFClassType(Class<?> udfClass) {
        if (UDF.class.isAssignableFrom(udfClass)) {
            return UDFClassType.UDF;
        }
        if (GenericUDF.class.isAssignableFrom(udfClass)) {
            return UDFClassType.GENERIC_UDF;
        }
        if (GenericUDTF.class.isAssignableFrom(udfClass)) {
            return UDFClassType.GENERIC_UDTF;
        }
        if (UDAF.class.isAssignableFrom(udfClass)) {
            return UDFClassType.UDAF;
        }
        if (GenericUDAFResolver.class.isAssignableFrom(udfClass)) {
            return UDFClassType.GENERIC_UDAF_RESOLVER;
        }
        if (TableFunctionResolver.class.isAssignableFrom(udfClass)) {
            return UDFClassType.TABLE_FUNCTION_RESOLVER;
        }
        return UDFClassType.UNKNOWN;
    }

    public static enum UDFClassType {
        UNKNOWN,
        UDF,
        GENERIC_UDF,
        GENERIC_UDTF,
        UDAF,
        GENERIC_UDAF_RESOLVER,
        TABLE_FUNCTION_RESOLVER;

    }

    public static enum FunctionType {
        JAVA;

    }
}

