/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FooterBuffer;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveContextAwareRecordReader;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.common.util.AnnotationUtils;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchOperator
implements Serializable {
    static final Logger LOG = LoggerFactory.getLogger((String)FetchOperator.class.getName());
    static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    public static final String FETCH_OPERATOR_DIRECTORY_LIST = "hive.complete.dir.list";
    private FetchWork work;
    private Operator<?> operator;
    private final boolean hasVC;
    private final boolean isStatReader;
    private final boolean isPartitioned;
    private final boolean isNonNativeTable;
    private StructObjectInspector vcsOI;
    private final List<VirtualColumn> vcCols;
    private ExecMapperContext context;
    private transient Deserializer tableSerDe;
    private transient StructObjectInspector tableOI;
    private transient StructObjectInspector partKeyOI;
    private transient StructObjectInspector convertedOI;
    private transient Iterator<Path> iterPath;
    private transient Iterator<PartitionDesc> iterPartDesc;
    private transient Iterator<FetchInputFormatSplit> iterSplits = Collections.emptyIterator();
    private transient Path currPath;
    private transient PartitionDesc currDesc;
    private transient Deserializer currSerDe;
    private transient ObjectInspectorConverters.Converter ObjectConverter;
    private transient RecordReader<WritableComparable, Writable> currRecReader;
    private transient JobConf job;
    private transient WritableComparable key;
    private transient Writable value;
    private transient Object[] vcValues;
    private transient int headerCount;
    private transient int footerCount;
    private transient FooterBuffer footerBuffer;
    private transient StructObjectInspector outputOI;
    private transient Object[] row;
    private static final Map<String, InputFormat> inputFormats = new HashMap<String, InputFormat>();
    private final transient InspectableObject inspectable = new InspectableObject();

    public FetchOperator(FetchWork work, JobConf job) throws HiveException {
        this(work, job, null, null);
    }

    public FetchOperator(FetchWork work, JobConf job, Operator<?> operator, List<VirtualColumn> vcCols) throws HiveException {
        this.job = job;
        this.work = work;
        this.operator = operator;
        if (operator instanceof TableScanOperator) {
            Utilities.addTableSchemaToConf((Configuration)job, (TableScanOperator)operator);
        }
        this.vcCols = vcCols;
        this.hasVC = vcCols != null && !vcCols.isEmpty();
        this.isStatReader = work.getTblDesc() == null;
        this.isPartitioned = !this.isStatReader && work.isPartitioned();
        this.isNonNativeTable = !this.isStatReader && work.getTblDesc().isNonNative();
        this.initialize();
    }

    public void setValidWriteIdList(String writeIdStr) {
        this.job.set("hive.txn.valid.writeids", writeIdStr);
        LOG.debug("FetchOperator set writeIdStr: " + writeIdStr);
    }

    private void initialize() throws HiveException {
        if (this.isStatReader) {
            this.outputOI = this.work.getStatRowOI();
            return;
        }
        if (this.hasVC) {
            ArrayList<String> names = new ArrayList<String>(this.vcCols.size());
            ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>(this.vcCols.size());
            for (VirtualColumn vc : this.vcCols) {
                inspectors.add(vc.getObjectInspector());
                names.add(vc.getName());
            }
            this.vcsOI = ObjectInspectorFactory.getStandardStructObjectInspector(names, inspectors);
            this.vcValues = new Object[this.vcCols.size()];
        }
        this.row = this.hasVC && this.isPartitioned ? new Object[3] : (this.hasVC || this.isPartitioned ? new Object[2] : new Object[1]);
        if (this.isPartitioned) {
            this.iterPath = this.work.getPartDir().iterator();
            this.iterPartDesc = this.work.getPartDesc().iterator();
        } else {
            this.iterPath = Arrays.asList(this.work.getTblDir()).iterator();
            this.iterPartDesc = Iterators.cycle(new PartitionDesc(this.work.getTblDesc(), null));
        }
        this.outputOI = this.setupOutputObjectInspector();
        this.context = this.setupExecContext(this.operator, this.work.getPathLists());
    }

    private ExecMapperContext setupExecContext(Operator operator, List<Path> paths) {
        ExecMapperContext context = null;
        if (this.hasVC || this.work.getSplitSample() != null) {
            context = new ExecMapperContext(this.job);
            if (operator != null) {
                operator.passExecContext(context);
            }
        }
        FetchOperator.setFetchOperatorContext(this.job, paths);
        return context;
    }

    public FetchWork getWork() {
        return this.work;
    }

    public void setWork(FetchWork work) {
        this.work = work;
    }

    public static InputFormat getInputFormatFromCache(Class<? extends InputFormat> inputFormatClass, Configuration conf) throws IOException {
        if (Configurable.class.isAssignableFrom(inputFormatClass) || JobConfigurable.class.isAssignableFrom(inputFormatClass)) {
            return ReflectionUtil.newInstance(inputFormatClass, conf);
        }
        InputFormat format = inputFormats.get(inputFormatClass.getName());
        if (format == null) {
            try {
                format = ReflectionUtil.newInstance(inputFormatClass, conf);
                inputFormats.put(inputFormatClass.getName(), format);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputFormat class " + inputFormatClass.getName() + " as specified in mapredWork!", e);
            }
        }
        return format;
    }

    private StructObjectInspector getPartitionKeyOI(TableDesc tableDesc) throws Exception {
        String pcols = tableDesc.getProperties().getProperty("partition_columns");
        String pcolTypes = tableDesc.getProperties().getProperty("partition_columns.types");
        String[] partKeys = pcols.trim().split("/");
        String[] partKeyTypes = pcolTypes.trim().split(":");
        ObjectInspector[] inspectors = new ObjectInspector[partKeys.length];
        for (int i = 0; i < partKeys.length; ++i) {
            inspectors[i] = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.getPrimitiveTypeInfo(partKeyTypes[i]));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(partKeys), Arrays.asList(inspectors));
    }

    private Object[] createPartValue(PartitionDesc partDesc, StructObjectInspector partOI) {
        LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
        List<? extends StructField> fields = partOI.getAllStructFieldRefs();
        Object[] partValues = new Object[fields.size()];
        for (int i = 0; i < partValues.length; ++i) {
            StructField field = fields.get(i);
            String value = (String)partSpec.get(field.getFieldName());
            ObjectInspector oi = field.getFieldObjectInspector();
            partValues[i] = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, oi).convert(value);
        }
        return partValues;
    }

    private boolean getNextPath() throws Exception {
        while (this.iterPath.hasNext()) {
            this.currPath = this.iterPath.next();
            this.currDesc = this.iterPartDesc.next();
            if (this.isNonNativeTable) {
                return true;
            }
            if (!this.getWork().isSourceTable() && this.getWork().getFilesToFetch() != null && !this.getWork().getFilesToFetch().isEmpty()) {
                return true;
            }
            FileSystem fs = this.currPath.getFileSystem((Configuration)this.job);
            if (!fs.exists(this.currPath)) continue;
            if (this.extractValidWriteIdList() != null && AcidUtils.isInsertOnlyTable(this.currDesc.getTableDesc().getProperties())) {
                return true;
            }
            for (FileStatus fStat : this.listStatusUnderPath(fs, this.currPath)) {
                if (fStat.getLen() <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    static void setFetchOperatorContext(JobConf conf, List<Path> paths) {
        if (paths != null) {
            StringBuilder buff = new StringBuilder();
            for (Path path : paths) {
                if (buff.length() > 0) {
                    buff.append('\t');
                }
                buff.append(StringEscapeUtils.escapeJava(path.toString()));
            }
            conf.set(FETCH_OPERATOR_DIRECTORY_LIST, buff.toString());
        }
    }

    private RecordReader<WritableComparable, Writable> getRecordReader() throws Exception {
        if (!this.iterSplits.hasNext()) {
            FetchInputFormatSplit[] splits = this.getNextSplits();
            if (splits == null) {
                return null;
            }
            if (!this.isPartitioned || this.convertedOI == null) {
                this.currSerDe = this.tableSerDe;
                this.ObjectConverter = null;
            } else {
                this.currSerDe = this.needConversion(this.currDesc) ? this.currDesc.getDeserializer((Configuration)this.job) : this.tableSerDe;
                ObjectInspector inputOI = this.currSerDe.getObjectInspector();
                this.ObjectConverter = ObjectInspectorConverters.getConverter(inputOI, this.convertedOI);
            }
            if (this.isPartitioned) {
                this.row[1] = this.createPartValue(this.currDesc, this.partKeyOI);
            }
            this.iterSplits = Arrays.asList(splits).iterator();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating fetchTask with deserializer typeinfo: " + this.currSerDe.getObjectInspector().getTypeName());
                LOG.debug("deserializer properties:\ntable properties: " + this.currDesc.getTableDesc().getProperties() + "\npartition properties: " + this.currDesc.getProperties());
            }
        }
        final FetchInputFormatSplit target = this.iterSplits.next();
        RecordReader<WritableComparable, Writable> reader = target.getRecordReader(this.job);
        if (this.hasVC || this.work.getSplitSample() != null) {
            this.currRecReader = new HiveRecordReader<WritableComparable, Writable>(reader, this.job){

                @Override
                public boolean doNext(WritableComparable key, Writable value) throws IOException {
                    if (target.shrinkedLength > 0L && FetchOperator.this.context.getIoCxt().getCurrentBlockStart() > target.shrinkedLength) {
                        return false;
                    }
                    return super.doNext(key, value);
                }
            };
            ((HiveContextAwareRecordReader)this.currRecReader).initIOContext(target, this.job, target.inputFormat.getClass(), reader);
        } else {
            this.currRecReader = reader;
        }
        this.key = (WritableComparable)this.currRecReader.createKey();
        this.value = (Writable)this.currRecReader.createValue();
        this.footerCount = 0;
        this.headerCount = 0;
        return this.currRecReader;
    }

    protected FetchInputFormatSplit[] getNextSplits() throws Exception {
        while (this.getNextPath()) {
            String inputs;
            this.job.set("mapred.input.dir", org.apache.hadoop.util.StringUtils.escapeString((String)this.currPath.toString()));
            HiveConf.setBoolVar((Configuration)this.job, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
            Class<? extends InputFormat> formatter = this.currDesc.getInputFileFormatClass();
            Utilities.copyTableJobPropertiesToConf(this.currDesc.getTableDesc(), this.job);
            InputFormat inputFormat = FetchOperator.getInputFormatFromCache(formatter, (Configuration)this.job);
            if (inputFormat instanceof HiveSequenceFileInputFormat) {
                ((HiveSequenceFileInputFormat)inputFormat).setFiles(null);
            }
            ArrayList<Path> dirs = new ArrayList<Path>();
            ArrayList<Path> dirsWithOriginals = new ArrayList<Path>();
            this.processCurrPathForMmWriteIds(inputFormat, dirs, dirsWithOriginals);
            if (dirs.isEmpty() && dirsWithOriginals.isEmpty()) {
                LOG.debug("No valid directories for " + this.currPath);
                continue;
            }
            List<FetchInputFormatSplit> inputSplits = new ArrayList<FetchInputFormatSplit>();
            if (inputFormat instanceof HiveSequenceFileInputFormat && this.getWork().getFilesToFetch() != null && !this.getWork().getFilesToFetch().isEmpty() && !this.getWork().isSourceTable()) {
                HiveSequenceFileInputFormat fileFormat = (HiveSequenceFileInputFormat)inputFormat;
                fileFormat.setFiles(this.getWork().getFilesToFetch());
                InputSplit[] splits = inputFormat.getSplits(this.job, 1);
                for (int i = 0; i < splits.length; ++i) {
                    inputSplits.add(new FetchInputFormatSplit(splits[i], inputFormat));
                }
            } else if (!dirs.isEmpty()) {
                inputs = this.makeInputString(dirs);
                Utilities.FILE_OP_LOGGER.trace("Setting fetch inputs to {}", (Object)inputs);
                this.job.set("mapred.input.dir", inputs);
                this.generateWrappedSplits(inputFormat, inputSplits, this.job);
            }
            if (!dirsWithOriginals.isEmpty()) {
                inputs = this.makeInputString(dirsWithOriginals);
                Utilities.FILE_OP_LOGGER.trace("Setting originals fetch inputs to {}", (Object)inputs);
                JobConf jobNoRec = HiveInputFormat.createConfForMmOriginalsSplit(this.job, dirsWithOriginals);
                jobNoRec.set("mapred.input.dir", inputs);
                this.generateWrappedSplits(inputFormat, inputSplits, jobNoRec);
            }
            if (this.work.getSplitSample() != null) {
                inputSplits = this.splitSampling(this.work.getSplitSample(), inputSplits);
            }
            if (inputSplits.isEmpty()) {
                LOG.debug("No splits for " + this.currPath);
                continue;
            }
            if (HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.HIVE_IN_TEST)) {
                Collections.sort(inputSplits, new FetchInputFormatSplitComparator());
            }
            return inputSplits.toArray(new FetchInputFormatSplit[inputSplits.size()]);
        }
        return null;
    }

    private void generateWrappedSplits(InputFormat inputFormat, List<FetchInputFormatSplit> inputSplits, JobConf job) throws IOException {
        InputSplit[] splits = inputFormat.getSplits(job, 1);
        for (int i = 0; i < splits.length; ++i) {
            inputSplits.add(new FetchInputFormatSplit(splits[i], inputFormat));
        }
    }

    private void processCurrPathForMmWriteIds(InputFormat inputFormat, List<Path> dirs, List<Path> dirsWithOriginals) throws IOException {
        ValidWriteIdList validWriteIdList;
        if (inputFormat instanceof HiveInputFormat) {
            dirs.add(this.currPath);
        }
        if ((validWriteIdList = AcidUtils.isInsertOnlyTable(this.currDesc.getTableDesc().getProperties()) ? this.extractValidWriteIdList() : null) != null) {
            Utilities.FILE_OP_LOGGER.info("Processing " + this.currDesc.getTableName() + " for MM paths");
        }
        HiveInputFormat.processPathsForMmRead(Lists.newArrayList(this.currPath), (Configuration)this.job, validWriteIdList, dirs, dirsWithOriginals);
    }

    private String makeInputString(List<Path> dirs) {
        if (dirs == null || dirs.isEmpty()) {
            return "";
        }
        StringBuffer str = new StringBuffer(org.apache.hadoop.util.StringUtils.escapeString((String)dirs.get(0).toString()));
        for (int i = 1; i < dirs.size(); ++i) {
            str.append(",").append(org.apache.hadoop.util.StringUtils.escapeString((String)dirs.get(i).toString()));
        }
        return str.toString();
    }

    private ValidWriteIdList extractValidWriteIdList() {
        if (this.currDesc.getTableName() == null || !StringUtils.isBlank(this.currDesc.getTableName())) {
            String txnString = this.job.get("hive.txn.valid.writeids");
            LOG.debug("FetchOperator get writeIdStr: " + txnString);
            return txnString == null ? new ValidReaderWriteIdList() : new ValidReaderWriteIdList(txnString);
        }
        return null;
    }

    private List<FetchInputFormatSplit> splitSampling(SplitSample splitSample, List<FetchInputFormatSplit> splits) {
        long totalSize = 0L;
        for (FetchInputFormatSplit split : splits) {
            totalSize += split.getLength();
        }
        ArrayList<FetchInputFormatSplit> result = new ArrayList<FetchInputFormatSplit>(splits.size());
        long targetSize = splitSample.getTargetSize(totalSize);
        int startIndex = splitSample.getSeedNum() % splits.size();
        long size = 0L;
        for (int i = 0; i < splits.size(); ++i) {
            FetchInputFormatSplit split = splits.get((startIndex + i) % splits.size());
            result.add(split);
            long splitgLength = split.getLength();
            if (size + splitgLength >= targetSize) {
                if (size + splitgLength <= targetSize) break;
                split.shrinkedLength = targetSize - size;
                break;
            }
            size += splitgLength;
        }
        return result;
    }

    public boolean pushRow() throws IOException, HiveException {
        if (this.operator == null) {
            return false;
        }
        if (this.work.getRowsComputedUsingStats() != null) {
            for (List<Object> row : this.work.getRowsComputedUsingStats()) {
                this.operator.process(row, 0);
            }
            this.flushRow();
            return true;
        }
        InspectableObject row = this.getNextRow();
        if (row != null) {
            this.pushRow(row);
        } else {
            this.flushRow();
        }
        return row != null;
    }

    protected void pushRow(InspectableObject row) throws HiveException {
        this.operator.process(row.o, 0);
    }

    protected void flushRow() throws HiveException {
        this.operator.flush();
    }

    public InspectableObject getNextRow() throws IOException {
        try {
            while (true) {
                boolean opNotEOF = true;
                if (this.context != null) {
                    this.context.resetRow();
                }
                if (this.currRecReader == null) {
                    this.currRecReader = this.getRecordReader();
                    if (this.currRecReader == null) {
                        return null;
                    }
                    this.headerCount = Utilities.getHeaderCount(this.currDesc.getTableDesc());
                    this.footerCount = Utilities.getFooterCount(this.currDesc.getTableDesc(), this.job);
                    opNotEOF = Utilities.skipHeader(this.currRecReader, this.headerCount, this.key, this.value);
                    if (opNotEOF && this.footerCount > 0) {
                        this.footerBuffer = new FooterBuffer();
                        opNotEOF = this.footerBuffer.initializeBuffer(this.job, this.currRecReader, this.footerCount, this.key, this.value);
                    }
                }
                if (opNotEOF && this.footerBuffer == null) {
                    opNotEOF = this.currRecReader.next((Object)this.key, (Object)this.value);
                }
                if (opNotEOF && this.footerBuffer != null) {
                    opNotEOF = this.footerBuffer.updateBuffer(this.job, this.currRecReader, this.key, this.value);
                }
                if (opNotEOF) {
                    if (this.operator != null && this.context != null && this.context.inputFileChanged()) {
                        this.operator.cleanUpInputFileChanged();
                    }
                    if (this.hasVC) {
                        this.row[this.isPartitioned ? 2 : 1] = MapOperator.populateVirtualColumnValues(this.context, this.vcCols, this.vcValues, this.currSerDe);
                    }
                    Object deserialized = this.currSerDe.deserialize(this.value);
                    if (this.ObjectConverter != null) {
                        deserialized = this.ObjectConverter.convert(deserialized);
                    }
                    if (this.hasVC || this.isPartitioned) {
                        this.row[0] = deserialized;
                        this.inspectable.o = this.row;
                    } else {
                        this.inspectable.o = deserialized;
                    }
                    this.inspectable.oi = this.currSerDe.getObjectInspector();
                    return this.inspectable;
                }
                this.currRecReader.close();
                this.currRecReader = null;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void clearFetchContext() throws HiveException {
        try {
            if (this.currRecReader != null) {
                this.currRecReader.close();
                this.currRecReader = null;
            }
            this.closeOperator();
            if (this.context != null) {
                this.context.clear();
                this.context = null;
            }
            this.currPath = null;
            this.iterPath = null;
            this.iterPartDesc = null;
            this.iterSplits = Collections.emptyIterator();
        }
        catch (Exception e) {
            throw new HiveException("Failed with exception " + e.getMessage() + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        }
    }

    public void closeOperator() throws HiveException {
        if (this.operator != null) {
            this.operator.close(false);
            this.operator = null;
        }
    }

    public void setupContext(List<Path> paths) {
        this.iterPath = paths.iterator();
        this.iterPartDesc = !this.isPartitioned ? Iterators.cycle(new PartitionDesc(this.work.getTblDesc(), null)) : this.work.getPartDescs(paths).iterator();
        this.context = this.setupExecContext(this.operator, paths);
    }

    public ObjectInspector getOutputObjectInspector() {
        return this.outputOI;
    }

    private StructObjectInspector setupOutputObjectInspector() throws HiveException {
        TableDesc tableDesc = this.work.getTblDesc();
        try {
            this.tableSerDe = tableDesc.getDeserializer((Configuration)this.job, true);
            this.tableOI = (StructObjectInspector)this.tableSerDe.getObjectInspector();
            if (!this.isPartitioned) {
                return this.getTableRowOI(this.tableOI);
            }
            this.partKeyOI = this.getPartitionKeyOI(tableDesc);
            PartitionDesc partDesc = new PartitionDesc(tableDesc, null);
            ArrayList<PartitionDesc> listParts = this.work.getPartDesc();
            if (listParts == null || listParts.isEmpty() || !this.needConversion(tableDesc, listParts)) {
                return this.getPartitionedRowOI(this.tableOI);
            }
            this.convertedOI = (StructObjectInspector)ObjectInspectorConverters.getConvertedOI(this.tableOI, this.tableOI, null, false);
            return this.getPartitionedRowOI(this.convertedOI);
        }
        catch (Exception e) {
            throw new HiveException("Failed with exception " + e.getMessage() + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        }
    }

    private StructObjectInspector getTableRowOI(StructObjectInspector valueOI) {
        return this.hasVC ? ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(valueOI, this.vcsOI)) : valueOI;
    }

    private StructObjectInspector getPartitionedRowOI(StructObjectInspector valueOI) {
        return ObjectInspectorFactory.getUnionStructObjectInspector(this.hasVC ? Arrays.asList(valueOI, this.partKeyOI, this.vcsOI) : Arrays.asList(valueOI, this.partKeyOI));
    }

    private boolean needConversion(PartitionDesc partitionDesc) {
        boolean isAcid = AcidUtils.isTablePropertyTransactional(partitionDesc.getTableDesc().getProperties());
        if (Utilities.isSchemaEvolutionEnabled((Configuration)this.job, isAcid) && Utilities.isInputFileFormatSelfDescribing(partitionDesc)) {
            return false;
        }
        return this.needConversion(partitionDesc.getTableDesc(), Arrays.asList(partitionDesc));
    }

    private boolean needConversion(TableDesc tableDesc, List<PartitionDesc> partDescs) {
        Class<? extends Deserializer> tableSerDe = tableDesc.getDeserializerClass();
        SerDeSpec spec = AnnotationUtils.getAnnotation(tableSerDe, SerDeSpec.class);
        if (null == spec) {
            return true;
        }
        String[] schemaProps = spec.schemaProps();
        Properties tableProps = tableDesc.getProperties();
        for (PartitionDesc partitionDesc : partDescs) {
            if (!tableSerDe.getName().equals(partitionDesc.getDeserializerClassName())) {
                return true;
            }
            Properties partProps = partitionDesc.getProperties();
            for (String schemaProp : schemaProps) {
                if (org.apache.commons.lang3.StringUtils.equals(tableProps.getProperty(schemaProp), partProps.getProperty(schemaProp))) continue;
                return true;
            }
        }
        return false;
    }

    private FileStatus[] listStatusUnderPath(FileSystem fs, Path p) throws IOException {
        boolean recursive = this.job.getBoolean("mapreduce.input.fileinputformat.input.dir.recursive", false);
        if (!recursive && !AcidUtils.isAcid(fs, p, (Configuration)this.job)) {
            return fs.listStatus(p, FileUtils.HIDDEN_FILES_PATH_FILTER);
        }
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (FileStatus stat : fs.listStatus(p, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
            FileUtils.listStatusRecursively(fs, stat, results);
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    public Configuration getJobConf() {
        return this.job;
    }

    private static class FetchInputFormatSplitComparator
    implements Comparator<FetchInputFormatSplit> {
        private FetchInputFormatSplitComparator() {
        }

        @Override
        public int compare(FetchInputFormatSplit a, FetchInputFormatSplit b) {
            Path ap = a.getPath();
            Path bp = b.getPath();
            if (ap != null) {
                return ap.compareTo((Object)bp);
            }
            return Long.signum(a.getLength() - b.getLength());
        }
    }

    private static class FetchInputFormatSplit
    extends HiveInputFormat.HiveInputSplit {
        private long shrinkedLength = -1L;
        private final InputFormat inputFormat;

        public FetchInputFormatSplit(InputSplit split, InputFormat inputFormat) {
            super(split, inputFormat.getClass().getName());
            this.inputFormat = inputFormat;
        }

        public RecordReader<WritableComparable, Writable> getRecordReader(JobConf job) throws IOException {
            return this.inputFormat.getRecordReader(this.getInputSplit(), job, Reporter.NULL);
        }
    }
}

