/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileMergeOperator<T extends FileMergeDesc>
extends Operator<T>
implements Serializable {
    public static final String BACKUP_PREFIX = "_backup.";
    public static final String UNION_SUDBIR_PREFIX = "HIVE_UNION_SUBDIR_";
    public static final Logger LOG = LoggerFactory.getLogger(AbstractFileMergeOperator.class);
    protected JobConf jc;
    protected FileSystem fs;
    private boolean autoDelete;
    private Path outPath;
    private Path finalPath;
    private Path dpPath;
    private Path tmpPath;
    private Path taskTmpPath;
    private int listBucketingDepth;
    private boolean hasDynamicPartitions;
    private boolean isListBucketingAlterTableConcatenate;
    private boolean tmpPathFixedConcatenate;
    private boolean tmpPathFixed;
    private Set<Path> incompatFileSet;
    private transient DynamicPartitionCtx dpCtx;
    private boolean isMmTable;
    private String taskId;

    protected AbstractFileMergeOperator() {
    }

    public AbstractFileMergeOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.jc = new JobConf(hconf);
        this.incompatFileSet = new HashSet<Path>();
        this.autoDelete = false;
        this.tmpPathFixed = false;
        this.tmpPathFixedConcatenate = false;
        this.dpPath = null;
        this.dpCtx = ((FileMergeDesc)this.conf).getDpCtx();
        this.hasDynamicPartitions = ((FileMergeDesc)this.conf).hasDynamicPartitions();
        this.isListBucketingAlterTableConcatenate = ((FileMergeDesc)this.conf).isListBucketingAlterTableConcatenate();
        this.listBucketingDepth = ((FileMergeDesc)this.conf).getListBucketingDepth();
        Path specPath = ((FileMergeDesc)this.conf).getOutputPath();
        this.isMmTable = ((FileMergeDesc)this.conf).getIsMmTable();
        if (this.isMmTable) {
            this.updatePaths(specPath, null);
        } else {
            this.updatePaths(Utilities.toTempPath(specPath), Utilities.toTaskTempPath(specPath));
        }
        try {
            this.fs = specPath.getFileSystem(hconf);
            if (!this.isMmTable) {
                this.autoDelete = this.fs.deleteOnExit(this.outPath);
            }
        }
        catch (IOException e) {
            throw new HiveException("Failed to initialize AbstractFileMergeOperator", e);
        }
    }

    private void updatePaths(Path tp, Path ttp) {
        this.taskId = Utilities.getTaskId((Configuration)this.jc);
        this.tmpPath = tp;
        if (this.isMmTable) {
            this.taskTmpPath = null;
            this.outPath = this.finalPath = new Path(this.tmpPath, this.taskId + ".merged");
        } else {
            this.taskTmpPath = ttp;
            this.finalPath = new Path(tp, this.taskId);
            this.outPath = new Path(ttp, Utilities.toTempPath(this.taskId));
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Paths for merge " + this.taskId + ": tmp " + this.tmpPath + ", task " + this.taskTmpPath + ", final " + this.finalPath + ", out " + this.outPath);
        }
    }

    protected void fixTmpPath(Path inputPath, int depthDiff) throws IOException {
        if (depthDiff <= 0) {
            return;
        }
        this.dpPath = inputPath;
        Path newPath = new Path(".");
        while (inputPath != null && depthDiff > 0) {
            newPath = new Path(inputPath.getName(), newPath);
            --depthDiff;
            inputPath = inputPath.getParent();
        }
        Path newTmpPath = new Path(this.tmpPath, newPath);
        if (!this.fs.exists(newTmpPath)) {
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Creating " + newTmpPath);
            }
            this.fs.mkdirs(newTmpPath);
        }
        Path newTaskTmpPath = this.taskTmpPath != null ? new Path(this.taskTmpPath, newPath) : null;
        this.updatePaths(newTmpPath, newTaskTmpPath);
    }

    protected void checkPartitionsMatch(Path inputPath) throws IOException {
        if (!this.dpPath.equals((Object)inputPath)) {
            String msg = "Multiple partitions for one merge mapper: " + this.dpPath + " NOT EQUAL TO " + inputPath;
            LOG.error(msg);
            throw new IOException(msg);
        }
    }

    protected void fixTmpPath(Path path) throws IOException {
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Calling fixTmpPath with " + path);
        }
        if (this.isListBucketingAlterTableConcatenate) {
            if (this.tmpPathFixedConcatenate) {
                this.checkPartitionsMatch(path);
            } else {
                this.fixTmpPath(path, this.listBucketingDepth);
                this.tmpPathFixedConcatenate = true;
            }
        } else if (this.hasDynamicPartitions || this.listBucketingDepth > 0) {
            Path realPartitionPath;
            String name = path.getName();
            Path path2 = realPartitionPath = name.startsWith(UNION_SUDBIR_PREFIX) ? path.getParent() : path;
            if (this.tmpPathFixed) {
                this.checkPartitionsMatch(realPartitionPath);
            } else {
                int depthDiff = realPartitionPath.depth() - this.tmpPath.depth();
                this.fixTmpPath(realPartitionPath, depthDiff);
                this.tmpPathFixed = true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void closeOp(boolean abort) throws HiveException {
        try {
            Path destDir;
            if (abort) {
                if (this.autoDelete && !this.isMmTable) return;
                this.fs.delete(this.outPath, true);
                return;
            }
            if (this.fs.exists(this.outPath)) {
                FileStatus fss = this.fs.getFileStatus(this.outPath);
                if (!this.isMmTable) {
                    if (!this.fs.rename(this.outPath, this.finalPath)) {
                        throw new IOException("Unable to rename " + this.outPath + " to " + this.finalPath);
                    }
                    LOG.info("Renamed path " + this.outPath + " to " + this.finalPath + "(" + fss.getLen() + " bytes).");
                } else {
                    assert (this.finalPath.equals((Object)this.outPath));
                    Utilities.writeCommitManifest(Lists.newArrayList(this.outPath), this.tmpPath.getParent(), this.fs, this.taskId, ((FileMergeDesc)this.conf).getWriteId(), ((FileMergeDesc)this.conf).getStmtId(), null, false);
                    LOG.info("Merged into " + this.finalPath + "(" + fss.getLen() + " bytes).");
                }
            }
            if (this.incompatFileSet == null || this.incompatFileSet.isEmpty()) return;
            if (this.isMmTable) {
                throw new HiveException("Incompatible files should not happen in MM tables.");
            }
            Path destPath = destDir = this.finalPath.getParent();
            if (this.incompatFileSet == null || this.incompatFileSet.isEmpty()) return;
            for (Path incompatFile : this.incompatFileSet) {
                if (!Utilities.isHiveManagedFile(incompatFile)) {
                    String taskId = Utilities.getTaskId((Configuration)this.jc);
                    Path destFilePath = new Path(destDir, new Path(taskId));
                    int counter = 1;
                    while (this.fs.exists(destFilePath)) {
                        destFilePath = new Path(destDir, taskId + "_copy_" + counter);
                        ++counter;
                    }
                    LOG.warn("Path doesn't conform to Hive's expectation. Renaming {} to {}", (Object)incompatFile, (Object)destFilePath);
                    destPath = destFilePath;
                }
                try {
                    Utilities.renameOrMoveFiles(this.fs, incompatFile, destPath);
                    LOG.info("Moved incompatible file " + incompatFile + " to " + destPath);
                }
                catch (HiveException e) {
                    LOG.error("Unable to move " + incompatFile + " to " + destPath);
                    throw new IOException(e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new HiveException("Failed to close AbstractFileMergeOperator", e);
        }
    }

    @Override
    public void jobCloseOp(Configuration hconf, boolean success) throws HiveException {
        try {
            Path outputDir = ((FileMergeDesc)this.conf).getOutputPath();
            FileSystem fs = outputDir.getFileSystem(hconf);
            Long mmWriteId = ((FileMergeDesc)this.conf).getWriteId();
            int stmtId = ((FileMergeDesc)this.conf).getStmtId();
            if (!this.isMmTable) {
                Path backupPath = this.backupOutputPath(fs, outputDir);
                Utilities.mvFileToFinalPath(outputDir, hconf, success, LOG, ((FileMergeDesc)this.conf).getDpCtx(), null, this.reporter);
                if (success) {
                    LOG.info("jobCloseOp moved merged files to output dir: " + outputDir);
                }
                if (backupPath != null) {
                    fs.delete(backupPath, true);
                }
            } else {
                int dpLevels = this.dpCtx == null ? 0 : this.dpCtx.getNumDPCols();
                int lbLevels = ((FileMergeDesc)this.conf).getListBucketingDepth();
                Utilities.handleDirectInsertTableFinalPath(outputDir.getParent(), null, hconf, success, dpLevels, lbLevels, null, mmWriteId, stmtId, this.reporter, this.isMmTable, false, false, false);
            }
        }
        catch (IOException e) {
            throw new HiveException("Failed jobCloseOp for AbstractFileMergeOperator", e);
        }
        super.jobCloseOp(hconf, success);
    }

    private Path backupOutputPath(FileSystem fs, Path outpath) throws IOException, HiveException {
        if (fs.exists(outpath)) {
            Path backupPath = new Path(outpath.getParent(), BACKUP_PREFIX + outpath.getName());
            Utilities.rename(fs, outpath, backupPath);
            return backupPath;
        }
        return null;
    }

    @Override
    public String getName() {
        return AbstractFileMergeOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MERGE";
    }

    protected final Path getOutPath() {
        return this.outPath;
    }

    protected final void addIncompatibleFile(Path path) {
        this.incompatFileSet.add(path);
    }
}

