/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.create;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Pool", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateWMPoolDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 4872940135771213510L;
    private final String resourcePlanName;
    private final String poolPath;
    private final double allocFraction;
    private final int queryParallelism;
    private final String schedulingPolicy;

    public CreateWMPoolDesc(String resourcePlanName, String poolPath, double allocFraction, int queryParallelism, String schedulingPolicy) {
        this.resourcePlanName = resourcePlanName;
        this.poolPath = poolPath;
        this.allocFraction = allocFraction;
        this.queryParallelism = queryParallelism;
        this.schedulingPolicy = schedulingPolicy;
    }

    @Explain(displayName="Resource plan name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getResourcePlanName() {
        return this.resourcePlanName;
    }

    @Explain(displayName="Pool path", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getPoolPath() {
        return this.poolPath;
    }

    @Explain(displayName="Alloc fraction", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public double getAllocFraction() {
        return this.allocFraction;
    }

    @Explain(displayName="Query parallelism", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public int getQueryParallelism() {
        return this.queryParallelism;
    }

    @Explain(displayName="Scheduling policy", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getSchedulingPolicy() {
        return this.schedulingPolicy;
    }
}

