/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.show;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.materialized.show.ShowMaterializedViewsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ShowMaterializedViewsOperation
extends DDLOperation<ShowMaterializedViewsDesc> {
    public ShowMaterializedViewsOperation(DDLOperationContext context, ShowMaterializedViewsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        String dbName = ((ShowMaterializedViewsDesc)this.desc).getDbName();
        String pattern = ((ShowMaterializedViewsDesc)this.desc).getPattern();
        String resultsFile = ((ShowMaterializedViewsDesc)this.desc).getResFile();
        if (!this.context.getDb().databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        ArrayList<Table> tableObjects = new ArrayList<Table>(this.context.getDb().getMaterializedViewObjectsByPattern(dbName, pattern));
        LOG.debug("Found {} materialized view(s) matching the SHOW MATERIALIZED VIEWS statement.", (Object)tableObjects.size());
        try (DataOutputStream os = DDLUtils.getOutputStream(new Path(resultsFile), this.context);){
            Collections.sort(tableObjects, Comparator.comparing(Table::getTableName));
            this.context.getFormatter().showMaterializedViews(os, tableObjects);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "in database" + dbName);
        }
        return 0;
    }
}

