/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.show;

import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.view.materialized.show.ShowMaterializedViewsDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

@DDLSemanticAnalyzerFactory.DDLType(types={1052})
public class ShowMaterializedViewsAnalyzer
extends BaseSemanticAnalyzer {
    public ShowMaterializedViewsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() > 3) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String dbName = SessionState.get().getCurrentDatabase();
        String viewNames = null;
        switch (root.getChildCount()) {
            case 1: {
                viewNames = ShowMaterializedViewsAnalyzer.unescapeSQLString(root.getChild(0).getText());
                break;
            }
            case 2: {
                assert (root.getChild(0).getType() == 889);
                dbName = ShowMaterializedViewsAnalyzer.unescapeIdentifier(root.getChild(1).getText());
                this.db.validateDatabaseExists(dbName);
                break;
            }
            case 3: {
                assert (root.getChild(0).getType() == 889);
                dbName = ShowMaterializedViewsAnalyzer.unescapeIdentifier(root.getChild(1).getText());
                viewNames = ShowMaterializedViewsAnalyzer.unescapeSQLString(root.getChild(2).getText());
                this.db.validateDatabaseExists(dbName);
                break;
            }
        }
        ShowMaterializedViewsDesc desc = new ShowMaterializedViewsDesc(this.ctx.getResFile(), dbName, viewNames);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("mv_name,rewrite_enabled,mode#string:string:string"));
    }
}

