/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite;

import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite.AlterMaterializedViewRewriteDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterMaterializedViewRewriteOperation
extends DDLOperation<AlterMaterializedViewRewriteDesc> {
    public AlterMaterializedViewRewriteOperation(DDLOperationContext context, AlterMaterializedViewRewriteDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table mv = this.context.getDb().getTable(((AlterMaterializedViewRewriteDesc)this.desc).getMaterializedViewName());
        if (mv.isRewriteEnabled() == ((AlterMaterializedViewRewriteDesc)this.desc).isRewriteEnable()) {
            return 0;
        }
        Table newMV = mv.copy();
        newMV.setRewriteEnabled(((AlterMaterializedViewRewriteDesc)this.desc).isRewriteEnable());
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        this.context.getDb().alterTable(newMV, false, environmentContext, true);
        return 0;
    }
}

