/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.serde;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.storage.serde.AlterTableSetSerdeDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={775, 748})
public class AlterTableSetSerdeAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableSetSerdeAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        String serdeName = AlterTableSetSerdeAnalyzer.unescapeSQLString(command.getChild(0).getText());
        Map<String, String> props = command.getChildCount() > 1 ? AlterTableSetSerdeAnalyzer.getProps((ASTNode)command.getChild(1).getChild(0)) : null;
        AlterTableSetSerdeDesc desc = new AlterTableSetSerdeDesc(tableName, partitionSpec, props, serdeName);
        this.addInputsOutputsAlterTable(tableName, partitionSpec, desc, AlterTableType.SET_SERDE, false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

