/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.concatenate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.storage.concatenate.AlterTableConcatenateDesc;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.RCFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;

public class AlterTableConcatenateOperation
extends DDLOperation<AlterTableConcatenateDesc> {
    public AlterTableConcatenateOperation(DDLOperationContext context, AlterTableConcatenateDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Context generalContext = this.context.getContext();
        MergeFileWork mergeWork = this.getMergeFileWork(generalContext.getOpContext());
        Task<?> task = this.getTask(mergeWork);
        return this.executeTask(generalContext, task);
    }

    private MergeFileWork getMergeFileWork(CompilationOpContext opContext) {
        ArrayList<Path> inputDirList = Lists.newArrayList(((AlterTableConcatenateDesc)this.desc).getInputDir());
        MergeFileWork mergeWork = new MergeFileWork(inputDirList, ((AlterTableConcatenateDesc)this.desc).getOutputDir(), ((AlterTableConcatenateDesc)this.desc).getInputFormatClass().getName(), ((AlterTableConcatenateDesc)this.desc).getTableDesc());
        mergeWork.setListBucketingCtx(((AlterTableConcatenateDesc)this.desc).getLbCtx());
        mergeWork.resolveConcatenateMerge(this.context.getDb().getConf());
        mergeWork.setMapperCannotSpanPartns(true);
        mergeWork.setSourceTableInputFormat(((AlterTableConcatenateDesc)this.desc).getInputFormatClass().getName());
        LinkedHashMap<Path, List<String>> pathToAliases = new LinkedHashMap<Path, List<String>>();
        ArrayList<String> inputDirStr = Lists.newArrayList(((Object)inputDirList).toString());
        pathToAliases.put(((AlterTableConcatenateDesc)this.desc).getInputDir(), inputDirStr);
        mergeWork.setPathToAliases(pathToAliases);
        FileMergeDesc fmd = this.getFileMergeDesc();
        Operator<FileMergeDesc> mergeOp = OperatorFactory.get(opContext, fmd);
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
        aliasToWork.put(((Object)inputDirList).toString(), mergeOp);
        mergeWork.setAliasToWork(aliasToWork);
        return mergeWork;
    }

    private FileMergeDesc getFileMergeDesc() {
        FileMergeDesc fmd = ((AlterTableConcatenateDesc)this.desc).getInputFormatClass().equals(RCFileInputFormat.class) ? new RCFileMergeDesc() : new OrcFileMergeDesc();
        ListBucketingCtx lbCtx = ((AlterTableConcatenateDesc)this.desc).getLbCtx();
        boolean lbatc = lbCtx == null ? false : lbCtx.isSkewedStoredAsDir();
        int lbd = lbCtx == null ? 0 : lbCtx.calculateListBucketingLevel();
        fmd.setDpCtx(null);
        fmd.setHasDynamicPartitions(false);
        fmd.setListBucketingAlterTableConcatenate(lbatc);
        fmd.setListBucketingDepth(lbd);
        fmd.setOutputPath(((AlterTableConcatenateDesc)this.desc).getOutputDir());
        return fmd;
    }

    private Task<?> getTask(MergeFileWork mergeWork) {
        if (this.context.getConf().getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            TezWork tezWork = new TezWork(this.context.getQueryState().getQueryId(), this.context.getConf());
            mergeWork.setName("File Merge");
            tezWork.add(mergeWork);
            TezTask task = new TezTask();
            task.setWork(tezWork);
            return task;
        }
        MergeFileTask task = new MergeFileTask();
        task.setWork(mergeWork);
        return task;
    }

    private int executeTask(Context generalContext, Task<?> task) {
        TaskQueue taskQueue = new TaskQueue();
        task.initialize(this.context.getQueryState(), this.context.getQueryPlan(), taskQueue, generalContext);
        int ret = task.execute();
        if (task.getException() != null) {
            this.context.getTask().setException(task.getException());
        }
        return ret;
    }
}

