/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.compact;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Compact", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableCompactDesc
implements DDLDesc {
    private final String tableName;
    private final Map<String, String> partitionSpec;
    private final String compactionType;
    private final boolean isBlocking;
    private final Map<String, String> properties;

    public AlterTableCompactDesc(TableName tableName, Map<String, String> partitionSpec, String compactionType, boolean isBlocking, Map<String, String> properties) {
        this.tableName = tableName.getNotEmptyDbTable();
        this.partitionSpec = partitionSpec;
        this.compactionType = compactionType;
        this.isBlocking = isBlocking;
        this.properties = properties;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    @Explain(displayName="partition spec", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    @Explain(displayName="compaction type", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getCompactionType() {
        return this.compactionType;
    }

    @Explain(displayName="blocking", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Explain(displayName="properties", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

