/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.rename;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.rename.AlterTableRenamePartitionDesc;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;

public class AlterTableRenamePartitionOperation
extends DDLOperation<AlterTableRenamePartitionDesc> {
    public AlterTableRenamePartitionOperation(DDLOperationContext context, AlterTableRenamePartitionDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        String tableName = ((AlterTableRenamePartitionDesc)this.desc).getTableName();
        Map<String, String> oldPartSpec = ((AlterTableRenamePartitionDesc)this.desc).getOldPartSpec();
        ReplicationSpec replicationSpec = ((AlterTableRenamePartitionDesc)this.desc).getReplicationSpec();
        if (!AlterTableUtils.allowOperationInReplicationScope(this.context.getDb(), tableName, oldPartSpec, replicationSpec)) {
            LOG.debug("DDLTask: Rename Partition is skipped as table {} / partition {} is newer than update", (Object)tableName, (Object)FileUtils.makePartName(new ArrayList<String>(oldPartSpec.keySet()), new ArrayList<String>(oldPartSpec.values())));
            return 0;
        }
        if (Utils.isBootstrapDumpInProgress(this.context.getDb(), HiveTableName.of(tableName).getDb())) {
            LOG.error("DDLTask: Rename Partition not allowed as bootstrap dump in progress");
            throw new HiveException("Rename Partition: Not allowed as bootstrap dump in progress");
        }
        Table tbl = this.context.getDb().getTable(tableName);
        Partition oldPart = this.context.getDb().getPartition(tbl, oldPartSpec, false);
        if (oldPart == null) {
            String partName = FileUtils.makePartName(new ArrayList<String>(oldPartSpec.keySet()), new ArrayList<String>(oldPartSpec.values()));
            throw new HiveException("Rename partition: source partition [" + partName + "] does not exist.");
        }
        Partition part = this.context.getDb().getPartition(tbl, oldPartSpec, false);
        part.setValues(((AlterTableRenamePartitionDesc)this.desc).getNewPartSpec());
        long writeId = ((AlterTableRenamePartitionDesc)this.desc).getWriteId();
        if (((AlterTableRenamePartitionDesc)this.desc).getReplicationSpec() != null && ((AlterTableRenamePartitionDesc)this.desc).getReplicationSpec().isMigratingToTxnTable()) {
            Long tmpWriteId = ReplUtils.getMigrationCurrentTblWriteId(this.context.getConf());
            if (tmpWriteId == null) {
                throw new HiveException("DDLTask : Write id is not set in the config by open txn task for migration");
            }
            writeId = tmpWriteId;
        }
        this.context.getDb().renamePartition(tbl, oldPartSpec, part, writeId);
        Partition newPart = this.context.getDb().getPartition(tbl, ((AlterTableRenamePartitionDesc)this.desc).getNewPartSpec(), false);
        this.context.getWork().getInputs().add(new ReadEntity(oldPart));
        DDLUtils.addIfAbsentByName(new WriteEntity(newPart, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
        return 0;
    }
}

