/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.add;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AbstractAddPartitionAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

@DDLSemanticAnalyzerFactory.DDLType(types={784})
public class AlterViewAddPartitionAnalyzer
extends AbstractAddPartitionAnalyzer {
    private static final String VIEW_VALIDATE_QUERY = "SELECT *%n  FROM %s%n WHERE %s";

    public AlterViewAddPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected boolean expectView() {
        return true;
    }

    @Override
    protected boolean allowLocation() {
        return false;
    }

    @Override
    protected void postProcess(TableName tableName, Table table, AlterTableAddPartitionDesc desc, Task<DDLWork> ddlTask) throws SemanticException {
        String dbTable = HiveUtils.unparseIdentifier(tableName.getDb()) + "." + HiveUtils.unparseIdentifier(tableName.getTable());
        StringBuilder where = new StringBuilder();
        boolean firstOr = true;
        for (int i = 0; i < desc.getPartitionCount(); ++i) {
            AlterTableAddPartitionDesc.PartitionDesc partitionDesc = desc.getPartition(i);
            if (firstOr) {
                firstOr = false;
            } else {
                where.append(" OR ");
            }
            boolean firstAnd = true;
            where.append("(");
            for (Map.Entry<String, String> entry : partitionDesc.getPartSpec().entrySet()) {
                if (firstAnd) {
                    firstAnd = false;
                } else {
                    where.append(" AND ");
                }
                where.append(HiveUtils.unparseIdentifier(entry.getKey()));
                where.append(" = '");
                where.append(HiveUtils.escapeString(entry.getValue()));
                where.append("'");
            }
            where.append(")");
        }
        String query = String.format(VIEW_VALIDATE_QUERY, dbTable, where.toString());
        SessionState ss = SessionState.get();
        String uName = ss == null ? null : ss.getUserName();
        try (Driver driver = new Driver(this.conf, uName, this.queryState.getLineageState());){
            int rc = driver.compile(query, false);
            if (rc != 0) {
                throw new SemanticException(ErrorMsg.NO_VALID_PARTN.getMsg());
            }
            this.inputs.addAll(driver.getPlan().getInputs());
        }
    }
}

