/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.add;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Add Partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableAddPartitionDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    String dbName;
    boolean ifNotExists;
    List<PartitionDesc> partitions = null;
    boolean replaceMode = false;
    private ReplicationSpec replicationSpec = null;

    public AlterTableAddPartitionDesc() {
    }

    public AlterTableAddPartitionDesc(String dbName, String tableName, boolean ifNotExists) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.ifNotExists = ifNotExists;
    }

    @Deprecated
    public AlterTableAddPartitionDesc(String dbName, String tableName, Map<String, String> partSpec, String location, Map<String, String> params) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.ifNotExists = true;
        this.addPartition(partSpec, location, params);
    }

    public void addPartition(Map<String, String> partSpec, String location) {
        this.addPartition(partSpec, location, null);
    }

    public void addPartition(Map<String, String> partSpec, String location, Map<String, String> params) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<PartitionDesc>();
        }
        this.partitions.add(new PartitionDesc(partSpec, location, params));
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Explain(displayName="Location")
    public String getLocationForExplain() {
        if (this.partitions == null || this.partitions.isEmpty()) {
            return "<no partition>";
        }
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (PartitionDesc desc : this.partitions) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(desc.location);
        }
        return sb.toString();
    }

    @Explain(displayName="Spec")
    public String getPartSpecStringForExplain() {
        if (this.partitions == null || this.partitions.isEmpty()) {
            return "<no partition>";
        }
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (PartitionDesc desc : this.partitions) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(desc.partSpec.toString());
        }
        return sb.toString();
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public int getPartitionCount() {
        return this.partitions.size();
    }

    public PartitionDesc getPartition(int i) {
        return this.partitions.get(i);
    }

    public void setReplaceMode(boolean replaceMode) {
        this.replaceMode = replaceMode;
    }

    public boolean getReplaceMode() {
        return this.replaceMode;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    public static class PartitionDesc {
        Map<String, String> partSpec;
        Map<String, String> partParams;
        String location;
        String inputFormat = null;
        String outputFormat = null;
        int numBuckets = -1;
        List<FieldSchema> cols = null;
        String serializationLib = null;
        Map<String, String> serdeParams = null;
        List<String> bucketCols = null;
        List<Order> sortCols = null;
        ColumnStatistics colStats = null;
        long writeId = -1L;

        PartitionDesc(Map<String, String> partSpec, String location, Map<String, String> params) {
            this(partSpec, location);
            this.partParams = params;
        }

        PartitionDesc(Map<String, String> partSpec, String location) {
            this.partSpec = partSpec;
            this.location = location;
        }

        public Map<String, String> getPartSpec() {
            return this.partSpec;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public Map<String, String> getPartParams() {
            return this.partParams;
        }

        public void setPartParams(Map<String, String> partParams) {
            this.partParams = partParams;
        }

        public int getNumBuckets() {
            return this.numBuckets;
        }

        public void setNumBuckets(int numBuckets) {
            this.numBuckets = numBuckets;
        }

        public List<FieldSchema> getCols() {
            return this.cols;
        }

        public void setCols(List<FieldSchema> cols) {
            this.cols = cols;
        }

        public String getSerializationLib() {
            return this.serializationLib;
        }

        public void setSerializationLib(String serializationLib) {
            this.serializationLib = serializationLib;
        }

        public Map<String, String> getSerdeParams() {
            return this.serdeParams;
        }

        public void setSerdeParams(Map<String, String> serdeParams) {
            this.serdeParams = serdeParams;
        }

        public List<String> getBucketCols() {
            return this.bucketCols;
        }

        public void setBucketCols(List<String> bucketCols) {
            this.bucketCols = bucketCols;
        }

        public List<Order> getSortCols() {
            return this.sortCols;
        }

        public void setSortCols(List<Order> sortCols) {
            this.sortCols = sortCols;
        }

        public String getInputFormat() {
            return this.inputFormat;
        }

        public void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        public String getOutputFormat() {
            return this.outputFormat;
        }

        public void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public ColumnStatistics getColStats() {
            return this.colStats;
        }

        public void setColStats(ColumnStatistics colStats) {
            this.colStats = colStats;
        }

        public long getWriteId() {
            return this.writeId;
        }

        public void setWriteId(long writeId) {
            this.writeId = writeId;
        }
    }
}

