/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.touch;

import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.misc.touch.AlterTableTouchDesc;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableTouchOperation
extends DDLOperation<AlterTableTouchDesc> {
    public AlterTableTouchOperation(DDLOperationContext context, AlterTableTouchDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table table = this.context.getDb().getTable(((AlterTableTouchDesc)this.desc).getTableName());
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        if (((AlterTableTouchDesc)this.desc).getPartitionSpec() == null) {
            this.context.getDb().alterTable(table, false, environmentContext, true);
            this.context.getWork().getInputs().add(new ReadEntity(table));
            DDLUtils.addIfAbsentByName(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
        } else {
            Partition part = this.context.getDb().getPartition(table, ((AlterTableTouchDesc)this.desc).getPartitionSpec(), false);
            if (part == null) {
                throw new HiveException("Specified partition does not exist");
            }
            try {
                this.context.getDb().alterPartition(table.getCatalogName(), table.getDbName(), table.getTableName(), part, environmentContext, true);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
            this.context.getWork().getInputs().add(new ReadEntity(part));
            DDLUtils.addIfAbsentByName(new WriteEntity(part, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
        }
        return 0;
    }
}

