/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.rename;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.misc.rename.AlterTableRenameDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public abstract class AbstractAlterTableRenameAnalyzer
extends AbstractAlterTableAnalyzer {
    public AbstractAlterTableRenameAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        TableName target = AbstractAlterTableRenameAnalyzer.getQualifiedTableName((ASTNode)command.getChild(0));
        AlterTableRenameDesc desc = new AlterTableRenameDesc(tableName, null, this.isView(), target.getNotEmptyDbTable());
        Table table = this.getTable(tableName.getNotEmptyDbTable(), true);
        if (AcidUtils.isTransactionalTable(table)) {
            this.setAcidDdlDesc(desc);
        }
        this.addInputsOutputsAlterTable(tableName, null, desc, desc.getType(), false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    protected abstract boolean isView();
}

