/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.lock.show;

import java.util.Map;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.lock.show.ShowLocksDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1051})
public class ShowLocksAnalyzer
extends BaseSemanticAnalyzer {
    public ShowLocksAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String tableName = null;
        Map<String, String> partitionSpec = null;
        boolean isExtended = false;
        if (root.getChildCount() >= 1) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                ASTNode child = (ASTNode)root.getChild(i);
                if (child.getType() == 1120) {
                    tableName = DDLUtils.getFQName((ASTNode)child.getChild(0));
                    if (child.getChildCount() != 2) continue;
                    ASTNode partitionSpecNode = (ASTNode)child.getChild(1);
                    partitionSpec = ShowLocksAnalyzer.getValidatedPartSpec(this.getTable(tableName), partitionSpecNode, this.conf, false);
                    continue;
                }
                if (child.getType() != 132) continue;
                isExtended = true;
            }
        }
        HiveTxnManager txnManager = null;
        try {
            txnManager = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        }
        catch (LockException e) {
            throw new SemanticException(e.getMessage());
        }
        ShowLocksDesc desc = new ShowLocksDesc(this.ctx.getResFile(), tableName, partitionSpec, isExtended, txnManager.useNewShowLocksFormat());
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }
}

