/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.lock.show;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.lock.show.ShowLocksDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1049})
public class ShowDbLocksAnalyzer
extends BaseSemanticAnalyzer {
    public ShowDbLocksAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String dbName = ShowDbLocksAnalyzer.stripQuotes(root.getChild(0).getText());
        boolean isExtended = root.getChildCount() > 1;
        HiveTxnManager txnManager = null;
        try {
            txnManager = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        }
        catch (LockException e) {
            throw new SemanticException(e.getMessage());
        }
        ShowLocksDesc desc = new ShowLocksDesc(this.ctx.getResFile(), dbName, isExtended, txnManager.useNewShowLocksFormat());
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }
}

