/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.status;

import java.util.Map;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

@DDLSemanticAnalyzerFactory.DDLType(types={1065})
public class ShowTableStatusAnalyzer
extends BaseSemanticAnalyzer {
    public ShowTableStatusAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() > 3 || root.getChildCount() < 1) {
            throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg());
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String tableNames = ShowTableStatusAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        String dbName = SessionState.get().getCurrentDatabase();
        Map<String, String> partitionSpec = null;
        if (root.getChildCount() > 1) {
            for (int i = 1; i < root.getChildCount(); ++i) {
                ASTNode child = (ASTNode)root.getChild(i);
                if (child.getToken().getType() == 24) {
                    dbName = ShowTableStatusAnalyzer.unescapeIdentifier(child.getText());
                    continue;
                }
                if (child.getToken().getType() == 982) {
                    partitionSpec = ShowTableStatusAnalyzer.getValidatedPartSpec(this.getTable(tableNames), child, this.conf, false);
                    continue;
                }
                throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg(child.toStringTree() + " , Invalid token " + child.getToken().getType()));
            }
        }
        if (partitionSpec != null) {
            PartitionUtils.getPartition(this.db, this.getTable(HiveTableName.of(tableNames)), partitionSpec, true);
        }
        ShowTableStatusDesc desc = new ShowTableStatusDesc(this.ctx.getResFile(), dbName, tableNames, partitionSpec);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("tab_name#string"));
    }
}

