/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create.show;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.create.show.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1058})
public class ShowCreateTableAnalyzer
extends BaseSemanticAnalyzer {
    public ShowCreateTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String tableName = ShowCreateTableAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        Table tab = this.getTable(tableName);
        this.inputs.add(new ReadEntity(tab));
        ShowCreateTableDesc desc = new ShowCreateTableDesc(tableName, this.ctx.getResFile().toString());
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("createtab_stmt#string"));
    }
}

