/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.constraint.add;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.constraint.Constraints;
import org.apache.hadoop.hive.ql.ddl.table.constraint.ConstraintsUtils;
import org.apache.hadoop.hive.ql.ddl.table.constraint.add.AlterTableAddConstraintDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={753})
public class AlterTableAddConstraintAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableAddConstraintAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        ArrayList<SQLPrimaryKey> primaryKeys = new ArrayList<SQLPrimaryKey>();
        ArrayList<SQLForeignKey> foreignKeys = new ArrayList<SQLForeignKey>();
        ArrayList<SQLUniqueConstraint> uniqueConstraints = new ArrayList<SQLUniqueConstraint>();
        ArrayList<SQLCheckConstraint> checkConstraints = new ArrayList<SQLCheckConstraint>();
        ASTNode constraintNode = (ASTNode)command.getChild(0);
        switch (constraintNode.getToken().getType()) {
            case 1139: {
                ConstraintsUtils.processUniqueConstraints(tableName, constraintNode, uniqueConstraints);
                break;
            }
            case 986: {
                ConstraintsUtils.processPrimaryKeys(tableName, constraintNode, primaryKeys);
                break;
            }
            case 888: {
                ConstraintsUtils.processForeignKeys(tableName, constraintNode, foreignKeys);
                break;
            }
            case 815: {
                ConstraintsUtils.processCheckConstraints(tableName, constraintNode, null, checkConstraints, command, this.ctx.getTokenRewriteStream());
                break;
            }
            default: {
                throw new SemanticException(ErrorMsg.NOT_RECOGNIZED_CONSTRAINT.getMsg(constraintNode.getToken().getText()));
            }
        }
        Constraints constraints = new Constraints(primaryKeys, foreignKeys, null, uniqueConstraints, null, checkConstraints);
        AlterTableAddConstraintDesc desc = new AlterTableAddConstraintDesc(tableName, null, constraints);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

